/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.InhabitantParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.InhabitantAnnotation;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.MultiMap;

public class InhabitantIntrospectionScanner
implements Iterable<InhabitantParser> {
    final Iterator<AnnotatedElement> inhabitantAnnotations;
    Iterator<AnnotatedElement> current;

    public InhabitantIntrospectionScanner(ParsingContext context) {
        Types types = context.getTypes();
        AnnotationType am = types.getBy(AnnotationType.class, InhabitantAnnotation.class.getName());
        if (am == null) {
            this.inhabitantAnnotations = Collections.EMPTY_LIST.iterator();
        } else {
            Collection<AnnotatedElement> ccc = am.allAnnotatedTypes();
            this.inhabitantAnnotations = ccc.iterator();
        }
        this.fetch();
    }

    private void fetch() {
        if (!this.inhabitantAnnotations.hasNext()) {
            this.current = Collections.EMPTY_LIST.iterator();
            return;
        }
        do {
            AnnotationType am = (AnnotationType)AnnotationType.class.cast(this.inhabitantAnnotations.next());
            this.current = am.allAnnotatedTypes().iterator();
        } while (!this.current.hasNext() && this.inhabitantAnnotations.hasNext());
    }

    public boolean isContract(AnnotatedElement type) {
        return type.getAnnotation(Contract.class.getName()) != null;
    }

    public void findClassContracts(ClassModel cm, List<InterfaceModel> interfaces) {
        for (InterfaceModel im : cm.getInterfaces()) {
            if (!this.isContract(im)) continue;
            interfaces.add(im);
        }
        this.findContractsFromAnnotations(cm, interfaces);
    }

    public void findInterfaceContracts(InterfaceModel im, List<InterfaceModel> interfaces) {
        if (im.getParent() != null) {
            this.findInterfaceContracts((InterfaceModel)im.getParent(), interfaces);
        }
        if (this.isContract(im)) {
            interfaces.add(im);
        }
        this.findContractsFromAnnotations(im, interfaces);
    }

    public void findContractsFromAnnotations(AnnotatedElement ae, List<InterfaceModel> interfaces) {
        for (AnnotationModel am : ae.getAnnotations()) {
            this.findInterfaceContracts(am.getType(), interfaces);
        }
    }

    public void findContracts(ClassModel cm, List<InterfaceModel> interfaces) {
        for (InterfaceModel im : cm.getInterfaces()) {
            if (!this.isContract(im)) continue;
            interfaces.add(im);
        }
        this.findContractsFromAnnotations(cm, interfaces);
    }

    @Override
    public Iterator<InhabitantParser> iterator() {
        return new Iterator<InhabitantParser>(){

            @Override
            public boolean hasNext() {
                return InhabitantIntrospectionScanner.this.current.hasNext();
            }

            @Override
            public InhabitantParser next() {
                final AnnotatedElement ae = InhabitantIntrospectionScanner.this.current.next();
                InhabitantParser ip = new InhabitantParser(){

                    @Override
                    public Iterable<String> getIndexes() {
                        if (ae instanceof ClassModel) {
                            final ClassModel cm = (ClassModel)ae;
                            ArrayList<InterfaceModel> implInterfaces = new ArrayList<InterfaceModel>();
                            InhabitantIntrospectionScanner.this.findContracts(cm, implInterfaces);
                            final Iterator interfaces = implInterfaces.iterator();
                            return new Iterable<String>(){

                                @Override
                                public Iterator<String> iterator() {
                                    return new Iterator<String>(){

                                        @Override
                                        public boolean hasNext() {
                                            return interfaces.hasNext();
                                        }

                                        @Override
                                        public String next() {
                                            AnnotationModel am = cm.getAnnotation(Service.class.getName());
                                            String contract = ((InterfaceModel)interfaces.next()).getName();
                                            String name = (String)am.getValues().get("name");
                                            if (name == null || name.isEmpty()) {
                                                return contract;
                                            }
                                            return contract + ":" + name;
                                        }

                                        @Override
                                        public void remove() {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                            };
                        }
                        return new ArrayList<String>();
                    }

                    @Override
                    public String getImplName() {
                        return ae.getName();
                    }

                    @Override
                    public void setImplName(String name) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public String getLine() {
                        return null;
                    }

                    @Override
                    public void rewind() {
                    }

                    @Override
                    public MultiMap<String, String> getMetaData() {
                        return new MultiMap<String, String>();
                    }
                };
                if (!InhabitantIntrospectionScanner.this.current.hasNext()) {
                    InhabitantIntrospectionScanner.this.fetch();
                }
                return ip;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

