/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.classmodel;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jvnet.hk2.component.Habitat;

public abstract class ClassPathHelper {
    public LinkedHashSet<String> classpathEntries = new LinkedHashSet();

    public static ClassPathHelper create(Habitat h, boolean allowTestClassPath) {
        return new ClassPathHelper(allowTestClassPath){};
    }

    public static ClassPathHelper create(Habitat h, String classPath) {
        return new ClassPathHelper(classPath){};
    }

    protected ClassPathHelper(boolean allowTestClassPath) {
        String classPath;
        String string = classPath = allowTestClassPath ? System.getProperty("surefire.test.class.path") : null;
        if (null == classPath) {
            classPath = System.getProperty("java.class.path");
        }
        this.initialize(classPath);
    }

    public ClassPathHelper(String classPath) {
        this.initialize(classPath);
    }

    protected void initialize(String classPath) {
        if (classPath != null) {
            String[] filenames;
            for (String filename : filenames = classPath.split(File.pathSeparator)) {
                if (filename.equals("")) continue;
                File classpathEntry = new File(filename);
                ClassPathHelper.addTransitiveJars(this.classpathEntries, classpathEntry);
            }
        }
    }

    public Set<String> getEntries() {
        return Collections.unmodifiableSet(this.classpathEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTransitiveJars(Set<String> cpSet, File classpathFile) {
        block9: {
            cpSet.add(classpathFile.getAbsolutePath());
            if (classpathFile.exists()) {
                try {
                    String additionalClasspath;
                    Manifest mf;
                    if (!classpathFile.isFile()) break block9;
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(classpathFile);
                        mf = jarFile.getManifest();
                    }
                    finally {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    if (mf != null && (additionalClasspath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                        for (String classpathEntry : additionalClasspath.split(" ")) {
                            File mfClasspathFile;
                            if (classpathEntry.equals("") || !(mfClasspathFile = new File(classpathFile.getParent(), classpathEntry.trim())).exists() || cpSet.contains(mfClasspathFile.getAbsolutePath())) continue;
                            ClassPathHelper.addTransitiveJars(cpSet, mfClasspathFile);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

