/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.classmodel;

import com.sun.hk2.component.InhabitantsScanner;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.util.ParsingConfig;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

public abstract class InhabitantsParsingContextGenerator {
    private final Logger logger = Logger.getLogger(InhabitantsParsingContextGenerator.class.getName());
    private final Parser parser;
    private final ParsingContext context;
    private final LinkedHashMap<String, InhabitantsScanner> metaInfScanners = new LinkedHashMap();

    public static InhabitantsParsingContextGenerator create(Habitat h) {
        return new InhabitantsParsingContextGenerator(){};
    }

    protected InhabitantsParsingContextGenerator() {
        ParsingContext.Builder builder = new ParsingContext.Builder();
        final HashSet<String> annotations = new HashSet<String>();
        annotations.add(Contract.class.getCanonicalName());
        annotations.add(Service.class.getCanonicalName());
        annotations.add("org.jvnet.hk2.config.Configured");
        builder.config(new ParsingConfig(){
            final Set<String> empty = Collections.emptySet();

            @Override
            public Set<String> getInjectionTargetAnnotations() {
                return this.empty;
            }

            @Override
            public Set<String> getInjectionTargetInterfaces() {
                return annotations;
            }

            @Override
            public Set<String> getInjectionPointsAnnotations() {
                return this.empty;
            }
        });
        this.context = builder.build();
        this.parser = new Parser(this.context);
    }

    public void parse(Collection<File> files) throws IOException {
        for (File file : files) {
            this.parse(file);
        }
    }

    public ParsingContext getContext() {
        try {
            this.parser.awaitTermination();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.context;
    }

    public Collection<InhabitantsScanner> getInhabitantsScanners() {
        return Collections.unmodifiableCollection(this.metaInfScanners.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInhabitantsScanner(String name, InhabitantsScanner is) {
        LinkedHashMap<String, InhabitantsScanner> linkedHashMap = this.metaInfScanners;
        synchronized (linkedHashMap) {
            if (!this.metaInfScanners.containsKey(name)) {
                this.metaInfScanners.put(name, is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File f) throws IOException {
        String imports;
        String bundleName;
        Manifest manifest = null;
        if (f.isDirectory()) {
            File manifestFile = new File(f, "META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifestFile));
                try {
                    manifest = new Manifest(is);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
        } else {
            JarFile jar = new JarFile(f);
            manifest = jar.getManifest();
            jar.close();
        }
        if (!(manifest == null || (bundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName")) == null || bundleName.equals("com.sun.enterprise.auto-depends") || (imports = manifest.getMainAttributes().getValue("Import-Package")) != null && imports.indexOf("hk2") != -1)) {
            this.logger.log(Level.FINER, "ignoring service-less {0}", f.getName());
            return;
        }
        this.parseAlways(this.parser, f);
    }

    protected void parseAlways(Parser parser, final File f) throws IOException {
        parser.parse(f, new Runnable(){

            @Override
            public void run() {
                InhabitantsParsingContextGenerator.this.logger.log(Level.FINER, "Finished introspecting {0}", f.getName());
            }
        });
    }
}

