/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.junit;

import com.sun.hk2.component.InhabitantsParser;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.HabitatFactory;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantsParserFactory;
import org.jvnet.hk2.component.classmodel.ClassPathHelper;
import org.jvnet.hk2.component.classmodel.InhabitantsFeed;
import org.jvnet.hk2.component.classmodel.InhabitantsParsingContextGenerator;

public class Hk2TestServices {
    private final Logger logger = Logger.getLogger(Hk2TestServices.class.getName());
    private Habitat habitat;
    private final HabitatFactory habitatFactory;
    private final InhabitantsParserFactory ipFactory;

    public Hk2TestServices() {
        this(null, null);
    }

    protected Hk2TestServices(Class<? extends HabitatFactory> habitatFactoryClass, Class<? extends InhabitantsParserFactory> ipFactoryClass) {
        if (null == habitatFactoryClass || habitatFactoryClass.isInterface()) {
            this.habitatFactory = null;
        } else {
            try {
                this.habitatFactory = habitatFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (null == ipFactoryClass || ipFactoryClass.isInterface()) {
            this.ipFactory = null;
        } else {
            try {
                this.ipFactory = ipFactoryClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.logger.log(Level.FINER, "Singleton created");
        this.habitat = this.createHabitat();
        InhabitantsParser ip = this.createInhabitantsParser(this.habitat);
        this.populateHabitat(this.habitat, ip);
        this.habitat.initialized();
    }

    protected void populateHabitat(Habitat habitat, InhabitantsParser ip) {
        InhabitantsParsingContextGenerator ipcgen = InhabitantsParsingContextGenerator.create(habitat);
        ClassPathHelper classpath = ClassPathHelper.create(habitat, true);
        Set<String> cpSet = classpath.getEntries();
        for (String fileName : cpSet) {
            File f = new File(fileName);
            if (!f.exists()) continue;
            try {
                ipcgen.parse(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        InhabitantsFeed feed = InhabitantsFeed.create(habitat, ip);
        feed.populate(ipcgen);
        if (this.logger.isLoggable(Level.FINER)) {
            Iterator<String> contracts = habitat.getAllContracts();
            while (contracts.hasNext()) {
                String contract = contracts.next();
                this.logger.log(Level.FINER, "Found contract: {0}", contract);
                for (Inhabitant<?> t : habitat.getInhabitantsByContract(contract)) {
                    this.logger.log(Level.FINER, " --> {0} {1}", new Object[]{t.typeName(), t.metadata()});
                }
            }
        }
    }

    public Habitat getHabitat() {
        return this.habitat;
    }

    public Habitat createHabitat() throws ComponentException {
        if (null != this.habitatFactory) {
            return this.habitatFactory.newHabitat();
        }
        return new Habitat();
    }

    public InhabitantsParser createInhabitantsParser(Habitat h) throws ComponentException {
        if (null != this.ipFactory) {
            return this.ipFactory.createInhabitantsParser(h);
        }
        return new InhabitantsParser(h);
    }
}

