/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.ServiceTag;
import com.sun.servicetag.UnauthorizedAccessException;
import com.sun.servicetag.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysnetRegistryHelper {
    private static final String STCLIENT_SOLARIS = "/usr/bin/stclient";
    private static final String STCLIENT_LINUX = "/opt/sun/servicetag/bin/stclient";
    private static final int ST_ERR_NOT_AUTH = 245;
    private static final int ST_ERR_REC_NOT_FOUND = 225;
    private static final String INSTANCE_URN_OPEN_ELEMENT = "<instance_urn>";
    private static final String INSTANCE_URN_CLOSE_ELEMENT = "</instance_urn>";
    private static final String REGISTRY_URN = "<registry urn=\"";
    private static final String INSTANCE_URN_DESC = "Product instance URN=";
    private static boolean initialized = false;
    private static boolean supportsHelperClass = true;
    private static File stclient = null;
    private static String stclientPath = null;
    private static String SVCTAG_STCLIENT_CMD = "servicetag.stclient.cmd";
    private static String SVCTAG_STHELPER_SUPPORTED = "servicetag.sthelper.supported";

    private static synchronized String getSTclient() {
        if (!initialized) {
            if (System.getProperty(SVCTAG_STHELPER_SUPPORTED) != null) {
                supportsHelperClass = Boolean.getBoolean(SVCTAG_STHELPER_SUPPORTED);
            }
            if ((stclientPath = System.getProperty(SVCTAG_STCLIENT_CMD)) != null) {
                return stclientPath;
            }
            String os = System.getProperty("os.name");
            if (os.equals("SunOS")) {
                stclient = new File(STCLIENT_SOLARIS);
            } else if (os.equals("Linux")) {
                stclient = new File(STCLIENT_LINUX);
            } else if (os.startsWith("Windows")) {
                stclient = Util.getWindowsStClientFile();
            } else if (Util.isVerbose()) {
                System.out.println("Running on non-Sun JDK");
            }
            initialized = true;
        }
        if (stclientPath == null && stclient != null && stclient.exists()) {
            stclientPath = stclient.getAbsolutePath();
        }
        return stclientPath;
    }

    private static List<String> getCommandList() {
        ArrayList<String> command = new ArrayList<String>();
        if (System.getProperty(SVCTAG_STCLIENT_CMD) != null) {
            String cmd = SysnetRegistryHelper.getSTclient();
            int len = cmd.length();
            int i = 0;
            while (i < len) {
                int j;
                char separator = ' ';
                if (cmd.charAt(i) == '\"') {
                    separator = '\"';
                    ++i;
                }
                for (j = i + 1; j < len && cmd.charAt(j) != separator; ++j) {
                }
                if (i == j - 1) {
                    command.add("\"\"");
                } else {
                    command.add(cmd.substring(i, j));
                }
                for (i = j + 1; i < len && Character.isSpaceChar(cmd.charAt(i)); ++i) {
                }
            }
            if (Util.isVerbose()) {
                System.out.println("Command list:");
                for (String s : command) {
                    System.out.println(s);
                }
            }
        } else {
            command.add(SysnetRegistryHelper.getSTclient());
        }
        return command;
    }

    private static ServiceTag checkReturnError(int exitValue, String output, ServiceTag st) throws IOException {
        switch (exitValue) {
            case 225: {
                return null;
            }
            case 245: {
                if (st != null) {
                    throw new UnauthorizedAccessException("Not authorized to access " + st.getInstanceURN() + " installer_uid=" + st.getInstallerUID());
                }
                throw new UnauthorizedAccessException("Not authorized:" + output);
            }
        }
        throw new IOException("stclient exits with error (" + exitValue + ")\n" + output);
    }

    private static ServiceTag getServiceTag(String instanceURN) throws IOException {
        if (instanceURN == null) {
            throw new NullPointerException("instanceURN is null");
        }
        List<String> command = SysnetRegistryHelper.getCommandList();
        command.add("-g");
        command.add("-i");
        command.add(instanceURN);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        String output = Util.commandOutput(p);
        if (Util.isVerbose()) {
            System.out.println("Output from stclient -g command:");
            System.out.println(output);
        }
        if (p.exitValue() == 0) {
            return SysnetRegistryHelper.parseServiceTag(output);
        }
        return SysnetRegistryHelper.checkReturnError(p.exitValue(), output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceTag parseServiceTag(String output) throws IOException {
        BufferedReader in = null;
        try {
            Properties props = new Properties();
            in = new BufferedReader(new StringReader(output));
            String line = null;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                String[] ss = line.trim().split("=", 2);
                if (ss.length == 2) {
                    props.setProperty(ss[0].trim(), ss[1].trim());
                    continue;
                }
                props.setProperty(ss[0].trim(), "");
            }
            String urn = props.getProperty("instance_urn");
            String productName = props.getProperty("product_name");
            String productVersion = props.getProperty("product_version");
            String productURN = props.getProperty("product_urn");
            String productParent = props.getProperty("product_parent");
            String productParentURN = props.getProperty("product_parent_urn");
            String productDefinedInstanceID = props.getProperty("product_defined_inst_id");
            String productVendor = props.getProperty("product_vendor");
            String platformArch = props.getProperty("platform_arch");
            String container = props.getProperty("container");
            String source = props.getProperty("source");
            int installerUID = Util.getIntValue(props.getProperty("installer_uid"));
            Date timestamp = Util.parseTimestamp(props.getProperty("timestamp"));
            ServiceTag serviceTag = new ServiceTag(urn, productName, productVersion, productURN, productParent, productParentURN, productDefinedInstanceID, productVendor, platformArch, container, source, installerUID, timestamp);
            return serviceTag;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRegistryURN() throws IOException {
        List<String> command = SysnetRegistryHelper.getCommandList();
        command.add("-x");
        BufferedReader in = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            String output = Util.commandOutput(p);
            String registryURN = null;
            if (p.exitValue() == 0) {
                in = new BufferedReader(new StringReader(output));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String s = line.trim();
                    if (s.indexOf(REGISTRY_URN) == -1 || (s = s.substring(s.indexOf(REGISTRY_URN) + REGISTRY_URN.length())).indexOf("\"") == -1) continue;
                    registryURN = s = s.substring(0, s.indexOf("\""));
                    break;
                }
            } else {
                SysnetRegistryHelper.checkReturnError(p.exitValue(), output, null);
            }
            String string = registryURN;
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ServiceTag> getServiceTags() throws IOException {
        List<String> command = SysnetRegistryHelper.getCommandList();
        command.add("-x");
        BufferedReader in = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            String output = Util.commandOutput(p);
            HashSet<ServiceTag> instances = new HashSet<ServiceTag>();
            if (p.exitValue() == 0) {
                in = new BufferedReader(new StringReader(output));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String s = line.trim();
                    if (s.indexOf(INSTANCE_URN_OPEN_ELEMENT) == -1 || s.indexOf(INSTANCE_URN_CLOSE_ELEMENT) == -1) continue;
                    s = s.substring(s.indexOf(INSTANCE_URN_OPEN_ELEMENT) + INSTANCE_URN_OPEN_ELEMENT.length(), s.indexOf(INSTANCE_URN_CLOSE_ELEMENT));
                    instances.add(SysnetRegistryHelper.getServiceTag(s));
                }
            } else {
                SysnetRegistryHelper.checkReturnError(p.exitValue(), output, null);
            }
            HashSet<ServiceTag> hashSet = instances;
            return hashSet;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

