/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.websockets;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.arp.AsyncExecutor;
import com.sun.grizzly.arp.AsyncProcessorTask;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.util.ConnectionCloseHandler;
import com.sun.grizzly.util.Utils;
import com.sun.grizzly.websockets.BaseServerWebSocket;
import com.sun.grizzly.websockets.BaseWebSocket;
import com.sun.grizzly.websockets.HandshakeException;
import com.sun.grizzly.websockets.SecKey;
import com.sun.grizzly.websockets.ServerNetworkHandler;
import com.sun.grizzly.websockets.WebSocket;
import com.sun.grizzly.websockets.WebSocketAdapter;
import com.sun.grizzly.websockets.WebSocketApplication;
import com.sun.grizzly.websockets.WebSocketCloseHandler;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketEngine {
    public static final String SEC_WS_PROTOCOL_HEADER = "Sec-WebSocket-Protocol";
    public static final String SEC_WS_KEY1_HEADER = "Sec-WebSocket-Key1";
    public static final String SEC_WS_KEY2_HEADER = "Sec-WebSocket-Key2";
    public static final String CLIENT_WS_ORIGIN_HEADER = "Origin";
    public static final String SERVER_SEC_WS_ORIGIN_HEADER = "Sec-WebSocket-Origin";
    public static final String SERVER_SEC_WS_LOCATION_HEADER = "Sec-WebSocket-Location";
    public static final String WEBSOCKET = "websocket";
    public static final int INITIAL_BUFFER_SIZE = 8192;
    public static final int DEFAULT_TIMEOUT;
    private static final WebSocketEngine engine;
    static final Logger logger;
    private final List<WebSocketApplication> applications = new ArrayList<WebSocketApplication>();
    private final Map<WebSocketApplication, StackTraceElement[]> map = new HashMap<WebSocketApplication, StackTraceElement[]>();
    public static final boolean constrainApplications;
    private final WebSocketCloseHandler closeHandler = new WebSocketCloseHandler();

    private WebSocketEngine() {
        SecKey.init();
    }

    public static WebSocketEngine getEngine() {
        return engine;
    }

    public WebSocketApplication getApplication(Request request) {
        WebSocketApplication app = null;
        for (WebSocketApplication application : this.applications) {
            if (!application.upgrade(request)) continue;
            if (app == null) {
                app = application;
                continue;
            }
            if (!constrainApplications) continue;
            for (Map.Entry<WebSocketApplication, StackTraceElement[]> entry : this.map.entrySet()) {
                StackTraceElement[] traceElements;
                System.out.println("WebSocketEngine.getApplication: entry.getKey() = " + entry.getKey());
                for (StackTraceElement element : traceElements = entry.getValue()) {
                    System.out.println(element);
                }
            }
            throw new HandshakeException("Multiple applications are registered for this request");
        }
        return app;
    }

    public boolean upgrade(AsyncExecutor asyncExecutor) {
        try {
            Request request = asyncExecutor.getProcessorTask().getRequest();
            WebSocketApplication app = WebSocketEngine.getEngine().getApplication(request);
            BaseWebSocket socket = null;
            try {
                if (app != null) {
                    Response response = request.getResponse();
                    ProcessorTask task = asyncExecutor.getProcessorTask();
                    AsyncProcessorTask asyncTask = (AsyncProcessorTask)asyncExecutor.getAsyncTask();
                    SelectionKey key = task.getSelectionKey();
                    ServerNetworkHandler handler = new ServerNetworkHandler(task, asyncTask, request, response);
                    ((BaseSelectionKeyHandler)task.getSelectorHandler().getSelectionKeyHandler()).setConnectionCloseHandler((ConnectionCloseHandler)this.closeHandler);
                    socket = (BaseServerWebSocket)app.createSocket(app, new KeyWebSocketListener(key));
                    socket.setNetworkHandler(handler);
                    handler.handshake(task.getSSLSupport() != null);
                    this.enableRead(task, key);
                    key.attach(handler.getAttachment());
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                socket = null;
            }
            catch (HandshakeException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                socket.close();
                socket = null;
            }
            return socket != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    final void enableRead(ProcessorTask task, SelectionKey key) {
        task.getSelectorHandler().register(key, 1);
    }

    @Deprecated
    public void register(String name, WebSocketApplication app) {
        this.register(app);
    }

    public void register(WebSocketApplication app) {
        this.applications.add(app);
        this.map.put(app, Thread.currentThread().getStackTrace());
    }

    public void unregister(WebSocketApplication app) {
        this.applications.remove(app);
        this.map.remove(app);
    }

    static {
        engine = new WebSocketEngine();
        logger = Logger.getLogger(WEBSOCKET);
        constrainApplications = Boolean.getBoolean("grizzly.websockets.constrainApplications");
        DEFAULT_TIMEOUT = Utils.isDebugVM() ? 900 : 30;
    }

    private static class KeyWebSocketListener
    extends WebSocketAdapter {
        private final SelectionKey key;

        public KeyWebSocketListener(SelectionKey key) {
            this.key = key;
        }

        public void onClose(WebSocket socket) throws IOException {
            this.key.cancel();
            this.key.channel().close();
        }
    }
}

