/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.CopyConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="copy-config")
@I18n(value="copy.config.command")
@Scoped(value=PerLookup.class)
public final class CopyConfigCommand
extends CopyConfig {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CopyConfigCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (this.configs.size() != 2) {
            report.setMessage(localStrings.getLocalString("Config.badConfigNames", "You must specify a source and destination config") + "\n" + localStrings.getLocalString("Config.copyConfigUsage", "Usage copy-config \\n[--systemproperties (name=value)[:name=value]*]\\nsource_configuration_name destination_configuration_name"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String srcConfig = (String)this.configs.get(0);
        String destConfig = (String)this.configs.get(1);
        final Config config = this.domain.getConfigNamed(srcConfig);
        if (config == null) {
            report.setMessage(localStrings.getLocalString("Config.noSuchConfig", "Config {0} does not exist.", new Object[]{srcConfig}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Config destinationConfig = this.domain.getConfigNamed(destConfig);
        if (destinationConfig != null) {
            report.setMessage(localStrings.getLocalString("Config.configExists", "Config {0} already exists.", new Object[]{destConfig}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        final String configName = destConfig;
        final Logger logger = context.getLogger();
        try {
            Config newCopy = (Config)ConfigSupport.apply(new SingleConfigCode<Configs>(){

                @Override
                public Object run(Configs configs) throws PropertyVetoException, TransactionFailure {
                    return CopyConfigCommand.this.copyConfig(configs, config, configName, logger);
                }
            }, this.domain.getConfigs());
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("Config.copyConfigError", "CopyConfig error caused by ", new Object[]{e.getLocalizedMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

