/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.file;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.security.util.SSHA;
import com.sun.enterprise.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.SharedSecureRandom;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public final class FileRealm
extends IASRealm {
    public static final String AUTH_TYPE = "filepassword";
    public static final String PARAM_KEYFILE = "file";
    private static final String FIELD_SEP = ";";
    private static final String GROUP_SEP = ",";
    private static final String COMMENT = "#";
    public static final String MISC_VALID_CHARS = "_-.";
    private static final int SALT_SIZE = 8;
    private final Hashtable<String, FileRealmUser> userTable = new Hashtable();
    private final Hashtable<String, Integer> groupSizeMap = new Hashtable();
    private static final String instanceRoot = FileRealm.getInstanceRoot();
    private static final String SSHA_TAG = "{SSHA}";
    private static final String SSHA_256_TAG = "{SSHA256}";
    private static final String algoSHA = "SHA";
    private static final String algoSHA256 = "SHA-256";

    public FileRealm(String keyfile) throws BadRealmException, NoSuchRealmException {
        File fp = new File(keyfile);
        if (!fp.exists()) {
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(fp);
                fout.write("\n".getBytes());
            }
            catch (Exception e) {
                String msg = sm.getString("filerealm.noaccess", (Object)e.toString());
                throw new BadRealmException(msg);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        Properties p = new Properties();
        p.setProperty(PARAM_KEYFILE, keyfile);
        p.setProperty("jaas-context", "ignore");
        this.init(p);
    }

    public FileRealm() {
    }

    public static List<String> getRealmFileNames(Config config) {
        ArrayList<String> files = new ArrayList<String>();
        SecurityService securityService = config.getSecurityService();
        for (AuthRealm authRealm : securityService.getAuthRealm()) {
            String file;
            String fileRealmClassName = authRealm.getClassname();
            if (fileRealmClassName == null || !fileRealmClassName.equals(FileRealm.class.getName()) || (file = authRealm.getPropertyValue(PARAM_KEYFILE)) == null) continue;
            files.add(file);
        }
        return files;
    }

    @Override
    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String file = props.getProperty(PARAM_KEYFILE);
        if (file == null) {
            String msg = sm.getString("filerealm.nofile");
            throw new BadRealmException(msg);
        }
        this.setProperty(PARAM_KEYFILE, file);
        String jaasCtx = props.getProperty("jaas-context");
        if (jaasCtx == null) {
            String msg = sm.getString("filerealm.nomodule");
            throw new BadRealmException(msg);
        }
        this.setProperty("jaas-context", jaasCtx);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("FileRealm : file=" + file);
            _logger.fine("FileRealm : jaas-context=" + jaasCtx);
        }
        this.loadKeyFile();
    }

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    @Override
    public Enumeration<String> getUserNames() throws BadRealmException {
        return new Vector<String>(this.userTable.keySet()).elements();
    }

    @Override
    public User getUser(String name) throws NoSuchUserException {
        FileRealmUser u = this.userTable.get(name);
        if (u == null) {
            String msg = sm.getString("filerealm.nouser", (Object)name);
            throw new NoSuchUserException(msg);
        }
        return u;
    }

    @Override
    public Enumeration getGroupNames() throws BadRealmException {
        return this.groupSizeMap.keys();
    }

    @Override
    public Enumeration getGroupNames(String username) throws NoSuchUserException {
        FileRealmUser ud = this.userTable.get(username);
        if (ud == null) {
            String msg = sm.getString("filerealm.nouser", (Object)username);
            throw new NoSuchUserException(msg);
        }
        String[] groups = ud.getGroups();
        groups = this.addAssignGroups(groups);
        Vector<String> v = new Vector<String>();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                v.add(groups[i]);
            }
        }
        return v.elements();
    }

    @Override
    public void refresh() throws BadRealmException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Reloading file realm data.");
        }
        FileRealm newRealm = new FileRealm();
        try {
            newRealm.init(this.getProperties());
            Realm.updateInstance(newRealm, this.getName());
        }
        catch (Exception e) {
            throw new BadRealmException(e.toString());
        }
    }

    public String[] authenticate(String user, char[] password) {
        FileRealmUser ud = this.userTable.get(user);
        if (ud == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("No such user: [" + user + "]");
            }
            return null;
        }
        boolean ok = false;
        try {
            ok = SSHA.verify(ud.getSalt(), ud.getHash(), Utility.convertCharArrayToByteArray((char[])password, (String)Charset.defaultCharset().displayName()), ud.getAlgo());
        }
        catch (Exception e) {
            _logger.fine("File authentication failed: " + e.toString());
            return null;
        }
        if (!ok) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("File authentication failed for: [" + user + "]");
            }
            return null;
        }
        String[] groups = ud.getGroups();
        groups = this.addAssignGroups(groups);
        return groups;
    }

    private static boolean isValid(String s, boolean userName) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || Character.isWhitespace(c) || MISC_VALID_CHARS.indexOf(c) != -1 || userName && c == '@') continue;
            return false;
        }
        return true;
    }

    public static void validateUserName(String name) throws IASSecurityException {
        if (name == null || name.length() == 0) {
            String msg = sm.getString("filerealm.noname");
            throw new IASSecurityException(msg);
        }
        if (!FileRealm.isValid(name, true)) {
            String msg = sm.getString("filerealm.badname", (Object)name);
            throw new IASSecurityException(msg);
        }
        if (!name.equals(name.trim())) {
            String msg = sm.getString("filerealm.badspaces", (Object)name);
            throw new IASSecurityException(msg);
        }
    }

    public static void validatePassword(char[] pwd) throws IASSecurityException {
        if (Arrays.equals(null, pwd)) {
            String msg = sm.getString("filerealm.emptypwd");
            throw new IASSecurityException(msg);
        }
        for (char c : pwd) {
            if (!Character.isSpaceChar(c)) continue;
            String msg = sm.getString("filerealm.badspacespwd");
            throw new IASSecurityException(msg);
        }
    }

    public static void validateGroupName(String group) throws IASSecurityException {
        if (group == null || group.length() == 0) {
            String msg = sm.getString("filerealm.nogroup");
            throw new IASSecurityException(msg);
        }
        if (!FileRealm.isValid(group, false)) {
            String msg = sm.getString("filerealm.badchars", (Object)group);
            throw new IASSecurityException(msg);
        }
        if (!group.equals(group.trim())) {
            String msg = sm.getString("filerealm.badspaces", (Object)group);
            throw new IASSecurityException(msg);
        }
    }

    public static void validateGroupList(String[] groupList) throws IASSecurityException {
        if (groupList == null || groupList.length == 0) {
            return;
        }
        for (int i = 0; i < groupList.length; ++i) {
            FileRealm.validateGroupName(groupList[i]);
        }
    }

    @Override
    public synchronized void addUser(String name, char[] password, String[] groupList) throws BadRealmException, IASSecurityException {
        FileRealm.validateUserName(name);
        FileRealm.validatePassword(password);
        FileRealm.validateGroupList(groupList);
        if (this.userTable.containsKey(name)) {
            String msg = sm.getString("filerealm.dupuser", (Object)name);
            throw new BadRealmException(msg);
        }
        this.addGroupNames(groupList);
        FileRealmUser ud = FileRealm.createNewUser(name, password, groupList);
        this.userTable.put(name, ud);
    }

    @Override
    public synchronized void removeUser(String name) throws NoSuchUserException, BadRealmException {
        if (!this.userTable.containsKey(name)) {
            String msg = sm.getString("filerealm.nouser", (Object)name);
            throw new NoSuchUserException(msg);
        }
        FileRealmUser oldUser = this.userTable.get(name);
        this.userTable.remove(name);
        this.reduceGroups(oldUser.getGroups());
    }

    public synchronized void updateUser(String name, char[] password, String[] groups) throws NoSuchUserException, BadRealmException, IASSecurityException {
        this.updateUser(name, name, password, groups);
    }

    @Override
    public synchronized void updateUser(String name, String newName, char[] password, String[] groups) throws NoSuchUserException, BadRealmException, IASSecurityException {
        FileRealm.validateUserName(name);
        if (!this.userTable.containsKey(name)) {
            String msg = sm.getString("filerealm.nouser", (Object)name);
            throw new NoSuchUserException(msg);
        }
        FileRealm.validateUserName(newName);
        FileRealm.validateGroupList(groups);
        if (password != null) {
            FileRealm.validatePassword(password);
        }
        if (!name.equals(newName) && this.userTable.containsKey(newName)) {
            String msg = sm.getString("filerealm.dupuser", (Object)name);
            throw new BadRealmException(msg);
        }
        FileRealmUser oldUser = this.userTable.get(name);
        assert (oldUser != null);
        FileRealmUser newUser = new FileRealmUser(newName);
        if (groups != null) {
            this.changeGroups(oldUser.getGroups(), groups);
            newUser.setGroups(groups);
        } else {
            newUser.setGroups(oldUser.getGroups());
        }
        if (password == null) {
            newUser.setSalt(oldUser.getSalt());
            newUser.setHash(oldUser.getHash());
            newUser.setAlgo(oldUser.getAlgo());
        } else {
            FileRealm.setPassword(newUser, password);
            newUser.setAlgo(algoSHA256);
        }
        this.userTable.remove(name);
        this.userTable.put(newName, newUser);
    }

    @Override
    public boolean supportsUserManagement() {
        return true;
    }

    @Override
    public void persist() throws BadRealmException {
        String file = this.getProperty(PARAM_KEYFILE);
        try {
            this.writeKeyFile(file);
        }
        catch (IOException ex) {
            throw new BadRealmException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeKeyFile(String filename) throws IOException {
        Class<FileRealm> clazz = FileRealm.class;
        synchronized (FileRealm.class) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(filename);
                for (Map.Entry<String, FileRealmUser> uval : this.userTable.entrySet()) {
                    String algo = uval.getValue().getAlgo();
                    String entry = FileRealm.encodeUser(uval.getKey(), uval.getValue(), algo);
                    out.write(entry.getBytes());
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = sm.getString("filerealm.badwrite", (Object)e.toString());
                throw new IOException(msg);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Done writing " + filename);
            }
            return;
        }
    }

    private void addGroupNames(String[] groupList) {
        if (groupList != null) {
            for (int i = 0; i < groupList.length; ++i) {
                Integer groupSize = this.groupSizeMap.get(groupList[i]);
                this.groupSizeMap.put(groupList[i], groupSize != null ? groupSize + 1 : 1);
            }
        }
    }

    private void reduceGroups(String[] groupList) {
        if (groupList != null) {
            for (int i = 0; i < groupList.length; ++i) {
                Integer groupSize = this.groupSizeMap.get(groupList[i]);
                if (groupSize == null) continue;
                int gpSize = groupSize - 1;
                if (gpSize > 0) {
                    this.groupSizeMap.put(groupList[i], gpSize);
                    continue;
                }
                this.groupSizeMap.remove(groupList[i]);
            }
        }
    }

    private void changeGroups(String[] oldGroupList, String[] newGroupList) {
        this.addGroupNames(newGroupList);
        this.reduceGroups(oldGroupList);
    }

    private void loadKeyFile() throws BadRealmException {
        String file = this.getProperty(PARAM_KEYFILE);
        _logger.fine("Reading file realm: " + file);
        File filePath = new File(file);
        if (file != null && !filePath.exists()) {
            try {
                if (instanceRoot != null && filePath.getCanonicalPath().startsWith(instanceRoot)) {
                    filePath.createNewFile();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        BufferedReader input = null;
        try {
            if (Util.isEmbeddedServer()) {
                String embeddedFilePath = Util.writeConfigFileToTempDir(file).getAbsolutePath();
                this.setProperty(PARAM_KEYFILE, embeddedFilePath);
                input = new BufferedReader(new FileReader(embeddedFilePath));
            } else {
                input = new BufferedReader(new FileReader(file));
            }
            while (input.ready()) {
                String line = input.readLine();
                if (line.startsWith(COMMENT) || line.indexOf(FIELD_SEP) <= 0) continue;
                FileRealmUser ud = FileRealm.decodeUser(line, this.groupSizeMap);
                this.userTable.put(ud.getName(), ud);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "filerealm.readerror", e);
            throw new BadRealmException(e.toString());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private static String encodeUser(String name, FileRealmUser ud, String algo) {
        StringBuffer sb = new StringBuffer();
        Object cryptPwd = null;
        sb.append(name);
        sb.append(FIELD_SEP);
        String ssha = SSHA.encode(ud.getSalt(), ud.getHash(), algo);
        sb.append(ssha);
        sb.append(FIELD_SEP);
        String[] groups = ud.getGroups();
        if (groups != null) {
            for (int grp = 0; grp < groups.length; ++grp) {
                if (grp > 0) {
                    sb.append(GROUP_SEP);
                }
                sb.append(groups[grp]);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    private static FileRealmUser decodeUser(String encodedLine, Map newGroupSizeMap) throws IASSecurityException {
        StringTokenizer st = new StringTokenizer(encodedLine, FIELD_SEP);
        String algo = algoSHA256;
        String user = null;
        String pwdInfo = null;
        String groupList = null;
        try {
            user = st.nextToken();
            pwdInfo = st.nextToken();
        }
        catch (Exception e) {
            String msg = sm.getString("filerealm.syntaxerror", (Object)encodedLine);
            throw new IASSecurityException(msg);
        }
        if (st.hasMoreTokens()) {
            groupList = st.nextToken();
        }
        if (encodedLine.contains(SSHA_TAG)) {
            algo = algoSHA;
        }
        int resultLength = 32;
        if (algoSHA.equals(algo)) {
            resultLength = 20;
        }
        byte[] hash = new byte[resultLength];
        byte[] salt = SSHA.decode(pwdInfo, hash, algo);
        FileRealmUser ud = new FileRealmUser(user);
        ud.setHash(hash);
        ud.setSalt(salt);
        Vector<String> membership = new Vector<String>();
        if (groupList != null) {
            StringTokenizer gst = new StringTokenizer(groupList, GROUP_SEP);
            while (gst.hasMoreTokens()) {
                String g = gst.nextToken();
                membership.add(g);
                Integer groupSize = (Integer)newGroupSizeMap.get(g);
                newGroupSizeMap.put(g, groupSize != null ? groupSize + 1 : 1);
            }
        }
        ud.setGroups(membership);
        ud.setAlgo(algo);
        return ud;
    }

    private static FileRealmUser createNewUser(String name, char[] pwd, String[] groups) throws IASSecurityException {
        FileRealmUser ud = new FileRealmUser(name);
        if (groups == null) {
            groups = new String[]{};
        }
        ud.setGroups(groups);
        ud.setAlgo(algoSHA256);
        FileRealm.setPassword(ud, pwd);
        return ud;
    }

    private static void setPassword(FileRealmUser user, char[] pwd) throws IASSecurityException {
        assert (user != null);
        byte[] pwdBytes = null;
        try {
            pwdBytes = Utility.convertCharArrayToByteArray((char[])pwd, (String)Charset.defaultCharset().displayName());
        }
        catch (Exception ex) {
            throw new IASSecurityException(ex);
        }
        SecureRandom rng = SharedSecureRandom.get();
        byte[] salt = new byte[8];
        rng.nextBytes(salt);
        user.setSalt(salt);
        String algo = user.getAlgo();
        if (algo == null) {
            algo = algoSHA256;
        }
        byte[] hash = SSHA.compute(salt, pwdBytes, algo);
        user.setHash(hash);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            FileRealm.help();
        }
        try {
            if ("-c".equals(args[0])) {
                String[] groups = new String[]{};
                if (args.length > 3) {
                    groups = new String[args.length - 3];
                    for (int i = 3; i < args.length; ++i) {
                        groups[i - 3] = args[i];
                    }
                }
                FileRealmUser ud = FileRealm.createNewUser(args[1], args[2].toCharArray(), groups);
                String out = FileRealm.encodeUser(args[1], ud, algoSHA256);
                System.out.println(out);
                FileRealmUser u = FileRealm.decodeUser(out, new Hashtable());
                System.out.println("verifies: " + SSHA.verify(u.getSalt(), u.getHash(), args[2].getBytes(), algoSHA256));
            } else if ("-v".equals(args[0])) {
                FileRealmUser u = FileRealm.decodeUser(args[2], new Hashtable());
                System.out.println("user: " + u.getName());
                System.out.println("verifies: " + SSHA.verify(u.getSalt(), u.getHash(), args[1].getBytes(), algoSHA256));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private static void help() {
        System.out.println("FileRealm -c <name  <pwd  [group]*");
        System.out.println("FileRealm -v <pwd  `output of -c`");
        System.exit(1);
    }

    private static String getInstanceRoot() {
        try {
            ServerEnvironment se = Globals.getDefaultHabitat() != null ? Globals.getDefaultHabitat().getComponent(ServerEnvironment.class) : null;
            File fileInstanceRoot = se == null ? null : se.getInstanceRoot();
            return fileInstanceRoot != null ? fileInstanceRoot.getCanonicalPath() : null;
        }
        catch (IOException e) {
            _logger.log(Level.FINE, "io_exception while getting the instanceRoot");
            return null;
        }
    }
}

