/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.glassfish.embeddable.BootstrapOptions;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishOptions;
import org.glassfish.embeddable.spi.RuntimeBuilder;

public abstract class GlassFishRuntime {
    private static GlassFishRuntime me;

    public static GlassFishRuntime bootstrap(BootstrapOptions options) throws GlassFishException {
        return GlassFishRuntime.bootstrap(options, GlassFishRuntime.class.getClassLoader());
    }

    public static GlassFishRuntime bootstrap(BootstrapOptions options, ClassLoader cl) throws GlassFishException {
        return GlassFishRuntime._bootstrap(options, cl);
    }

    public abstract void shutdown() throws GlassFishException;

    public abstract GlassFish newGlassFish(GlassFishOptions var1) throws GlassFishException;

    private static synchronized GlassFishRuntime _bootstrap(BootstrapOptions options, ClassLoader cl) throws GlassFishException {
        if (me != null) {
            throw new GlassFishException("Already bootstrapped", null);
        }
        RuntimeBuilder runtimeBuilder = GlassFishRuntime.getRuntimeBuilder(options, cl != null ? cl : GlassFishRuntime.class.getClassLoader());
        me = runtimeBuilder.build(options);
        return me;
    }

    protected static synchronized void shutdownInternal() throws GlassFishException {
        if (me == null) {
            throw new GlassFishException("Already shutdown", null);
        }
        me = null;
    }

    private static RuntimeBuilder getRuntimeBuilder(BootstrapOptions options, ClassLoader cl) throws GlassFishException {
        Iterator<RuntimeBuilder> runtimeBuilders = ServiceLoader.load(RuntimeBuilder.class, cl).iterator();
        while (runtimeBuilders.hasNext()) {
            try {
                RuntimeBuilder builder = runtimeBuilders.next();
                if (!builder.handles(options)) continue;
                return builder;
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
            }
        }
        throw new GlassFishException("No runtime builder available for this configuration: " + options.getAllOptions(), null);
    }
}

