/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class FirebirdPlatform
extends DatabasePlatform {
    public FirebirdPlatform() {
        this.setPingSQL("SELECT 1 FROM RDB$DATABASE");
    }

    protected Hashtable buildFieldTypes() {
        Hashtable fieldTypeMapping = super.buildFieldTypes();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("NUMERIC", 18).setLimits(18, -18, 18));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("DOUBLE PRECISION", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("NUMERIC", 18).setLimits(18, -18, 18));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("NUMERIC", 18).setLimits(18, -18, 18));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("NUMERIC", 38).setLimits(18, -18, 18));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("VARCHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB"));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("VARCHAR", 32000));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BLOB"));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("VARCHAR", 32000));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BLOB"));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("VARCHAR", 32000));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIME", false));
        fieldTypeMapping.put(Calendar.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypeMapping.put(java.util.Date.class, new FieldTypeDefinition("TIMESTAMP", false));
        return fieldTypeMapping;
    }

    public int getMaxForeignKeyNameSize() {
        return 24;
    }

    public int getMaxUniqueKeyNameSize() {
        return 24;
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery("SELECT CURRENT_TIMESTAMP FROM RDB$DATABASE");
        }
        return this.timestampQuery;
    }

    public boolean isAlterSequenceObjectSupported() {
        return false;
    }

    public Writer buildSequenceObjectCreationWriter(Writer writer, String fullSeqName, int increment, int start) throws IOException {
        writer.write("CREATE GENERATOR ");
        writer.write(fullSeqName);
        return writer;
    }

    public Writer buildSequenceObjectDeletionWriter(Writer writer, String fullSeqName) throws IOException {
        writer.write("DROP GENERATOR ");
        writer.write(fullSeqName);
        return writer;
    }

    public ValueReadQuery buildSelectQueryForSequenceObject(String seqName, Integer size) {
        StringBuilder builder = new StringBuilder(26 + seqName.length());
        builder.append("SELECT GEN_ID(");
        builder.append(seqName);
        builder.append(", ");
        builder.append(size);
        builder.append(") FROM RDB$DATABASE");
        return new ValueReadQuery(builder.toString());
    }

    public boolean supportsSequenceObjects() {
        return true;
    }

    public boolean supportsForeignKeyConstraints() {
        return true;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleMath(31, "||"));
        this.addOperator(ExpressionOperator.simpleFunction(55, "CEILING"));
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(104, "NULLIF"));
        this.addOperator(FirebirdPlatform.toNumberOperator());
        this.addOperator(FirebirdPlatform.monthsBetweenOperator());
        this.addOperator(this.greatest());
        this.addOperator(this.rightTrim2());
        this.addOperator(this.leftTrim());
        this.addOperator(this.rightTrim());
        this.addOperator(ExpressionOperator.simpleFunction(46, "CHAR_LENGTH"));
        this.addOperator(this.substring());
        this.addOperator(this.substring2());
    }

    protected ExpressionOperator substring() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(133);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement("SUBSTRING(");
        ((Vector)v).addElement(" FROM ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{0, 1};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected ExpressionOperator substring2() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(41);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement("SUBSTRING(");
        ((Vector)v).addElement(" FROM ");
        ((Vector)v).addElement(" FOR ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{0, 1, 2};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected ExpressionOperator greatest() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(76);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement("(CASE WHEN ");
        ((Vector)v).addElement(" >= ");
        ((Vector)v).addElement(" THEN ");
        ((Vector)v).addElement(" ELSE ");
        ((Vector)v).addElement(" END)");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{0, 1, 0, 1};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected ExpressionOperator leftTrim() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(37);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement("TRIM(LEADING FROM ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{0};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected ExpressionOperator rightTrim() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(40);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement("TRIM(TRAILING FROM ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{0};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    protected ExpressionOperator rightTrim2() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(116);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(5);
        ((Vector)v).addElement("TRIM(TRAILING ");
        ((Vector)v).addElement(" FROM ");
        ((Vector)v).addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        int[] indices = new int[]{1, 0};
        exOperator.setArgumentIndices(indices);
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator toNumberOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(42);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("CAST(");
        ((Vector)v).addElement(" AS NUMERIC)");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public static ExpressionOperator monthsBetweenOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(50);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(2);
        ((Vector)v).addElement("(MONTH(");
        ((Vector)v).addElement(") - MONTH(");
        ((Vector)v).addElement("))");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public boolean isFirebird() {
        return true;
    }

    public void printSQLSelectStatement(DatabaseCall call, ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        int max = 0;
        int firstRow = 0;
        if (statement.getQuery() != null) {
            max = statement.getQuery().getMaxRows();
            firstRow = statement.getQuery().getFirstResult();
        }
        if (!this.shouldUseRownumFiltering() || max <= 0 || firstRow <= 0) {
            super.printSQLSelectStatement(call, printer, statement);
            return;
        }
        statement.setUseUniqueFieldAliases(true);
        call.setFields(statement.printSQL(printer));
        printer.printString(" ROWS (");
        printer.printParameter(DatabaseCall.FIRSTRESULT_FIELD);
        printer.printString(" + 1) TO ");
        printer.printParameter(DatabaseCall.MAXROW_FIELD);
        call.setIgnoreFirstRowSetting(true);
        call.setIgnoreMaxResultsSetting(true);
    }

    public boolean isDynamicSQLRequiredForFunctions() {
        return true;
    }

    public String getSelectForUpdateString() {
        return " WITH LOCK";
    }
}

