/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.connect;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.jvnet.hk2.component.Habitat;

public class RemoteConnectHelper {
    private Habitat habitat;
    private Node node;
    private HashMap<String, Node> nodeMap;
    private Logger logger;
    private String dasHost = null;
    private int dasPort = -1;
    int commandStatus;
    String fullCommand = null;
    SSHLauncher sshL = null;

    public RemoteConnectHelper(Habitat habitat, Node[] nodes, Logger logger, String dasHost, int dasPort) {
        this.logger = logger;
        this.habitat = habitat;
        this.nodeMap = new HashMap();
        for (int i = 0; i < nodes.length; ++i) {
            Node n = nodes[i];
            this.nodeMap.put(n.getName(), n);
        }
        this.dasHost = dasHost;
        this.dasPort = dasPort;
    }

    public RemoteConnectHelper(Habitat habitat, Node node, Logger logger, String dasHost, int dasPort) {
        this.logger = logger;
        this.habitat = habitat;
        this.node = node;
        this.dasHost = dasHost;
        this.dasPort = dasPort;
    }

    public boolean isLocalhost() {
        String nodeHost = this.node.getNodeHost();
        if (nodeHost.equals("localhost")) {
            return true;
        }
        return NetUtils.IsThisHostLocal((String)nodeHost);
    }

    public boolean isRemoteConnectRequired() {
        String t = this.node.getType();
        if (t != null) {
            return t.equals("SSH");
        }
        return false;
    }

    public String getLastCommandRun() {
        return this.fullCommand;
    }

    public int runCommand(String cmd, ParameterMap parameters, StringBuilder outputString) throws SSHCommandExecutionException {
        try {
            String nodeHome = this.node.getInstallDir() + File.separator + "glassfish";
            if (nodeHome == null) {
                this.logger.severe("Invalid installdir " + nodeHome + " for node " + this.node.getName());
                return 1;
            }
            SshConnector connector = this.node.getSshConnector();
            if (connector != null) {
                this.sshL = this.habitat.getComponent(SSHLauncher.class);
                this.sshL.init(this.node, this.logger);
                String command = new String();
                String prefix = nodeHome + File.separator + "bin" + File.separator + "asadmin " + " --host " + this.dasHost + " --port " + this.dasPort + " " + cmd;
                String unixStyleSlash = prefix.replaceAll("\\\\", "/");
                String instanceName = new String();
                for (Map.Entry entry : parameters.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)parameters.getOne((Object)key);
                    if (key.equals("DEFAULT")) {
                        instanceName = value;
                        continue;
                    }
                    if (key.equals("help")) continue;
                    command = command + " " + key + " " + value;
                }
                this.fullCommand = unixStyleSlash + command + " " + instanceName;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                this.commandStatus = this.sshL.runCommand(this.fullCommand, outStream);
                String results = outStream.toString();
                outputString.append(results);
                return this.commandStatus;
            }
        }
        catch (IOException ex) {
            String m1 = " Command execution failed. " + ex.getMessage();
            String m2 = "";
            Throwable e2 = ex.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            this.logger.severe("Command execution failed for " + cmd);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(StringUtils.cat((String)":", (String[])new String[]{m1}));
            cee.setSSHSettings(this.sshL.toString());
            cee.setCommandRun(this.fullCommand);
            throw cee;
        }
        catch (InterruptedException ei) {
            ei.printStackTrace();
            String m1 = ei.getMessage();
            String m2 = "";
            Throwable e2 = ei.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            this.logger.severe("Command interrupted " + cmd);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(StringUtils.cat((String)":", (String[])new String[]{m1, m2}));
            cee.setSSHSettings(this.sshL.toString());
            cee.setCommandRun(this.fullCommand);
            throw cee;
        }
        return this.commandStatus;
    }
}

