/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.File;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.appclient.server.core.ClientJarMaker;
import org.glassfish.appclient.server.core.ClientJarMakerRegistry;
import org.glassfish.appclient.server.core.PEDeploymentFactoryImpl;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.internal.api.Globals;

public class ClientJarMakerThread
extends Thread {
    private DeploymentContext dc;
    private File clientJar;
    private ZipItem[] clientStubs;
    private String clientJarChoice = null;
    private static StringManager localStrings = StringManager.getManager(ClientJarMakerThread.class);

    public ClientJarMakerThread(DeploymentContext dc, File clientJar, ZipItem[] clientStubs, String clientJarChoice) {
        this.dc = dc;
        this.clientJar = clientJar;
        this.clientStubs = clientStubs;
        this.clientJarChoice = clientJarChoice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ClientJarMakerRegistry registry = ClientJarMakerRegistry.getInstance();
        String moduleID = this.dc.getCommandParameters(OpsParams.class).name();
        registry.register(moduleID, this);
        try {
            ClientJarMakerThread.createClientJar(this.dc, this.clientJar, this.clientStubs, this.clientJarChoice);
        }
        catch (DeploymentException e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, localStrings.getString("enterprise.deployment.error_creating_client_jar", (Object)e.getLocalizedMessage()), e);
        }
        finally {
            registry.unregister(moduleID);
        }
        if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
            DOLUtils.getDefaultLogger().fine("Created client jar file for " + moduleID + " at " + this.clientJar.getAbsolutePath());
        }
    }

    public static final void createClientJar(DeploymentContext dc, File clientJar, ZipItem[] clientStubs, String clientJarChoice) throws DeploymentException {
        try {
            ArchiveFactory archiveFactory = Globals.getDefaultHabitat().getComponent(ArchiveFactory.class);
            WritableArchive target = archiveFactory.createArchive(clientJar);
            Application app = (Application)dc.getModuleMetaData(Application.class);
            BundleDescriptor descriptor = app.isVirtual() ? app.getStandaloneBundleDescriptor() : app;
            ReadableArchive source = archiveFactory.openArchive(dc.getSourceDir());
            PEDeploymentFactoryImpl pe = new PEDeploymentFactoryImpl();
            Properties props = ClientJarMakerThread.getPropertiesForClientJarMaker(CLIENT_JAR_CHOICES.getClientJarChoice(clientJarChoice), dc, descriptor);
            ClientJarMaker jarMaker = pe.getClientJarMaker(props);
            if (FileUtils.safeIsDirectory((File)dc.getScratchDir("xml"))) {
                ReadableArchive source2 = archiveFactory.openArchive(dc.getScratchDir("xml"));
                jarMaker.create(descriptor, source, source2, target, clientStubs, null);
                source2.close();
            } else {
                jarMaker.create(descriptor, source, target, clientStubs, null);
            }
            source.close();
            target.close();
        }
        catch (Exception e) {
            DeploymentException newE = new DeploymentException();
            newE.initCause((Throwable)e);
            throw newE;
        }
    }

    private static Properties getPropertiesForClientJarMaker(CLIENT_JAR_CHOICES choice, DeploymentContext dc, RootDeploymentDescriptor descriptor) {
        boolean qualify = ClientJarMakerThread.qualifyModuleClientFormat(dc, descriptor);
        Properties props = null;
        Boolean propertySetting = choice.useModuleClientJarMaker(qualify);
        if (propertySetting != null) {
            props = new Properties();
            props.setProperty("use.module.client.jar.maker", propertySetting.toString());
        }
        return props;
    }

    private static boolean qualifyModuleClientFormat(DeploymentContext dc, RootDeploymentDescriptor descriptor) {
        if (((Application)dc.getModuleMetaData(Application.class)).isVirtual()) {
            return true;
        }
        Application app = (Application)Application.class.cast(descriptor);
        Set<ApplicationClientDescriptor> appClients = app.getApplicationClientDescriptors();
        if (appClients != null) {
            if (appClients.size() > 1) {
                return false;
            }
            if (!appClients.isEmpty()) {
                ApplicationClientDescriptor ac = (ApplicationClientDescriptor)ApplicationClientDescriptor.class.cast(appClients.iterator().next());
                Set msgDestRefs = ac.getMessageDestinationReferenceDescriptors();
                if (msgDestRefs != null && !msgDestRefs.isEmpty()) {
                    return false;
                }
                Set<EntityManagerFactoryReferenceDescriptor> entityMgrFacRefs = ac.getEntityManagerFactoryReferenceDescriptors();
                if (entityMgrFacRefs != null && !entityMgrFacRefs.isEmpty()) {
                    return false;
                }
            }
        }
        for (ModuleDescriptor<BundleDescriptor> md : app.getModules()) {
            if (md.getAlternateDescriptor() == null) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CLIENT_JAR_CHOICES {
        USE_ORIGINAL_MAKER{

            public Boolean useModuleClientJarMaker(boolean qualify) {
                return null;
            }
        }
        ,
        USE_TRANSITION_MAKER{

            public Boolean useModuleClientJarMaker(boolean qualify) {
                return qualify ? Boolean.TRUE : null;
            }
        }
        ,
        USE_COMBO_MAKER{

            public Boolean useModuleClientJarMaker(boolean qualify) {
                return new Boolean(qualify);
            }
        }
        ,
        USE_EAR_MAKER{

            public Boolean useModuleClientJarMaker(boolean qualify) {
                return Boolean.FALSE;
            }
        };

        public static CLIENT_JAR_CHOICES DEFAULT_CHOICE;

        public abstract Boolean useModuleClientJarMaker(boolean var1);

        public static CLIENT_JAR_CHOICES getClientJarChoice(String choice) {
            try {
                if (choice == null) {
                    return DEFAULT_CHOICE;
                }
                return CLIENT_JAR_CHOICES.valueOf(choice);
            }
            catch (IllegalArgumentException iae) {
                return DEFAULT_CHOICE;
            }
        }

        static {
            DEFAULT_CHOICE = USE_EAR_MAKER;
        }
    }
}

