/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.AcknowledgedCommand;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class RemoveCommand<K, V>
extends AcknowledgedCommand<K, V> {
    protected static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.remove");
    private K key;
    private String target;

    public RemoveCommand() {
        super((byte)36);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public void setKey(K key) {
        this.key = key;
    }

    @Override
    protected RemoveCommand<K, V> createNewInstance() {
        return new RemoveCommand<K, V>();
    }

    public void setTarget(String t) {
        this.target = t;
    }

    @Override
    public void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        if (this.dsc.isDoSynchronousReplication()) {
            super.writeAcknowledgementId(ros);
        }
        this.setTargetName(this.target);
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.key);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        if (this.dsc.isDoSynchronousReplication()) {
            super.readAcknowledgementId(ris);
        }
        this.key = this.dsc.getDataStoreKeyHelper().readKey(ris);
    }

    @Override
    public void execute(String initiator) {
        this.dsc.getReplicaStore().remove(this.key);
        if (this.dsc.isDoSynchronousReplication()) {
            super.sendAcknowledgement();
        }
    }

    @Override
    public void onSuccess() {
        if (this.dsc.isDoSynchronousReplication()) {
            try {
                super.onSuccess();
                super.waitForAck();
            }
            catch (Exception ex) {
                System.out.println("** Got exception: " + ex);
            }
        }
    }

    public String toString() {
        return this.getName() + "(" + this.key + ")";
    }
}

