/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.Storeable;
import org.shoal.adapter.store.commands.AcknowledgedCommand;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class StoreableFullSaveCommand<K, V extends Storeable>
extends AcknowledgedCommand<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private K k;
    private Storeable v;
    private long version = -1L;
    private transient byte[] rawReadState;
    private String replicaChoices;

    public StoreableFullSaveCommand() {
        super((byte)76);
    }

    public StoreableFullSaveCommand(K k, V v) {
        this();
        this.setKey(k);
        this.setValue(v);
    }

    @Override
    public void setKey(K k) {
        this.k = k;
    }

    public void setValue(V v) {
        this.v = v;
        this.version = v._storeable_getVersion();
    }

    @Override
    protected StoreableFullSaveCommand<K, V> createNewInstance() {
        return new StoreableFullSaveCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        if (this.dsc.isDoSynchronousReplication()) {
            super.writeAcknowledgementId(ros);
        }
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.k);
        ros.writeLong(this.v._storeable_getVersion());
        this.dsc.getDataStoreEntryHelper().writeObject(ros, this.v);
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        if (this.dsc.isDoSynchronousReplication()) {
            super.readAcknowledgementId(ris);
        }
        this.k = this.dsc.getDataStoreKeyHelper().readKey(ris);
        this.version = ris.readLong();
        this.v = (Storeable)this.dsc.getDataStoreEntryHelper().readObject(ris);
    }

    @Override
    public boolean computeTarget() {
        this.replicaChoices = this.dsc.getKeyMapper().getMappedInstance(this.dsc.getGroupName(), this.k);
        super.setTargetName(this.replicaChoices);
        return this.getTargetName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry;
        DataStoreEntry dataStoreEntry = entry = this.dsc.getReplicaStore().getOrCreateEntry(this.k);
        synchronized (dataStoreEntry) {
            Storeable entryV = (Storeable)entry.getV();
            boolean canUpdate = false;
            if (entryV != null && !entry.isRemoved() && entryV._storeable_getVersion() < this.version) {
                canUpdate = true;
            }
            if (canUpdate) {
                entry.setV(this.v);
            }
        }
        if (this.dsc.isDoSynchronousReplication()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.getName() + " About to send ACK back to " + initiator + " for key: " + this.k);
            }
            super.sendAcknowledgement();
        }
    }

    @Override
    public String getKeyMappingInfo() {
        return this.replicaChoices;
    }

    public String toString() {
        return this.getName() + "(" + this.k + ")";
    }
}

