/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class StoreableLoadResponseCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.load_response");
    private K key;
    private V v;
    private long tokenId;
    private String originatingInstance;
    private String respondingInstanceName;

    public StoreableLoadResponseCommand() {
        super((byte)72);
    }

    public StoreableLoadResponseCommand(K key, V v, long tokenId) {
        this();
        this.key = key;
        this.v = v;
        this.tokenId = tokenId;
    }

    public void setOriginatingInstance(String originatingInstance) {
        this.originatingInstance = originatingInstance;
    }

    @Override
    protected StoreableLoadResponseCommand<K, V> createNewInstance() {
        return new StoreableLoadResponseCommand<K, V>();
    }

    @Override
    protected void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.setTargetName(this.originatingInstance);
        ros.writeLong(this.tokenId);
        ros.writeLengthPrefixedString(this.originatingInstance);
        ros.writeLengthPrefixedString(this.dsc.getInstanceName());
        this.dsc.getDataStoreKeyHelper().writeKey(ros, this.key);
        ros.writeBoolean(this.v != null);
        if (this.v != null) {
            this.dsc.getDataStoreEntryHelper().writeObject(ros, this.v);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getInstanceName() + this.getName() + " sending load_response command for " + this.key + " to " + this.originatingInstance + "; " + this.v);
        }
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.originatingInstance = ris.readLengthPrefixedString();
        this.respondingInstanceName = ris.readLengthPrefixedString();
        this.key = this.dsc.getDataStoreKeyHelper().readKey(ris);
        boolean notNull = ris.readBoolean();
        if (notNull) {
            this.v = this.dsc.getDataStoreEntryHelper().readObject(ris);
        }
    }

    @Override
    public void execute(String initaitor) {
        ResponseMediator respMed = this.getDataStoreContext().getResponseMediator();
        CommandResponse resp = respMed.getCommandResponse(this.tokenId);
        if (resp != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.dsc.getInstanceName() + " received load_response key=" + this.key + "; value=" + this.v + "; from " + this.respondingInstanceName);
            }
            resp.setRespondingInstanceName(this.respondingInstanceName);
            resp.setResult(this.v);
        }
    }

    public String toString() {
        return this.getName() + "(" + this.key + ")";
    }
}

