/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.api;

import java.util.ArrayList;
import java.util.List;
import org.shoal.ha.cache.impl.command.Command;

public class DataStoreEntry<K, V> {
    private K key;
    private V v;
    private String replicaInstanceName;
    private List<Command<K, V>> pendingUpdates;
    private boolean removed;
    private long lastAccessedAt;
    private String reasonForRemoval;

    public void setKey(K key) {
        this.key = key;
    }

    public K getKey() {
        return this.key;
    }

    public V getV() {
        return this.v;
    }

    public void setV(V state) {
        this.v = state;
    }

    public String getReplicaInstanceName() {
        return this.replicaInstanceName;
    }

    public String setReplicaInstanceName(String replicaInstanceName) {
        String oldValue = this.replicaInstanceName;
        this.replicaInstanceName = replicaInstanceName;
        this.removed = false;
        return oldValue == null ? null : (oldValue.equals(replicaInstanceName) ? null : oldValue);
    }

    public List<Command<K, V>> getPendingUpdates() {
        return this.pendingUpdates;
    }

    public void clearPendingUpdates() {
        if (this.pendingUpdates != null) {
            this.pendingUpdates.clear();
        }
    }

    public void addPendingUpdate(Command<K, V> cmd) {
        if (this.pendingUpdates == null) {
            this.pendingUpdates = new ArrayList<Command<K, V>>();
        }
        this.pendingUpdates.add(cmd);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void markAsRemoved(String reason) {
        this.removed = true;
        this.v = null;
        this.pendingUpdates = null;
        this.reasonForRemoval = reason;
    }

    public long getLastAccessedAt() {
        return this.lastAccessedAt;
    }

    public void setLastAccessedAt(long lastAccessedAt) {
        this.lastAccessedAt = lastAccessedAt;
    }
}

