/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.AbstractCommandInterceptor;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.interceptor.ReplicationCommandTransmitterWithList;

public class ReplicationCommandTransmitterManager<K, V>
extends AbstractCommandInterceptor<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command");
    private ConcurrentHashMap<String, ReplicationCommandTransmitterWithList<K, V>> transmitters = new ConcurrentHashMap();
    private ReplicationCommandTransmitterWithList<K, V> broadcastTransmitter;

    @Override
    public void initialize(DataStoreContext<K, V> dsc) {
        super.initialize(dsc);
        this.broadcastTransmitter = new ReplicationCommandTransmitterWithList();
        this.broadcastTransmitter.initialize(null, dsc);
    }

    @Override
    public void onTransmit(Command<K, V> cmd, String initiator) throws DataStoreException {
        switch (cmd.getOpcode()) {
            case 1: {
                super.onTransmit(cmd, initiator);
                break;
            }
            default: {
                String target = cmd.getTargetName();
                if (target != null) {
                    ReplicationCommandTransmitterWithList<K, V> rft = this.transmitters.get(target);
                    if (rft == null) {
                        rft = new ReplicationCommandTransmitterWithList();
                        rft.initialize(target, this.getDataStoreContext());
                        ReplicationCommandTransmitterWithList<K, V> oldRCT = this.transmitters.putIfAbsent(target, rft);
                        if (oldRCT != null) {
                            rft = oldRCT;
                        }
                    }
                    rft.addCommand(cmd);
                    break;
                }
                this.broadcastTransmitter.addCommand(cmd);
            }
        }
    }
}

