/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.ReplicationInputStream;
import org.shoal.ha.cache.impl.util.ReplicationOutputStream;

public class ReplicationFramePayloadCommand<K, V>
extends Command<K, V> {
    private String targetInstanceName;
    private List<Command<K, V>> list = new ArrayList<Command<K, V>>();

    public ReplicationFramePayloadCommand() {
        super((byte)1);
    }

    public void addComamnd(Command<K, V> cmd) {
        this.list.add(cmd);
    }

    public void setTargetInstance(String target) {
        this.targetInstanceName = target;
    }

    @Override
    protected ReplicationFramePayloadCommand<K, V> createNewInstance() {
        return new ReplicationFramePayloadCommand<K, V>();
    }

    @Override
    public void writeCommandPayload(ReplicationOutputStream ros) throws IOException {
        this.setTargetName(this.targetInstanceName);
        ros.writeInt(this.list.size());
        for (Command<K, V> cmd : this.list) {
            byte[] payload = cmd.getSerializedState();
            ros.writeLengthPrefixedBytes(payload);
        }
    }

    @Override
    public void readCommandPayload(ReplicationInputStream ris) throws DataStoreException {
        int size = ris.readInt();
        this.list = new ArrayList<Command<K, V>>(size);
        for (int i = 0; i < size; ++i) {
            byte[] cmdData = ris.readLengthPrefixedBytes();
            try {
                Command cmd = this.getCommandManager().createNewInstance(cmdData[0]);
                ReplicationInputStream cmdRIS = new ReplicationInputStream(cmdData);
                cmd.prepareToExecute(cmdRIS);
                this.list.add(cmd);
                continue;
            }
            catch (IOException dse) {
                dse.printStackTrace();
            }
        }
    }

    @Override
    public void execute(String initiator) throws DataStoreException {
        for (Command<K, V> cmd : this.list) {
            this.getCommandManager().executeCommand(cmd, false, initiator);
        }
    }

    public String toString() {
        return "ReplicationFramePayloadCommand: contains " + this.list.size() + " commands";
    }
}

