/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.serverbeans.Domain;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.glassfish.admin.rest.generator.TextResourcesGenerator;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

@Path(value="/generator/")
public class GeneratorResource {
    private static final String DEFAULT_OUTPUT_DIR = System.getProperty("user.home") + "/src/glassfish/v3/admin/rest/src/main/java/org/glassfish/admin/rest/resources/generated";
    @Context
    protected Habitat habitat;

    @GET
    @Produces(value={"text/plain"})
    public String get(@QueryParam(value="outputDir") String outputDir) {
        if (outputDir == null) {
            outputDir = DEFAULT_OUTPUT_DIR;
        }
        String retVal = "Code Generation done at : " + outputDir;
        try {
            Domain entity = this.habitat.getComponent(Domain.class);
            Dom dom = Dom.unwrap((ConfigBeanProxy)entity);
            DomDocument document = dom.document;
            ConfigModel rootModel = dom.document.getRoot().model;
            TextResourcesGenerator resourcesGenerator = new TextResourcesGenerator(outputDir);
            resourcesGenerator.generateSingle(rootModel, document);
            resourcesGenerator.endGeneration();
        }
        catch (Exception ex) {
            Logger.getLogger(GeneratorResource.class.getName()).log(Level.SEVERE, null, ex);
            retVal = "Exception encountered during generation process: " + ex.toString() + "\nPlease look at server.log for more information.";
        }
        return retVal;
    }
}

