/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts;

import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.api.RecoveryResourceRegistry;
import com.sun.enterprise.transaction.api.ResourceRecoveryManager;
import com.sun.enterprise.transaction.spi.RecoveryEventListener;
import com.sun.enterprise.transaction.spi.RecoveryResourceHandler;
import com.sun.enterprise.transaction.spi.RecoveryResourceListener;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.DelegatedRecoveryManager;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ResourceRecoveryManagerImpl
implements PostConstruct,
ResourceRecoveryManager {
    @Inject
    private TransactionService txnService;
    @Inject
    private Habitat habitat;
    private JavaEETransactionManager txMgr;
    private Collection<RecoveryResourceHandler> recoveryResourceHandlers;
    private RecoveryResourceRegistry recoveryListenersRegistry;
    private static Logger _logger = LogDomains.getLogger(JavaEETransactionManagerSimplified.class, (String)"javax.enterprise.resource.jta");
    private static StringManager localStrings = StringManager.getManager(JavaEETransactionManagerSimplified.class);
    private volatile boolean lazyRecovery = false;
    private volatile boolean configured = false;

    @Override
    public void postConstruct() {
        this.recoverXAResources();
    }

    public boolean recoverIncompleteTx(boolean delegated, String logPath) throws Exception {
        return this.recoverIncompleteTx(delegated, logPath, delegated ? null : Configuration.getPropertyValue("com.sun.jts.instancename"), false);
    }

    public boolean recoverIncompleteTx(boolean delegated, String logPath, String instance, boolean notifyRecoveryListeners) throws Exception {
        boolean result = false;
        Map<RecoveryResourceHandler, Vector> handlerToXAResourcesMap = null;
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Performing recovery of incomplete Tx...");
            }
            this.configure();
            if (notifyRecoveryListeners) {
                this.beforeRecovery(delegated, instance);
            }
            Vector xaresList = new Vector();
            handlerToXAResourcesMap = this.getAllRecoverableResources(xaresList);
            int size = xaresList.size();
            XAResource[] xaresArray = new XAResource[size];
            for (int i = 0; i < size; ++i) {
                xaresArray[i] = (XAResource)xaresList.elementAt(i);
            }
            if (_logger.isLoggable(Level.FINE)) {
                String msg = localStrings.getStringWithDefault("xaresource.recovering", "Recovering {0} XA resources...", new Object[]{String.valueOf(size)});
                _logger.log(Level.FINE, msg);
            }
            if (!delegated) {
                RecoveryManager.recoverIncompleteTx(xaresArray);
                result = true;
            } else {
                result = DelegatedRecoveryManager.delegated_recover(logPath, xaresArray);
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception ex1) {
            _logger.log(Level.WARNING, "xaresource.recover_error", ex1);
            throw ex1;
        }
        finally {
            try {
                this.closeAllResources(handlerToXAResourcesMap);
            }
            catch (Exception ex1) {
                _logger.log(Level.WARNING, "xaresource.recover_error", ex1);
            }
            if (notifyRecoveryListeners) {
                this.afterRecovery(result, delegated, instance);
            }
        }
    }

    private void closeAllResources(Map<RecoveryResourceHandler, Vector> resourcesToHandlers) {
        if (resourcesToHandlers != null) {
            Set<Map.Entry<RecoveryResourceHandler, Vector>> entries = resourcesToHandlers.entrySet();
            for (Map.Entry<RecoveryResourceHandler, Vector> entry : entries) {
                RecoveryResourceHandler handler = entry.getKey();
                Vector resources = entry.getValue();
                handler.closeConnections((List)resources);
            }
        }
    }

    private Map<RecoveryResourceHandler, Vector> getAllRecoverableResources(Vector xaresList) {
        HashMap<RecoveryResourceHandler, Vector> resourcesToHandlers = new HashMap<RecoveryResourceHandler, Vector>();
        for (RecoveryResourceHandler handler : this.recoveryResourceHandlers) {
            Vector resources = new Vector();
            handler.loadXAResourcesAndItsConnections((List)xaresList, resources);
            resourcesToHandlers.put(handler, resources);
        }
        return resourcesToHandlers;
    }

    public void recoverXAResources(boolean force) {
        if (force) {
            try {
                if (!Boolean.valueOf(this.txnService.getAutomaticRecovery()).booleanValue()) {
                    return;
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "ejbserver.recovery", "Perform recovery of XAResources...");
                }
                this.configure();
                Vector xaresList = new Vector();
                Map<RecoveryResourceHandler, Vector> resourcesToHandler = this.getAllRecoverableResources(xaresList);
                int size = xaresList.size();
                XAResource[] xaresArray = new XAResource[size];
                for (int i = 0; i < size; ++i) {
                    xaresArray[i] = (XAResource)xaresList.elementAt(i);
                }
                this.resourceRecoveryStarted();
                if (_logger.isLoggable(Level.FINE)) {
                    String msg = localStrings.getStringWithDefault("xaresource.recovering", "Recovering {0} XA resources...", new Object[]{String.valueOf(size)});
                    _logger.log(Level.FINE, msg);
                }
                this.txMgr.recover(xaresArray);
                this.resourceRecoveryCompleted();
                this.closeAllResources(resourcesToHandler);
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "xaresource.recover_error", ex);
            }
        }
    }

    private void resourceRecoveryStarted() {
        Set listeners = this.recoveryListenersRegistry.getListeners();
        for (RecoveryResourceListener rrl : listeners) {
            rrl.recoveryStarted();
        }
    }

    private void resourceRecoveryCompleted() {
        Set listeners = this.recoveryListenersRegistry.getListeners();
        for (RecoveryResourceListener rrl : listeners) {
            rrl.recoveryCompleted();
        }
    }

    private void beforeRecovery(boolean delegated, String instance) {
        Set listeners = this.recoveryListenersRegistry.getEventListeners();
        for (RecoveryEventListener erl : listeners) {
            try {
                erl.beforeRecovery(delegated, instance);
            }
            catch (Throwable e) {
                _logger.log(Level.WARNING, "", e);
                _logger.log(Level.WARNING, "jts.before_recovery_excep", e);
            }
        }
    }

    private void afterRecovery(boolean success, boolean delegated, String instance) {
        Set listeners = this.recoveryListenersRegistry.getEventListeners();
        for (RecoveryEventListener erl : listeners) {
            try {
                erl.afterRecovery(success, delegated, instance);
            }
            catch (Throwable e) {
                _logger.log(Level.WARNING, "", e);
                _logger.log(Level.WARNING, "jts.after_recovery_excep", e);
            }
        }
    }

    public void setLazyRecovery(boolean lazy) {
        this.lazyRecovery = lazy;
    }

    public void recoverXAResources() {
        this.recoverXAResources(!this.lazyRecovery);
    }

    private void configure() {
        if (this.configured) {
            return;
        }
        this.recoveryResourceHandlers = this.habitat.getAllByContract(RecoveryResourceHandler.class);
        this.txMgr = this.habitat.getByContract(JavaEETransactionManager.class);
        this.recoveryListenersRegistry = this.habitat.getComponent(RecoveryResourceRegistry.class);
        if (this.recoveryListenersRegistry == null) {
            throw new IllegalStateException();
        }
        RecoveryManager.startTransactionRecoveryFence();
        this.configured = true;
    }
}

