/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

public class TypeHelperImpl
extends BasicTypeHelperImpl
implements TypeHelper {
    private final AbstractSession session;
    private final ClassLoader classLoader;

    public TypeHelperImpl(AbstractSession session, ClassLoader classLoader) {
        this.session = session;
        this.classLoader = classLoader;
    }

    public Object resolveTypeName(String typeName) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedClassForName(typeName, true, this.classLoader));
                }
                catch (PrivilegedActionException exception) {
                    return null;
                }
            }
            return PrivilegedAccessHelper.getClassForName(typeName, true, this.classLoader);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public Object resolveAttribute(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        if (mapping != null) {
            return this.getType(mapping);
        }
        QueryKey queryKey = this.resolveQueryKey(ownerClass, attribute);
        if (queryKey == null) {
            return null;
        }
        if (queryKey.isForeignReferenceQueryKey()) {
            return ((ForeignReferenceQueryKey)queryKey).getReferenceClass();
        }
        return Object.class;
    }

    public Object resolveMapKey(Object ownerClass, String attribute) {
        Object type = null;
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        if (mapping.isCollectionMapping()) {
            ContainerPolicy cp = ((CollectionMapping)mapping).getContainerPolicy();
            type = cp.getKeyType();
        }
        return type;
    }

    public Object resolveSchema(String schemaName) {
        ClassDescriptor descriptor = this.session.getDescriptorForAlias(schemaName);
        return descriptor != null ? descriptor.getJavaClass() : null;
    }

    public Object resolveEnumConstant(Object type, String constant) {
        Class clazz = this.getJavaClass(type);
        T[] constants = clazz.getEnumConstants();
        if (constants != null) {
            for (int i = 0; i < constants.length; ++i) {
                if (!constant.equals(constants[i].toString())) continue;
                return constants[i];
            }
        }
        return null;
    }

    public boolean isEntityClass(Object type) {
        ClassDescriptor desc = this.getDescriptor(type);
        return desc != null && !desc.isAggregateDescriptor();
    }

    public boolean isOrderableType(Object type) {
        return !this.isEntityClass(type) && !this.isEmbeddable(type);
    }

    public boolean isEmbeddable(Object type) {
        ClassDescriptor desc = this.getDescriptor(type);
        return desc != null && desc.isAggregateDescriptor();
    }

    public boolean isEmbeddedAttribute(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isAggregateMapping();
    }

    public boolean isSimpleStateAttribute(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isDirectToFieldMapping();
    }

    public boolean isRelationship(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isForeignReferenceMapping();
    }

    public boolean isSingleValuedRelationship(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && mapping.isObjectReferenceMapping();
    }

    public boolean isCollectionValuedRelationship(Object ownerClass, String attribute) {
        DatabaseMapping mapping = this.resolveAttributeMapping(ownerClass, attribute);
        return mapping != null && (mapping.isOneToManyMapping() || mapping.isManyToManyMapping());
    }

    private ClassDescriptor getDescriptor(Object type) {
        ClassDescriptor desc = null;
        if (type instanceof Class) {
            desc = this.session.getDescriptor((Class)type);
        } else if (type instanceof ClassDescriptor) {
            desc = (ClassDescriptor)type;
        }
        return desc;
    }

    private DatabaseMapping resolveAttributeMapping(Object ownerClass, String attribute) {
        ClassDescriptor descriptor = this.getDescriptor(ownerClass);
        return descriptor == null ? null : descriptor.getObjectBuilder().getMappingForAttributeName(attribute);
    }

    public QueryKey resolveQueryKey(Object ownerClass, String attribute) {
        ClassDescriptor descriptor = this.getDescriptor(ownerClass);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getQueryKeyNamed(attribute);
    }

    private Object getType(DatabaseMapping mapping) {
        if (mapping == null) {
            return null;
        }
        Class<Object> type = null;
        if (mapping.isDirectCollectionMapping()) {
            type = ((DirectCollectionMapping)mapping).getDirectField().getType();
            if (type == null) {
                type = Object.class;
            }
        } else {
            ClassDescriptor descriptor;
            type = mapping.isForeignReferenceMapping() ? ((descriptor = mapping.getReferenceDescriptor()) == null ? null : descriptor.getJavaClass()) : (mapping.isAggregateMapping() ? ((AggregateMapping)mapping).getReferenceDescriptor() : mapping.getAttributeAccessor().getAttributeClass());
        }
        return type;
    }
}

