/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;

public class XMLCollectionReferenceMappingMarshalNodeValue
extends MappingNodeValue
implements ContainerValue {
    private XMLCollectionReferenceMapping xmlCollectionReferenceMapping;
    private XPathNode branchNode;

    public XMLCollectionReferenceMappingMarshalNodeValue(XMLCollectionReferenceMapping xmlCollectionReferenceMapping) {
        this.xmlCollectionReferenceMapping = xmlCollectionReferenceMapping;
        this.branchNode = new XPathNode();
        NamespaceResolver namespaceResolver = ((XMLDescriptor)xmlCollectionReferenceMapping.getDescriptor()).getNamespaceResolver();
        Vector fkFields = xmlCollectionReferenceMapping.getFields();
        int fkFieldsSize = fkFields.size();
        for (int x = 0; x < fkFieldsSize; ++x) {
            XMLField fkField = (XMLField)fkFields.get(x);
            this.branchNode.addChild(fkField.getXPathFragment(), new XMLCollectionReferenceMappingFKMarshalNodeValue(xmlCollectionReferenceMapping, fkField), namespaceResolver);
        }
    }

    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    public ContainerPolicy getContainerPolicy() {
        return this.xmlCollectionReferenceMapping.getContainerPolicy();
    }

    public XMLCollectionReferenceMapping getMapping() {
        return this.xmlCollectionReferenceMapping;
    }

    public boolean getReuseContainer() {
        return this.xmlCollectionReferenceMapping.getReuseContainer();
    }

    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCollectionReferenceMapping.setAttributeValueInObject(object, containerInstance);
    }

    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        Object iterator;
        if (this.xmlCollectionReferenceMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlCollectionReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (null == collection) {
            return false;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (!cp.hasNext(iterator = cp.iteratorFor(collection))) {
            return false;
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        if (xPathFragment != XPathFragment.SELF_FRAGMENT) {
            marshalRecord.openStartElement(xPathFragment, namespaceResolver);
        }
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        if (xPathFragment != XPathFragment.SELF_FRAGMENT) {
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        return true;
    }

    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (this.xmlCollectionReferenceMapping.usesSingleNode()) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            if (xPathFragment.isAttribute()) {
                marshalRecord.attribute(xPathFragment, namespaceResolver, (String)value);
                marshalRecord.closeStartGroupingElements(groupingFragment);
            } else {
                marshalRecord.closeStartGroupingElements(groupingFragment);
                marshalRecord.characters((String)value);
            }
        } else {
            int size = marshalContext.getNonAttributeChildrenSize(this.branchNode);
            for (int x = 0; x < size; ++x) {
                XPathNode xPathNode = (XPathNode)marshalContext.getNonAttributeChild(x, this.branchNode);
                xPathNode.marshal(marshalRecord, value, session, namespaceResolver, marshalRecord.getMarshaller(), marshalContext.getMarshalContext(x), null);
            }
        }
        return true;
    }

    public boolean isMarshalNodeValue() {
        return !this.xmlCollectionReferenceMapping.usesSingleNode();
    }

    public boolean isUnmarshalNodeValue() {
        return false;
    }

    private static class XMLCollectionReferenceMappingFKMarshalNodeValue
    extends MappingNodeValue {
        private XMLCollectionReferenceMapping xmlCollectionReferenceMapping;
        private XMLField xmlField;

        public XMLCollectionReferenceMappingFKMarshalNodeValue(XMLCollectionReferenceMapping xmlCollectionReferenceMapping, XMLField xmlField) {
            this.xmlCollectionReferenceMapping = xmlCollectionReferenceMapping;
            this.xmlField = xmlField;
        }

        public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
            return this.marshalSingleValue(xPathFragment, marshalRecord, null, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }

        public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
            QName schemaType;
            String stringValue;
            Object fieldValue = this.xmlCollectionReferenceMapping.buildFieldValue(value, this.xmlField, session);
            if (fieldValue == null) {
                if (null != value) {
                    XMLField f2 = (XMLField)this.xmlCollectionReferenceMapping.getSourceToTargetKeyFieldAssociations().get(this.xmlField);
                    fieldValue = marshalRecord.getMarshaller().getXMLContext().getValueByXPath(value, f2.getXPath(), f2.getNamespaceResolver(), Object.class);
                }
                if (null == fieldValue) {
                    return false;
                }
            }
            if ((stringValue = this.getValueToWrite(schemaType = this.getSchemaType(this.xmlField, fieldValue, session), fieldValue, (XMLConversionManager)session.getDatasourcePlatform().getConversionManager(), namespaceResolver)) != null) {
                if (xPathFragment.isAttribute()) {
                    marshalRecord.attribute(xPathFragment, namespaceResolver, stringValue);
                    marshalRecord.closeStartElement();
                } else {
                    marshalRecord.closeStartElement();
                    marshalRecord.characters(stringValue);
                }
                return true;
            }
            return false;
        }

        public XMLCollectionReferenceMapping getMapping() {
            return this.xmlCollectionReferenceMapping;
        }
    }
}

