/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.ArrayListContainerPolicy;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.IndirectListContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.OrderedListContainerPolicy;
import org.eclipse.persistence.internal.queries.SortedCollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.VectorContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerPolicy
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6971791021041582975L;
    protected static Class defaultContainerClass = ClassConstants.Vector_class;
    protected transient ClassDescriptor elementDescriptor;
    protected transient Constructor constructor;

    public static Class getDefaultContainerClass() {
        return defaultContainerClass;
    }

    public static void setDefaultContainerClass(Class collectionClass) {
        defaultContainerClass = collectionClass;
    }

    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
    }

    public void addFieldsForMapKey(AbstractRecord joinRow) {
    }

    public boolean addInto(Object element, Object container, AbstractSession session) {
        return this.addInto(null, element, container, session);
    }

    public boolean addInto(Object element, Object container, AbstractSession session, AbstractRecord dbRow, ObjectBuildingQuery query) {
        return this.addInto(null, element, container, session);
    }

    public boolean addAll(List elements, Object container, AbstractSession session, List<AbstractRecord> dbRows, ObjectBuildingQuery query) {
        boolean changed = false;
        for (int i = 0; i < elements.size(); ++i) {
            changed |= this.addInto(elements.get(i), container, session, dbRows.get(i), query);
        }
        return changed;
    }

    public boolean addInto(Object element, Object container, AbstractSession session, AbstractRecord row, DataReadQuery query) {
        return this.addInto(null, element, container, session);
    }

    public boolean addAll(List elements, Object container, AbstractSession session, List<AbstractRecord> rows, DataReadQuery query) {
        boolean changed = false;
        for (int i = 0; i < elements.size(); ++i) {
            changed |= this.addInto(elements.get(i), container, session, rows.get(i), query);
        }
        return changed;
    }

    public boolean addInto(Object key, Object element, Object container, AbstractSession session) {
        throw QueryException.cannotAddToContainer(element, container, this);
    }

    public void addNestedJoinsQueriesForMapKey(JoinedAttributeManager joinManager, ObjectLevelReadQuery query, AbstractSession session) {
    }

    public void addNextValueFromIteratorInto(Object valuesIterator, Object parent, Object toCollection, CollectionMapping mapping, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        Object cloneValue = mapping.buildElementClone(this.next(valuesIterator, unitOfWork), parent, unitOfWork, isExisting);
        if (!isExisting && mapping.isCandidateForPrivateOwnedRemoval() && unitOfWork.shouldDiscoverNewObjects() && cloneValue != null && unitOfWork.isObjectNew(cloneValue)) {
            unitOfWork.addPrivateOwnedObject(mapping, cloneValue);
        }
        this.addInto(cloneValue, toCollection, unitOfWork);
    }

    public Object buildCloneForKey(Object key, Object parent, UnitOfWorkImpl uow, boolean isExisting) {
        return key;
    }

    public Object buildCollectionEntry(Object objectAdded, ObjectChangeSet changeSet) {
        return objectAdded;
    }

    public Object buildContainerFromVector(Vector vector, AbstractSession session) {
        Object container = this.containerInstance(vector.size());
        int size = vector.size();
        for (int index = 0; index < size; ++index) {
            this.addInto(vector.get(index), container, session);
        }
        return container;
    }

    public Object buildKey(AbstractRecord row, ObjectBuildingQuery query, AbstractSession session) {
        return null;
    }

    public Object[] buildReferencesPKList(Object container, AbstractSession session) {
        Object[] result = new Object[this.sizeFor(container)];
        Iterator iterator = (Iterator)this.iteratorFor(container);
        int index = 0;
        while (iterator.hasNext()) {
            Object target = iterator.next();
            if (target == null) continue;
            CMPPolicy policy = this.elementDescriptor.getCMPPolicy();
            result[index] = policy != null && policy.isCMP3Policy() ? policy.createPrimaryKeyInstance(target, session) : this.elementDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(target, session);
            ++index;
        }
        return result;
    }

    public Object buildKeyFromJoinedRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession session) {
        return null;
    }

    public static ContainerPolicy buildDefaultPolicy() {
        return ContainerPolicy.buildPolicyFor(ContainerPolicy.getDefaultContainerClass());
    }

    public static ContainerPolicy buildPolicyFor(Class concreteContainerClass) {
        return ContainerPolicy.buildPolicyFor(concreteContainerClass, false);
    }

    public static ContainerPolicy buildPolicyFor(Class concreteContainerClass, boolean hasOrdering) {
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.List_Class)) {
            if (hasOrdering) {
                return new OrderedListContainerPolicy(concreteContainerClass);
            }
            if (concreteContainerClass == ClassConstants.Vector_class) {
                return new VectorContainerPolicy(concreteContainerClass);
            }
            if (concreteContainerClass == ClassConstants.IndirectList_Class) {
                return new IndirectListContainerPolicy(concreteContainerClass);
            }
            if (concreteContainerClass == ClassConstants.ArrayList_class) {
                return new ArrayListContainerPolicy(concreteContainerClass);
            }
            return new ListContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.SortedSet_Class)) {
            return new SortedCollectionContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.Collection_Class)) {
            return new CollectionContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.Map_Class)) {
            return new MapContainerPolicy(concreteContainerClass);
        }
        if (concreteContainerClass.equals(ClassConstants.CursoredStream_Class)) {
            return new CursoredStreamPolicy();
        }
        if (concreteContainerClass.equals(ClassConstants.ScrollableCursor_Class)) {
            return new ScrollableCursorPolicy();
        }
        throw ValidationException.illegalContainerClass(concreteContainerClass);
    }

    public ReadQuery buildSelectionQueryForDirectCollectionMapping() {
        DirectReadQuery query = new DirectReadQuery();
        query.setSQLStatement(new SQLSelectStatement());
        query.setContainerPolicy(this);
        return query;
    }

    public void clear(Object container) {
        throw QueryException.methodNotValid(this, "clear(Object container)");
    }

    public abstract CollectionChangeEvent createChangeEvent(Object var1, String var2, Object var3, Object var4, int var5, Integer var6);

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass());
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow) {
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public ContainerPolicy clone(ReadQuery query) {
        return (ContainerPolicy)this.clone();
    }

    public Object cloneFor(Object container) {
        throw QueryException.cannotCreateClone(this, container);
    }

    protected void createChangeSetForKeys(Map originalKeyValues, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
    }

    protected void collectObjectForNewCollection(Map originalKeyValues, Map cloneKeyValues, Object newCollection, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        Object cloneIter = this.iteratorFor(newCollection);
        while (this.hasNext(cloneIter)) {
            Object wrappedFirstObject = this.nextEntry(cloneIter, session);
            Object firstObject = this.unwrapIteratorResult(wrappedFirstObject);
            if (firstObject == null) continue;
            Object key = firstObject;
            if (changeRecord.getMapping().isAggregateCollectionMapping()) {
                key = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session);
            }
            if (originalKeyValues.containsKey(key)) {
                if (this.compareKeys(firstObject, session)) {
                    originalKeyValues.remove(key);
                    continue;
                }
                Object backUpVersion = null;
                backUpVersion = ((UnitOfWorkImpl)session).isClassReadOnly(firstObject.getClass()) ? firstObject : ((UnitOfWorkImpl)session).getBackupClone(firstObject, referenceDescriptor);
                ObjectChangeSet changeSet = referenceDescriptor.getObjectBuilder().createObjectChangeSet(firstObject, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
                changeSet.setOldKey(this.keyFrom(backUpVersion, session));
                changeSet.setNewKey(this.keyFrom(firstObject, session));
                cloneKeyValues.put(key, firstObject);
                continue;
            }
            this.buildChangeSetForNewObjectInCollection(wrappedFirstObject, referenceDescriptor, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
            cloneKeyValues.put(key, firstObject);
        }
    }

    public void compareCollectionsForChange(Object oldCollection, Object newCollection, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        AbstractMap originalKeyValues = null;
        AbstractMap cloneKeyValues = null;
        if (changeRecord.getMapping().isAggregateCollectionMapping()) {
            originalKeyValues = new HashMap();
            cloneKeyValues = new HashMap();
        } else {
            originalKeyValues = new IdentityHashMap();
            cloneKeyValues = new IdentityHashMap();
        }
        if (oldCollection != null) {
            Object backUpIter = this.iteratorFor(oldCollection);
            while (this.hasNext(backUpIter)) {
                Object wrappedSecondObject = this.nextEntry(backUpIter, session);
                Object secondObject = this.unwrapIteratorResult(wrappedSecondObject);
                if (secondObject == null) continue;
                Object key = secondObject;
                if (changeRecord.getMapping().isAggregateCollectionMapping()) {
                    key = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(secondObject, session);
                }
                originalKeyValues.put(key, wrappedSecondObject);
            }
        }
        if (newCollection != null) {
            this.collectObjectForNewCollection(originalKeyValues, cloneKeyValues, newCollection, changeRecord, session, referenceDescriptor);
        }
        this.createChangeSetForKeys(originalKeyValues, changeRecord, session, referenceDescriptor);
        changeRecord.addAdditionChange(cloneKeyValues, this, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addRemoveChange(originalKeyValues, this, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
    }

    public void buildChangeSetForNewObjectInCollection(Object object, ClassDescriptor referenceDescriptor, UnitOfWorkChangeSet uowChangeSet, AbstractSession session) {
    }

    public boolean compareKeys(Object sourceKey, AbstractSession session) {
        return true;
    }

    public Object concatenateContainers(Object firstContainer, Object secondContainer, AbstractSession session) {
        Object container = this.containerInstance(this.sizeFor(firstContainer) + this.sizeFor(secondContainer));
        Object firstIter = this.iteratorFor(firstContainer);
        while (this.hasNext(firstIter)) {
            this.addInto(null, this.next(firstIter), container, session);
        }
        Object secondIter = this.iteratorFor(secondContainer);
        while (this.hasNext(secondIter)) {
            this.addInto(null, this.next(secondIter), container, session);
        }
        return container;
    }

    public Object containerInstance() {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getContainerClass()));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(this.getContainerClass());
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), ex);
        }
    }

    public Object containerInstance(int initialCapacity) {
        if (this.getConstructor() == null) {
            return this.containerInstance();
        }
        try {
            Object[] arguments = new Object[]{initialCapacity};
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.getConstructor(), arguments));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception.getException());
                }
            }
            return PrivilegedAccessHelper.invokeConstructor(this.getConstructor(), arguments);
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), ex);
        }
    }

    protected boolean contains(Object element, Object container) {
        throw QueryException.methodNotValid(this, "contains(Object element, Object container)");
    }

    public boolean contains(Object element, Object container, AbstractSession session) {
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object iterator = this.iteratorFor(container);
            while (this.hasNext(iterator)) {
                Object next = this.next(iterator);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(next, session).equals(element)) continue;
                return true;
            }
            return false;
        }
        return this.contains(element, container);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object createWrappedObjectFromExistingWrappedObject(Object wrappedObject, Object parent, ClassDescriptor referenceDescriptor, MergeManager mergeManager) {
        return referenceDescriptor.getObjectBuilder().wrapObject(mergeManager.getTargetVersionOfSourceObject(this.unwrapIteratorResult(wrappedObject)), mergeManager.getSession());
    }

    public void deleteWrappedObject(Object objectDeleted, AbstractSession session) {
        session.deleteObject(objectDeleted);
    }

    public Object execute() {
        throw QueryException.methodNotValid(this, "execute()");
    }

    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        return null;
    }

    public List<DatabaseField> getAdditionalFieldsForJoin(CollectionMapping baseMapping) {
        return null;
    }

    public Iterator getChangeValuesFrom(Map map) {
        return map.values().iterator();
    }

    public Object getCloneDataFromChangeSet(ObjectChangeSet changeSet) {
        return changeSet.getUnitOfWorkClone();
    }

    protected Constructor getConstructor() {
        return this.constructor;
    }

    public Class getContainerClass() {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public String getContainerClassName() {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public ClassDescriptor getDescriptorForMapKey() {
        return null;
    }

    public ClassDescriptor getElementDescriptor() {
        return this.elementDescriptor;
    }

    public List<DatabaseField> getIdentityFieldsForMapKey() {
        return null;
    }

    public Map getKeyMappingDataForWriteQuery(Object object, AbstractSession session) {
        return null;
    }

    public Expression getKeySelectionCriteria() {
        return null;
    }

    public Object getKeyType() {
        return null;
    }

    public boolean hasElementDescriptor() {
        return this.elementDescriptor != null;
    }

    public abstract boolean hasNext(Object var1);

    public boolean hasOrder() {
        return false;
    }

    public void initialize(AbstractSession session, DatabaseTable keyTable) {
    }

    public void initializeConstructor() {
        try {
            Constructor constructor = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false));
                }
                catch (PrivilegedActionException exception) {
                    return;
                }
            } else {
                constructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false);
            }
            this.setConstructor(constructor);
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isCollectionPolicy() {
        return false;
    }

    public boolean isCursoredStreamPolicy() {
        return false;
    }

    public boolean isScrollableCursorPolicy() {
        return false;
    }

    public boolean isCursorPolicy() {
        return false;
    }

    public boolean isDirectMapPolicy() {
        return false;
    }

    public boolean isEmpty(Object container) {
        return this.sizeFor(container) == 0;
    }

    public boolean isListPolicy() {
        return false;
    }

    public boolean isOrderedListPolicy() {
        return false;
    }

    public boolean isMapPolicy() {
        return false;
    }

    public boolean isMappedKeyMapPolicy() {
        return false;
    }

    public boolean isMapKeyObject() {
        return false;
    }

    public boolean isValidContainer(Object container) {
        throw QueryException.methodNotValid(this, "isValidContainer(Object container)");
    }

    public boolean isValidContainerType(Class containerType) {
        throw QueryException.methodNotValid(this, "isValidContainerType(Class containerType)");
    }

    public void iterateOnMapKey(DescriptorIterator iterator, Object element) {
    }

    public abstract Object iteratorFor(Object var1);

    public Object keyFrom(Object element, AbstractSession session) {
        return null;
    }

    public Object keyFromEntry(Object entry) {
        return null;
    }

    public Object keyFromIterator(Object iterator) {
        return null;
    }

    public Object mergeCascadeParts(ObjectChangeSet objectChanges, MergeManager mergeManager, AbstractSession parentSession) {
        Object object = null;
        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
            object = objectChanges.getTargetVersionOfSourceObject(mergeManager, parentSession);
            if (object == null && (objectChanges.isNew() || objectChanges.isAggregate()) && objectChanges.containsChangesFromSynchronization()) {
                if (!mergeManager.getObjectsAlreadyMerged().containsKey(objectChanges)) {
                    Class objectClass = objectChanges.getClassType(mergeManager.getSession());
                    object = mergeManager.getSession().getDescriptor(objectClass).getObjectBuilder().buildNewInstance();
                    mergeManager.getObjectsAlreadyMerged().put(objectChanges, object);
                } else {
                    object = mergeManager.getObjectsAlreadyMerged().get(objectChanges);
                }
            } else {
                object = objectChanges.getTargetVersionOfSourceObject(mergeManager, parentSession, true);
            }
            if (objectChanges.containsChangesFromSynchronization()) {
                mergeManager.mergeChanges(object, objectChanges);
            }
        } else {
            mergeManager.mergeChanges(objectChanges.getUnitOfWorkClone(), objectChanges);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChanges(CollectionChangeRecord changeRecord, Object valueOfTarget, boolean shouldMergeCascadeParts, MergeManager mergeManager, AbstractSession parentSession) {
        Iterator removeObjects = changeRecord.getRemoveObjectList().keySet().iterator();
        Object synchronizedValueOfTarget = valueOfTarget;
        if (valueOfTarget instanceof IndirectCollection) {
            synchronizedValueOfTarget = ((IndirectCollection)valueOfTarget).getDelegateObject();
        }
        Object object = synchronizedValueOfTarget;
        synchronized (object) {
            while (removeObjects.hasNext()) {
                ObjectChangeSet objectChanges = (ObjectChangeSet)removeObjects.next();
                this.removeFrom(objectChanges.getOldKey(), objectChanges.getTargetVersionOfSourceObject(mergeManager, mergeManager.getSession()), valueOfTarget, parentSession);
                if (mergeManager.shouldMergeChangesIntoDistributedCache()) continue;
                mergeManager.registerRemovedNewObjectIfRequired(objectChanges.getUnitOfWorkClone());
            }
            for (ObjectChangeSet objectChanges : changeRecord.getAddObjectList().keySet()) {
                Object object2 = null;
                if (shouldMergeCascadeParts) {
                    object2 = this.mergeCascadeParts(objectChanges, mergeManager, parentSession);
                }
                if (object2 == null) {
                    object2 = objectChanges.getTargetVersionOfSourceObject(mergeManager, mergeManager.getSession(), false);
                }
                if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                    if (this.contains(object2, valueOfTarget, mergeManager.getSession())) continue;
                    this.addInto(objectChanges.getNewKey(), object2, valueOfTarget, mergeManager.getSession());
                    continue;
                }
                this.addInto(objectChanges.getNewKey(), object2, valueOfTarget, mergeManager.getSession());
            }
        }
    }

    protected abstract Object next(Object var1);

    public Object next(Object iterator, AbstractSession session) {
        Object next = this.next(iterator);
        if (this.hasElementDescriptor()) {
            next = this.getElementDescriptor().getObjectBuilder().unwrapObject(next, session);
        }
        return next;
    }

    public Object nextEntry(Object iterator) {
        return this.next(iterator);
    }

    public Object nextEntry(Object iterator, AbstractSession session) {
        return this.next(iterator, session);
    }

    public boolean overridesRead() {
        return false;
    }

    public void postInitialize(AbstractSession session) {
    }

    public void postCalculateChanges(ObjectChangeSet ocs, ClassDescriptor referenceDescriptor, DatabaseMapping mapping, UnitOfWorkImpl uow) {
        if (mapping.isForeignReferenceMapping()) {
            Object clone = ocs.getUnitOfWorkClone();
            uow.addDeletedPrivateOwnedObjects(mapping, clone);
        }
    }

    public void postCalculateChanges(Object key, Object value, ClassDescriptor referenceDescriptor, DatabaseMapping mapping, UnitOfWorkImpl uow) {
        if (!mapping.isDirectCollectionMapping() && !mapping.isAggregateCollectionMapping()) {
            uow.addDeletedPrivateOwnedObjects(mapping, value);
        }
    }

    public void recordPrivateOwnedRemovals(Object object, ClassDescriptor referenceDescriptor, UnitOfWorkImpl uow) {
        if (referenceDescriptor != null) {
            referenceDescriptor.getObjectBuilder().recordPrivateOwnedRemovals(this.unwrapIteratorResult(object), uow, false);
        }
    }

    public void prepare(DatabaseQuery query, AbstractSession session) throws QueryException {
        if (query.isReadAllQuery() && !query.isReportQuery() && query.shouldUseWrapperPolicy()) {
            this.setElementDescriptor(query.getDescriptor());
        } else if (query.isDataReadQuery()) {
            ((DataReadQuery)query).setContainerPolicy(this);
        }
    }

    public void prepareForExecution() throws QueryException {
    }

    public void processAdditionalWritableMapKeyFields(AbstractSession session) {
    }

    public void propogatePostDelete(DeleteObjectQuery query, Object object) {
    }

    public void propogatePostInsert(WriteObjectQuery query, Object object) {
    }

    public void propogatePostUpdate(WriteObjectQuery query, Object object) {
    }

    public void propogatePreDelete(DeleteObjectQuery query, Object object) {
    }

    public void propogatePreInsert(WriteObjectQuery query, Object object) {
    }

    public void propogatePreUpdate(WriteObjectQuery query, Object object) {
    }

    public boolean propagatesEventsToCollection() {
        return false;
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet changeSetToAdd, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(changeSetToAdd)) {
            collectionChangeRecord.getRemoveObjectList().remove(changeSetToAdd);
        } else {
            collectionChangeRecord.getAddObjectList().put(changeSetToAdd, changeSetToAdd);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet changeSetToRemove, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(changeSetToRemove)) {
            collectionChangeRecord.getAddObjectList().remove(changeSetToRemove);
        } else {
            collectionChangeRecord.getRemoveObjectList().put(changeSetToRemove, changeSetToRemove);
        }
    }

    public void recordUpdateToCollectionInChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, CollectionChangeRecord collectionChangeRecord) {
        if (event.getChangeType() == CollectionChangeEvent.ADD) {
            this.recordAddToCollectionInChangeRecord(changeSet, collectionChangeRecord);
        } else if (event.getChangeType() == CollectionChangeEvent.REMOVE) {
            this.recordRemoveFromCollectionInChangeRecord(changeSet, collectionChangeRecord);
        } else {
            throw ValidationException.wrongCollectionChangeEventType(event.getChangeType());
        }
    }

    public Object remoteExecute() {
        return null;
    }

    protected boolean removeFrom(Object key, Object element, Object container) {
        throw QueryException.cannotRemoveFromContainer(element, container, this);
    }

    public boolean removeFrom(Object key, Object element, Object container, AbstractSession session) {
        Object objectToRemove = element;
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object iterator = this.iteratorFor(container);
            while (this.hasNext(iterator)) {
                Object next = this.next(iterator);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(next, session).equals(element)) continue;
                objectToRemove = next;
                break;
            }
        }
        return this.removeFrom(key, objectToRemove, container);
    }

    public boolean removeFrom(Object element, Object container, AbstractSession session) {
        return this.removeFrom(null, element, container, session);
    }

    public boolean requiresDataModificationEvents() {
        return false;
    }

    protected void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public void setContainerClass(Class containerClass) {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public void setContainerClassName(String containerClassName) {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public void setElementDescriptor(ClassDescriptor elementDescriptor) {
        this.elementDescriptor = elementDescriptor;
    }

    public void setKeyName(String instanceVariableName, String elementClassName) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, instanceVariableName);
    }

    public void setKeyName(String instanceVariableName, Class elementClass) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, instanceVariableName);
    }

    public boolean shouldAddAll() {
        return false;
    }

    public boolean shouldIncludeKeyInDeleteEvent() {
        return false;
    }

    public boolean shouldUpdateForeignKeysPostInsert() {
        return false;
    }

    public int sizeFor(Object container) {
        throw QueryException.methodNotValid(this, "sizeFor(Object container)");
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.toStringInfo() + ")";
    }

    protected Object toStringInfo() {
        return "";
    }

    public int updateJoinedMappingIndexesForMapKey(Map<DatabaseMapping, Object> indexList, int index) {
        return 0;
    }

    public Object unwrapElement(Object object) {
        return object;
    }

    public Object unwrapIteratorResult(Object object) {
        return object;
    }

    public Object valueFromPKList(Object[] pks, AbstractSession session) {
        Object result = this.containerInstance(pks.length);
        for (int index = 0; index < pks.length; ++index) {
            Object pk = null;
            pk = this.elementDescriptor.hasCMPPolicy() ? this.elementDescriptor.getCMPPolicy().createPrimaryKeyFromId(pks[index], session) : pks[index];
            ReadObjectQuery query = new ReadObjectQuery();
            query.setReferenceClass(this.elementDescriptor.getJavaClass());
            query.setSelectionId(pk);
            query.setIsExecutionClone(true);
            this.addInto(session.executeQuery(query), result, session);
        }
        return result;
    }

    public Vector vectorFor(Object container, AbstractSession session) {
        Vector<Object> result = new Vector<Object>(this.sizeFor(container));
        Object iter = this.iteratorFor(container);
        while (this.hasNext(iter)) {
            result.addElement(this.next(iter, session));
        }
        return result;
    }

    public static void copyMapDataToRow(Map mappingData, AbstractRecord databaseRow) {
        if (mappingData != null) {
            for (Map.Entry entry : mappingData.entrySet()) {
                Object entryKey = entry.getKey();
                Object entryValue = entry.getValue();
                databaseRow.put(entryKey, entryValue);
            }
        }
    }
}

