/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DB2Platform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class DerbyPlatform
extends DB2Platform {
    public static final int MAX_CLOB = Integer.MAX_VALUE;
    public static final int MAX_BLOB = Integer.MAX_VALUE;

    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        super.appendByteArray(bytes, writer);
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("VALUES CURRENT_TIMESTAMP");
        }
        return this.timestampQuery;
    }

    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        throw new RuntimeException("Should never reach here");
    }

    public String getProcedureEndString() {
        return this.getBatchEndString();
    }

    public String getProcedureBeginString() {
        return this.getBatchBeginString();
    }

    public String getInOutputProcedureToken() {
        return "INOUT";
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return false;
    }

    public boolean isDerby() {
        return true;
    }

    public boolean isDB2() {
        return false;
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE WITH RS";
    }

    public boolean shouldIgnoreException(SQLException exception) {
        return false;
    }

    protected String getCreateTempTableSqlSuffix() {
        return " ON COMMIT DELETE ROWS NOT LOGGED";
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        selectQuery.setSQLString("values IDENTITY_VAL_LOCAL()");
        return selectQuery;
    }

    protected boolean shouldTempTableSpecifyPrimaryKeys() {
        return false;
    }

    protected String getCreateTempTableSqlBodyForTable(DatabaseTable table) {
        return null;
    }

    public void writeUpdateOriginalFromTempTableSql(Writer writer, DatabaseTable table, Collection pkFields, Collection assignedFields) throws IOException {
        writer.write("UPDATE ");
        String tableName = table.getQualifiedNameDelimited(this);
        writer.write(tableName);
        writer.write(" SET ");
        String tempTableName = this.getTempTableForTable(table).getQualifiedNameDelimited(this);
        boolean isFirst = true;
        Iterator itFields = assignedFields.iterator();
        while (itFields.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                writer.write(", ");
            }
            DatabaseField field = (DatabaseField)itFields.next();
            String fieldName = field.getNameDelimited(this);
            writer.write(fieldName);
            writer.write(" = (SELECT ");
            writer.write(fieldName);
            writer.write(" FROM ");
            writer.write(tempTableName);
            DerbyPlatform.writeAutoJoinWhereClause(writer, null, tableName, pkFields, this);
            writer.write(")");
        }
        writer.write(" WHERE EXISTS(SELECT ");
        writer.write(((DatabaseField)pkFields.iterator().next()).getNameDelimited(this));
        writer.write(" FROM ");
        writer.write(tempTableName);
        DerbyPlatform.writeAutoJoinWhereClause(writer, null, tableName, pkFields, this);
        writer.write(")");
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" GENERATED BY DEFAULT AS IDENTITY");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("SMALLINT DEFAULT 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 15));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("DECIMAL", 15));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("CLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("CLOB", Integer.MAX_VALUE));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        return fieldTypeMapping;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction(42, "DOUBLE"));
    }

    public void printSQLSelectStatement(DatabaseCall call, ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        call.setFields(statement.printSQL(printer));
    }

    public boolean supportsSequenceObjects() {
        return false;
    }
}

