/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.io.StringWriter;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ClientSessionIdentityMapAccessor;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ClientSession
extends AbstractSession {
    protected ServerSession parent;
    protected ConnectionPolicy connectionPolicy;
    protected Accessor writeConnection;
    protected boolean isActive;
    protected Sequencing sequencing;

    public ClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        this(parent, connectionPolicy, null);
    }

    public ClientSession(ServerSession parent, ConnectionPolicy connectionPolicy, Map properties) {
        this.project = parent.getProject();
        if (connectionPolicy.isUserDefinedConnection()) {
            this.setProject((Project)this.getProject().clone());
            this.setLogin(connectionPolicy.getLogin());
        }
        this.isLoggingOff = parent.isLoggingOff();
        this.isActive = true;
        this.externalTransactionController = parent.getExternalTransactionController();
        this.parent = parent;
        this.connectionPolicy = connectionPolicy;
        this.writeConnection = this.accessor;
        this.accessor = parent.getAccessor();
        this.name = parent.getName();
        this.profiler = parent.getProfiler();
        this.isInProfile = parent.isInProfile();
        this.commitManager = parent.getCommitManager();
        this.sessionLog = parent.getSessionLog();
        if (parent.hasEventManager()) {
            this.eventManager = parent.getEventManager().clone(this);
        }
        this.exceptionHandler = parent.getExceptionHandler();
        this.pessimisticLockTimeoutDefault = parent.getPessimisticLockTimeoutDefault();
        this.queryTimeoutDefault = parent.getQueryTimeoutDefault();
        this.properties = properties;
        if (this.eventManager != null) {
            this.eventManager.postAcquireClientSession();
        }
        this.descriptors = parent.getDescriptors();
        this.incrementProfile("Counter:ClientSessionCreates");
    }

    protected ClientSession(Project project) {
        super(project);
    }

    public void releaseJTSConnection() {
        if (this.hasWriteConnection()) {
            this.getWriteConnection().closeJTSConnection();
            this.releaseWriteConnection();
        }
    }

    public void basicBeginTransaction() {
        if (this.getWriteConnection() == null && this.getConnectionPolicy().isLazy()) {
            this.parent.acquireClientConnection(this);
        }
        try {
            super.basicBeginTransaction();
        }
        catch (RuntimeException ex) {
            if (this.getWriteConnection() != null && !this.getWriteConnection().isInTransaction() && this.getConnectionPolicy().isLazy()) {
                this.parent.releaseClientSession(this);
            }
            throw ex;
        }
    }

    public void basicCommitTransaction() {
        super.basicCommitTransaction();
        if (this.hasExternalTransactionController()) {
            if (!this.isSynchronized()) {
                this.releaseJTSConnection();
            }
        } else {
            this.releaseWriteConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void basicRollbackTransaction() {
        try {
            if (this.hasWriteConnection()) {
                super.basicRollbackTransaction();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.hasExternalTransactionController()) {
                if (this.isSynchronized()) throw throwable;
                this.releaseJTSConnection();
                throw throwable;
            } else {
                this.releaseWriteConnection();
            }
            throw throwable;
        }
        if (this.hasExternalTransactionController()) {
            if (this.isSynchronized()) return;
            this.releaseJTSConnection();
            return;
        }
        this.releaseWriteConnection();
    }

    public void connect() throws DatabaseException {
        this.getWriteConnection().connect(this.getDatasourceLogin(), this);
    }

    public boolean containsQuery(String queryName) {
        boolean containsQuery = this.getQueries().containsKey(queryName);
        if (!containsQuery) {
            containsQuery = this.parent.containsQuery(queryName);
        }
        return containsQuery;
    }

    public void disconnect() throws DatabaseException {
        this.getWriteConnection().disconnect(this);
    }

    public Accessor getAccessor() {
        Accessor accessor = null;
        accessor = this.isInTransaction() ? this.getWriteConnection() : super.getAccessor();
        if (accessor == null) {
            throw DatabaseException.databaseAccessorConnectionIsNull(null, this);
        }
        return accessor;
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        return this.parent.getParentIdentityMapSession(query, canReturnSelf, terminalOnly);
    }

    public Object getProperty(String name) {
        Object propertyValue = super.getProperty(name);
        if (propertyValue == null) {
            propertyValue = this.parent.getProperty(name);
        }
        return propertyValue;
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        if (this.isInTransaction()) {
            return this;
        }
        return this.parent.getExecutionSession(query);
    }

    public ServerSession getParent() {
        return this.parent;
    }

    public DatabaseQuery getQuery(String name) {
        DatabaseQuery query = super.getQuery(name);
        if (query == null) {
            query = this.parent.getQuery(name);
        }
        return query;
    }

    public DatabaseQuery getQuery(String name, Vector args) {
        DatabaseQuery query = super.getQuery(name, args);
        if (query == null) {
            query = this.parent.getQuery(name, args);
        }
        return query;
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    public Sequencing getSequencing() {
        if (this.sequencing == null) {
            this.initializeSequencing();
        }
        return this.sequencing;
    }

    public ServerPlatform getServerPlatform() {
        return this.parent.getServerPlatform();
    }

    public String getSessionTypeString() {
        return "ClientSession";
    }

    public Accessor getWriteConnection() {
        return this.writeConnection;
    }

    protected boolean hasWriteConnection() {
        if (this.getWriteConnection() == null) {
            return false;
        }
        return this.getWriteConnection().isConnected();
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new ClientSessionIdentityMapAccessor(this);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isClientSession() {
        return true;
    }

    public boolean isConnected() {
        return this.parent.isConnected();
    }

    public void release() throws DatabaseException {
        if (!this.isActive()) {
            return;
        }
        if (this.eventManager != null) {
            this.eventManager.preReleaseClientSession();
        }
        if (this.getWriteConnection() != null) {
            this.parent.releaseClientSession(this);
        }
        this.setIsActive(false);
        this.log(2, "connection", "client_released");
        if (this.eventManager != null) {
            this.eventManager.postReleaseClientSession();
        }
    }

    protected void releaseWriteConnection() {
        if (this.getConnectionPolicy().isLazy() && this.getWriteConnection() != null) {
            this.parent.releaseClientSession(this);
        }
    }

    public void setConnectionPolicy(ConnectionPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
    }

    protected void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    protected void setParent(ServerSession parent) {
        this.parent = parent;
    }

    public void setWriteConnection(Accessor writeConnection) {
        if (writeConnection != null) {
            this.writeConnection = writeConnection;
            this.writeConnection.createCustomizer(this);
        } else if (this.writeConnection != null) {
            this.writeConnection.releaseCustomizer(this);
            this.writeConnection = null;
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(this.getSessionTypeString());
        writer.write("(");
        writer.write(String.valueOf(this.getWriteConnection()));
        writer.write(")");
        return writer.toString();
    }

    public CommandManager getCommandManager() {
        return this.parent.getCommandManager();
    }

    public boolean shouldPropagateChanges() {
        return this.parent.shouldPropagateChanges();
    }

    public void releaseReadConnection(Accessor connection) {
        if (this.getWriteConnection() == connection) {
            return;
        }
        this.parent.releaseReadConnection(connection);
    }

    public void postConnectExternalConnection(Accessor accessor) {
        if (this.eventManager != null) {
            this.eventManager.postAcquireConnection(accessor);
        }
    }

    public void preDisconnectExternalConnection(Accessor accessor) {
        if (this.eventManager != null) {
            this.eventManager.preReleaseConnection(accessor);
        }
    }

    public boolean isExclusiveConnectionRequired() {
        return !this.getConnectionPolicy().isLazy && this.isActive();
    }
}

