/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.adapter.store.commands.LoadResponseCommand;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ResponseMediator;

public class LoadRequestCommand<K, V>
extends Command<K, V> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.load_request");
    private K key;
    private transient CommandResponse resp;
    private transient Future future;
    private long tokenId;
    private String originatingInstance;
    private String target;

    public LoadRequestCommand() {
        super((byte)35);
    }

    public LoadRequestCommand(K key, String t) {
        this();
        this.key = key;
        this.target = t;
    }

    @Override
    protected boolean beforeTransmit() {
        this.setTargetName(this.target);
        this.originatingInstance = this.dsc.getInstanceName();
        ResponseMediator respMed = this.dsc.getResponseMediator();
        this.resp = respMed.createCommandResponse();
        this.future = this.resp.getFuture();
        return this.target != null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(this.resp.getTokenId());
        out.writeObject(this.key);
        out.writeUTF(this.originatingInstance);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getInstanceName() + this.getName() + " sending load_request command for " + this.key + "to " + this.target);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.tokenId = in.readLong();
        this.key = in.readObject();
        this.originatingInstance = in.readUTF();
    }

    @Override
    public void execute(String initiator) {
        try {
            DataStoreEntry e;
            Object v;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.dsc.getInstanceName() + this.getName() + " received load_request command for " + this.key + "from " + initiator);
            }
            Object v2 = v = (e = this.dsc.getReplicaStore().getEntry(this.key)) == null ? null : (Object)e.getV();
            if (!this.originatingInstance.equals(this.dsc.getInstanceName())) {
                LoadResponseCommand<K, Object> rsp = new LoadResponseCommand<K, Object>(this.key, v, this.tokenId);
                rsp.setOriginatingInstance(this.originatingInstance);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.dsc.getServiceName() + " executed load_request command for " + this.key + " from " + initiator + "; v = " + v);
                }
                this.getCommandManager().execute(rsp);
            } else {
                this.resp.setResult(v);
            }
        }
        catch (DataStoreException dsEx) {
            this.resp.setException(dsEx);
        }
    }

    public String getRespondingInstanceName() {
        return this.resp.getRespondingInstanceName();
    }

    public V getResult(long waitFor, TimeUnit unit) throws DataStoreException {
        try {
            Object result = this.future.get(waitFor, unit);
            if (result instanceof Exception) {
                throw new DataStoreException((Exception)result);
            }
            return result;
        }
        catch (DataStoreException dsEx) {
            throw dsEx;
        }
        catch (InterruptedException inEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand Interrupted while waiting for result", inEx);
            throw new DataStoreException(inEx);
        }
        catch (TimeoutException timeoutEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand timed out while waiting for result " + timeoutEx);
            return null;
        }
        catch (ExecutionException exeEx) {
            _logger.log(Level.WARNING, "LoadRequestCommand got an exception while waiting for result", exeEx);
            throw new DataStoreException(exeEx);
        }
    }

    public String toString() {
        return this.getName() + "(" + this.key + ")";
    }
}

