/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.adapter.store.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreEntry;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;

public class TouchCommand<K, V>
extends Command<K, V> {
    private K k;
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.touch");
    private long version;
    private long accessTime;
    private long maxIdleTime;
    private String replicaChoices;

    public TouchCommand() {
        super((byte)38);
    }

    public TouchCommand(K k, long version, long accessTime, long maxIdleTime) {
        this();
        this.setKey(k);
        this.version = version;
        this.accessTime = accessTime;
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public void setKey(K k) {
        this.k = k;
    }

    @Override
    protected boolean beforeTransmit() {
        this.replicaChoices = this.dsc.getKeyMapper().getReplicaChoices(this.dsc.getGroupName(), this.k);
        String[] choices = this.replicaChoices == null ? null : this.replicaChoices.split(":");
        super.setTargetName(this.replicaChoices == null ? null : choices[0]);
        return this.getTargetName() != null;
    }

    private void writeObject(ObjectOutputStream ros) throws IOException {
        ros.writeObject(this.k);
        ros.writeLong(this.version);
        ros.writeLong(this.accessTime);
        ros.writeLong(this.maxIdleTime);
    }

    private void readObject(ObjectInputStream ris) throws IOException, ClassNotFoundException {
        this.k = ris.readObject();
        this.version = ris.readLong();
        this.accessTime = ris.readLong();
        this.maxIdleTime = ris.readLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        DataStoreEntry entry;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.dsc.getInstanceName() + " received save " + this.k + " from " + initiator);
        }
        if ((entry = this.dsc.getReplicaStore().getEntry(this.k)) != null) {
            DataStoreEntry dataStoreEntry = entry;
            synchronized (dataStoreEntry) {
            }
        }
    }
}

