/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.api;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreConfigurator;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreEntryHelper;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.DefaultObjectInputOutputStreamFactory;
import org.shoal.ha.cache.api.ObjectKeyHelper;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.interceptor.ReplicationCommandTransmitterManager;
import org.shoal.ha.cache.impl.interceptor.ReplicationFramePayloadCommand;
import org.shoal.ha.cache.impl.store.ReplicaStore;
import org.shoal.ha.cache.impl.util.DefaultDataStoreEntryHelper;
import org.shoal.ha.cache.impl.util.ResponseMediator;
import org.shoal.ha.group.GroupMemberEventListener;
import org.shoal.ha.group.GroupService;
import org.shoal.ha.group.GroupServiceFactory;
import org.shoal.ha.mapper.DefaultKeyMapper;
import org.shoal.ha.mapper.KeyMapper;

public class ReplicationFramework<K, V extends Serializable> {
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.config");
    private String storeName;
    private String instanceName;
    private String groupName;
    private GroupService gs;
    private CommandManager<K, V> cm;
    private DataStoreEntryHelper<K, V> entryHelper;
    private DataStoreContext<K, V> dsc;
    private DataStoreConfigurator<K, V> conf;
    private ReplicaStore<K, V> replicaStore;

    public ReplicationFramework(DataStoreConfigurator<K, V> conf) {
        GroupService gs;
        this.conf = conf;
        this.storeName = conf.getStoreName();
        this.gs = gs = GroupServiceFactory.getInstance().getGroupService(conf.getInstanceName(), conf.getGroupName(), conf.isStartGMS());
        this.instanceName = gs.getMemberName();
        this.groupName = gs.getGroupName();
        if (conf.getKeyMapper() == null) {
            conf.setKeyMapper(new DefaultKeyMapper(conf.getInstanceName(), conf.getGroupName()));
        }
        if (conf.getKeyMapper() instanceof GroupMemberEventListener) {
            GroupMemberEventListener groupListener = (GroupMemberEventListener)((Object)conf.getKeyMapper());
            gs.registerGroupMemberEventListener(groupListener);
        }
        if (conf.getObjectInputOutputStreamFactory() == null) {
            conf.setObjectInputOutputStreamFactory(new DefaultObjectInputOutputStreamFactory());
        }
        if (conf.getDataStoreEntryHelper() == null) {
            conf.setDataStoreEntryHelper(new DefaultDataStoreEntryHelper(conf.getObjectInputOutputStreamFactory(), conf.getClassLoader(), 600000L));
        }
        if (conf.getDataStoreKeyHelper() == null) {
            conf.setDataStoreKeyHelper(new ObjectKeyHelper(conf.getClassLoader(), conf.getObjectInputOutputStreamFactory()));
        }
        this.initialize(conf, gs);
    }

    private void initialize(DataStoreConfigurator<K, V> conf, GroupService gs) {
        this.dsc = new DataStoreContext(this.storeName, gs, conf.getClassLoader());
        this.entryHelper = conf.getDataStoreEntryHelper();
        this.dsc.setDataStoreEntryHelper(this.entryHelper);
        this.dsc.setDataStoreKeyHelper(conf.getDataStoreKeyHelper());
        this.dsc.setKeyMapper(conf.getKeyMapper());
        this.cm = this.dsc.getCommandManager();
        if (conf.getCommands() != null) {
            for (Command<K, V> cmd : conf.getCommands()) {
                this.cm.registerCommand(cmd);
            }
        }
        this.dsc.setDoSyncReplication(conf.isDoSynchronousReplication());
        this.cm.registerExecutionInterceptor(new ReplicationCommandTransmitterManager());
        this.cm.registerCommand(new ReplicationFramePayloadCommand());
        KeyMapper keyMapper = conf.getKeyMapper();
        if (keyMapper != null && keyMapper instanceof DefaultKeyMapper) {
            gs.registerGroupMemberEventListener((DefaultKeyMapper)keyMapper);
        }
        gs.registerGroupMessageReceiver(this.storeName, this.cm);
        this.replicaStore = this.dsc.getReplicaStore();
        this.replicaStore.setIdleEntryDetector(conf.getIdleEntryDetector());
        _logger.log(Level.INFO, "ReplicationFramework initialized. Configuration: " + conf);
    }

    public void execute(Command<K, V> cmd) throws DataStoreException {
        this.cm.execute(cmd);
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public GroupService getGroupService() {
        return this.gs;
    }

    public CommandManager<K, V> getCommandManager() {
        return this.cm;
    }

    public DataStoreEntryHelper<K, V> getDataStoreEntryHelper() {
        return this.entryHelper;
    }

    public DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    public DataStoreConfigurator<K, V> getDataStoreConfigurator() {
        return this.conf;
    }

    public ReplicaStore<K, V> getReplicaStore() {
        return this.replicaStore;
    }

    public KeyMapper getKeyMapper() {
        return this.dsc.getKeyMapper();
    }

    public ResponseMediator getResponseMediator() {
        return this.dsc.getResponseMediator();
    }
}

