/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.ObjectInputStreamWithLoader;
import org.shoal.ha.cache.impl.command.Command;

public class ReplicationFramePayloadCommand<K, V>
extends Command<K, V> {
    private static final transient Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.frame");
    private String targetInstanceName;
    private transient List<Command<K, V>> commands = new ArrayList<Command<K, V>>();
    private transient List<byte[]> list = new ArrayList<byte[]>();

    public ReplicationFramePayloadCommand() {
        super((byte)1);
    }

    public void addComamnd(Command<K, V> cmd) {
        this.commands.add(cmd);
    }

    public void setTargetInstance(String target) {
        this.targetInstanceName = target;
    }

    @Override
    protected boolean beforeTransmit() {
        this.setTargetName(this.targetInstanceName);
        for (int i = 0; i < this.commands.size(); ++i) {
            this.list.add(this.commands.get(i).getSerializedState());
        }
        return this.targetInstanceName != null;
    }

    private void writeObject(ObjectOutputStream ros) throws IOException {
        ros.writeObject(this.list);
    }

    private void readObject(ObjectInputStream ris) throws IOException, ClassNotFoundException {
        this.list = (List)ris.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String initiator) throws DataStoreException {
        int sz = this.list.size();
        this.commands = new ArrayList<Command<K, V>>();
        for (int i = 0; i < sz; ++i) {
            ByteArrayInputStream bis = null;
            ObjectInputStream ois = null;
            try {
                bis = new ByteArrayInputStream(this.list.get(i));
                ois = new ObjectInputStreamWithLoader(bis, this.dsc.getClassLoader());
                Command cmd = (Command)ois.readObject();
                this.commands.add(cmd);
                cmd.initialize(this.dsc);
                continue;
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "Error during execute ", ex);
                continue;
            }
            finally {
                try {
                    ois.close();
                }
                catch (Exception ex) {}
                try {
                    bis.close();
                }
                catch (Exception ex) {}
            }
        }
        for (Command<K, V> cmd : this.commands) {
            this.getCommandManager().executeCommand(cmd, false, initiator);
        }
    }

    @Override
    public void onSuccess() {
        int sz = this.commands.size();
        for (int i = 0; i < sz; ++i) {
            Command<K, V> cmd = this.commands.get(i);
            cmd.onSuccess();
        }
    }

    @Override
    public void onFailure() {
        int sz = this.commands.size();
        for (int i = 0; i < sz; ++i) {
            Command<K, V> cmd = this.commands.get(i);
            cmd.onFailure();
        }
    }

    public String toString() {
        return "ReplicationFramePayloadCommand: contains " + this.list.size() + " commands";
    }
}

