/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.resources.TemplateExecCommand;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
public class SystemPropertiesCliResource
extends TemplateExecCommand {
    protected static final String TAG_SYSTEM_PROPERTY = "system-property";
    @Context
    protected ResourceContext resourceContext;
    @Context
    protected Habitat habitat;
    protected Dom entity;

    public SystemPropertiesCliResource() {
        super(SystemPropertiesCliResource.class.getSimpleName(), "", "", "", "", true);
    }

    public void setEntity(Dom p) {
        this.entity = p;
    }

    public Dom getEntity() {
        return this.entity;
    }

    @GET
    public ActionReportResult get() {
        Dom server = this.getEntity();
        ParameterMap data = new ParameterMap();
        this.processCommandParams(data);
        this.addQueryString((MultivaluedMap<String, String>)((ContainerRequest)this.requestHeaders).getQueryParameters(), data);
        this.adjustParameters(data);
        ArrayList properties = new ArrayList();
        RestActionReporter actionReport = new RestActionReporter();
        for (Dom child : server.nodeElements(TAG_SYSTEM_PROPERTY)) {
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("name", child.getKey());
            property.put("value", child.attribute("value"));
            properties.add(property);
        }
        actionReport.getExtraProperties().put("systemProperties", properties);
        if (properties.isEmpty()) {
            actionReport.getTopMessagePart().setMessage("Nothing to list.");
        }
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
        return results;
    }

    @POST
    public Response create(HashMap<String, String> data) {
        try {
            this.deleteExistingProperties();
            return this.saveProperties(data);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult(400, ex.getMessage(), this.requestHeaders, this.uriInfo)).build();
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    public Response update(HashMap<String, String> data) {
        return this.create(data);
    }

    @Path(value="{Name}/")
    @POST
    public Response getSystemPropertyResource(@PathParam(value="Name") String id, HashMap<String, String> data) {
        data.put(id, data.get("value"));
        data.remove("value");
        List segments = this.uriInfo.getPathSegments(true);
        String grandParent = ((PathSegment)segments.get(segments.size() - 3)).getPath();
        return this.saveProperties(grandParent, data);
    }

    protected String convertPropertyMapToString(HashMap<String, String> data) {
        StringBuilder options = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            options.append(sep).append(entry.getKey()).append("=").append(value.replaceAll(":", "\\\\:"));
            sep = ":";
        }
        return options.toString();
    }

    protected Response saveProperties(HashMap<String, String> data) {
        return this.saveProperties(null, data);
    }

    protected Response saveProperties(String parent, HashMap<String, String> data) {
        String propertiesString = this.convertPropertyMapToString(data);
        data = new HashMap();
        data.put("DEFAULT", propertiesString);
        data.put("target", parent == null ? this.getParent(this.uriInfo) : parent);
        RestActionReporter actionReport = ResourceUtil.runCommand("create-system-properties", data, this.habitat, "");
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
        int status = 200;
        if (exitCode == ActionReport.ExitCode.FAILURE) {
            status = 500;
        }
        results.setStatusCode(status);
        return Response.status((int)status).entity((Object)results).build();
    }

    protected void deleteExistingProperties() throws TransactionFailure {
        Dom parent = this.getEntity();
        for (Dom existingProp : parent.nodeElements(TAG_SYSTEM_PROPERTY)) {
            ConfigSupport.deleteChild((ConfigBean)parent, (ConfigBean)existingProp);
        }
    }
}

