/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="setup-ssh")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public final class SetupSshKey
extends CLICommand {
    @Param(optional=true, defaultValue="${user.name}")
    private String sshuser;
    @Param(optional=true, defaultValue="22")
    private int sshport;
    @Param(optional=true)
    private String sshkeyfile;
    @Param(optional=true)
    private String sshpublickeyfile;
    @Param(optional=true, defaultValue="false")
    private boolean generatekey;
    @Param(name="hosts", optional=false, primary=true, multiple=true)
    private String[] nodes;
    @Inject
    private Habitat habitat;
    private String sshpassword;
    private String sshkeypassphrase = null;
    private boolean promptPass = false;
    private TokenResolver resolver = null;

    public SetupSshKey() {
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
    }

    protected void validate() throws CommandException {
        this.sshuser = this.resolver.resolve(this.sshuser);
        if (this.sshkeyfile == null) {
            String existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.sshkeyfile = SSHUtil.getDefaultKeyFile();
                if (this.promptForKeyGeneration()) {
                    this.generatekey = true;
                }
            } else {
                this.promptPass = true;
                this.sshkeyfile = existingKey;
                if (this.isEncryptedKey()) {
                    this.sshkeypassphrase = this.getSSHPassphrase();
                }
            }
        } else {
            this.validateKeyFile(this.sshkeyfile);
            if (this.isEncryptedKey()) {
                this.sshkeypassphrase = this.getSSHPassphrase();
            }
        }
        if (this.sshpublickeyfile != null) {
            this.validateKeyFile(this.sshpublickeyfile);
        }
    }

    protected int executeCommand() throws CommandException {
        SSHLauncher sshL = (SSHLauncher)this.habitat.getComponent(SSHLauncher.class);
        Globals.setDefaultHabitat(this.habitat);
        String previousPassword = null;
        boolean status = false;
        for (String node : this.nodes) {
            boolean res;
            block13: {
                sshL.init(this.sshuser, node, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
                if (this.generatekey || this.promptPass) {
                    if (this.sshkeyfile != null || SSHUtil.getExistingKeyFile() != null) {
                        try {
                            if (sshL.checkConnection()) {
                                logger.info(Strings.get("SSHAlreadySetup", this.sshuser, node));
                                continue;
                            }
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    if (previousPassword != null) {
                        status = sshL.checkPasswordAuth();
                    }
                    if (!status) {
                        previousPassword = this.sshpassword = this.getSSHPassword(node);
                    }
                }
                try {
                    sshL.setupKey(node, this.sshpublickeyfile, this.generatekey, this.sshpassword);
                }
                catch (IOException ce) {
                    throw new CommandException(Strings.get("KeySetupFailed", ce.getMessage()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                res = false;
                try {
                    res = sshL.checkConnection();
                }
                catch (IOException ioe) {
                    if (!logger.isLoggable(Level.FINER)) break block13;
                    ioe.printStackTrace();
                }
            }
            if (res) continue;
            throw new CommandException(Strings.get("ConnFailed"));
        }
        return 0;
    }

    private void validateKeyFile(String file) throws CommandException {
        File f = new File(file);
        if (!f.exists()) {
            throw new CommandException(Strings.get("KeyDoesNotExist", file));
        }
        this.promptPass = true;
    }

    private String getSSHPassword(String node) throws CommandException {
        String password = this.getFromPasswordFile("AS_ADMIN_SSH_PASSWORD");
        if (password == null) {
            if (this.programOpts.isInteractive()) {
                password = this.readSSHPassword(Strings.get("SSHPasswordPrompt", this.sshuser, node));
            } else {
                throw new CommandException(Strings.get("SSHPasswordNotFound"));
            }
        }
        return password;
    }

    private String getSSHPassphrase() throws CommandException {
        String passphrase = this.getFromPasswordFile("AS_ADMIN_SSH_KEYPASSPHRASE");
        if (passphrase == null) {
            passphrase = this.programOpts.isInteractive() ? this.readSSHPassword(Strings.get("SSHPassphrasePrompt", this.sshkeyfile)) : "";
        }
        return passphrase;
    }

    private String getFromPasswordFile(String name) {
        return (String)this.passwords.get(name);
    }

    private boolean promptForKeyGeneration() {
        if (this.generatekey) {
            return true;
        }
        if (!this.programOpts.isInteractive()) {
            return false;
        }
        Console cons = System.console();
        if (cons != null) {
            String val = null;
            do {
                cons.printf("%s", Strings.get("GenerateKeyPairPrompt", this.sshuser, Arrays.toString(this.nodes)));
                val = cons.readLine();
                if (val == null || !val.equalsIgnoreCase("yes") && !val.equalsIgnoreCase("y")) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Generate key!");
                }
                return true;
            } while ((val == null || !val.equalsIgnoreCase("no") && !val.equalsIgnoreCase("n")) && val != null && !this.isValidAnswer(val));
        }
        return false;
    }

    private boolean isValidAnswer(String val) {
        return val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("n");
    }

    protected String readSSHPassword(String prompt) {
        String password = null;
        Console cons = System.console();
        if (cons != null) {
            char[] pc = cons.readPassword("%s", prompt);
            password = new String(pc);
        }
        return password;
    }

    private boolean isEncryptedKey() throws CommandException {
        boolean res = false;
        try {
            res = SSHUtil.isEncryptedKey((String)this.sshkeyfile);
        }
        catch (IOException ioe) {
            throw new CommandException(Strings.get("ErrorParsingKey", this.sshkeyfile, ioe.getMessage()));
        }
        return res;
    }
}

