/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.threadpool;

import com.sun.corba.ee.impl.orbutil.threadpool.Exceptions;
import com.sun.corba.ee.impl.orbutil.threadpool.WorkQueueImpl;
import com.sun.corba.ee.impl.orbutil.threadpool.WorkerThreadNotNeededException;
import com.sun.corba.ee.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.orbutil.threadpool.WorkQueue;
import java.io.Closeable;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.NameValue;

@ManagedObject
@Description(value="A ThreadPool used by the ORB")
public class ThreadPoolImpl
implements ThreadPool {
    public static final int DEFAULT_INACTIVITY_TIMEOUT = 120000;
    private static final AtomicInteger threadCounter = new AtomicInteger(0);
    private final WorkQueue workQueue;
    private int availableWorkerThreads = 0;
    private int currentThreadCount = 0;
    private final int minWorkerThreads;
    private final int maxWorkerThreads;
    private final long inactivityTimeout;
    private AtomicLong processedCount = new AtomicLong(1L);
    private AtomicLong totalTimeTaken = new AtomicLong(0L);
    private final String name;
    private ThreadGroup threadGroup;
    private final ClassLoader workerThreadClassLoader;
    final Object workersLock = new Object();
    List<WorkerThread> workers = new ArrayList<WorkerThread>();

    public ThreadPoolImpl(String threadpoolName) {
        this(Thread.currentThread().getThreadGroup(), threadpoolName);
    }

    public ThreadPoolImpl(ThreadGroup tg, String threadpoolName) {
        this(tg, threadpoolName, ThreadPoolImpl.getDefaultClassLoader());
    }

    public ThreadPoolImpl(ThreadGroup tg, String threadpoolName, ClassLoader defaultClassLoader) {
        this.inactivityTimeout = 120000L;
        this.minWorkerThreads = 0;
        this.maxWorkerThreads = Integer.MAX_VALUE;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = tg;
        this.name = threadpoolName;
        this.workerThreadClassLoader = defaultClassLoader;
    }

    public ThreadPoolImpl(int minSize, int maxSize, long timeout, String threadpoolName) {
        this(minSize, maxSize, timeout, threadpoolName, ThreadPoolImpl.getDefaultClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPoolImpl(int minSize, int maxSize, long timeout, String threadpoolName, ClassLoader defaultClassLoader) {
        this.inactivityTimeout = timeout;
        this.minWorkerThreads = minSize;
        this.maxWorkerThreads = maxSize;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = Thread.currentThread().getThreadGroup();
        this.name = threadpoolName;
        this.workerThreadClassLoader = defaultClassLoader;
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            for (int i = 0; i < this.minWorkerThreads; ++i) {
                this.createWorkerThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList<WorkerThread> copy = null;
        Object object = this.workersLock;
        synchronized (object) {
            copy = new ArrayList<WorkerThread>(this.workers);
        }
        for (WorkerThread wt : copy) {
            wt.close();
            while (wt.getState() != Thread.State.TERMINATED) {
                try {
                    wt.join();
                }
                catch (InterruptedException exc) {
                    Exceptions.self.interruptedJoinCallWhileClosingThreadPool(exc, wt, this);
                }
            }
        }
        this.threadGroup = null;
    }

    private static ClassLoader getDefaultClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return cl;
    }

    @Override
    public WorkQueue getAnyWorkQueue() {
        return this.workQueue;
    }

    @Override
    public WorkQueue getWorkQueue(int queueId) throws NoSuchWorkQueueException {
        if (queueId != 0) {
            throw new NoSuchWorkQueueException();
        }
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread createWorkerThreadHelper(String name) {
        WorkerThread thread = new WorkerThread(this.threadGroup, name);
        Object object = this.workersLock;
        synchronized (object) {
            this.workers.add(thread);
        }
        thread.setDaemon(true);
        Exceptions.self.workerThreadCreated(thread, thread.getContextClassLoader());
        thread.start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWorkerThread() {
        final String lname = this.getName();
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            try {
                if (System.getSecurityManager() == null) {
                    this.createWorkerThreadHelper(lname);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return ThreadPoolImpl.this.createWorkerThreadHelper(lname);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.decrementCurrentNumberOfThreads();
                Exceptions.self.workerThreadCreationFailure(t);
            }
            finally {
                this.incrementCurrentNumberOfThreads();
            }
        }
    }

    @Override
    public int minimumNumberOfThreads() {
        return this.minWorkerThreads;
    }

    @Override
    public int maximumNumberOfThreads() {
        return this.maxWorkerThreads;
    }

    @Override
    public long idleTimeoutForThreads() {
        return this.inactivityTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedAttribute
    @Description(value="The current number of threads")
    public int currentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementCurrentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            --this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementCurrentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            ++this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedAttribute
    @Description(value="The number of available threads in this ThreadPool")
    public int numberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManagedAttribute
    @Description(value="The number of threads busy processing work in this ThreadPool")
    public int numberOfBusyThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.currentNumberOfThreads() - this.numberOfAvailableThreads();
        }
    }

    @Override
    @ManagedAttribute
    @Description(value="The average time needed to complete a work item")
    public long averageWorkCompletionTime() {
        return this.totalTimeTaken.get() / this.processedCount.get();
    }

    @Override
    @ManagedAttribute
    @Description(value="The number of work items processed")
    public long currentProcessedCount() {
        return this.processedCount.get();
    }

    @Override
    @NameValue
    public String getName() {
        return this.name;
    }

    @Override
    public int numberOfWorkQueues() {
        return 1;
    }

    private static int getUniqueThreadId() {
        return threadCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementNumberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            --this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementNumberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            ++this.availableWorkerThreads;
        }
    }

    private class WorkerThread
    extends Thread
    implements Closeable {
        private static final String THREAD_POOLNAME_PREFIX_STR = "p: ";
        private static final String WORKER_THREAD_NAME_PREFIX_STR = "; w: ";
        private static final String IDLE_STR = "Idle";
        private Work currentWork;
        private volatile boolean closeCalled;

        WorkerThread(ThreadGroup tg, String threadPoolName) {
            super(tg, THREAD_POOLNAME_PREFIX_STR + threadPoolName + WORKER_THREAD_NAME_PREFIX_STR + ThreadPoolImpl.getUniqueThreadId());
            this.closeCalled = false;
            this.currentWork = null;
        }

        private void setClassLoader() {
            if (System.getSecurityManager() == null) {
                this.setClassLoaderHelper();
            } else {
                AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return WorkerThread.this.setClassLoaderHelper();
                    }
                });
            }
        }

        private ClassLoader setClassLoaderHelper() {
            Thread thr = Thread.currentThread();
            ClassLoader result = thr.getContextClassLoader();
            thr.setContextClassLoader(ThreadPoolImpl.this.workerThreadClassLoader);
            return result;
        }

        @Override
        public synchronized void close() {
            this.closeCalled = true;
            this.interrupt();
        }

        private void resetClassLoader() {
            ClassLoader currentClassLoader = null;
            try {
                currentClassLoader = System.getSecurityManager() == null ? this.getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return WorkerThread.this.getContextClassLoader();
                    }
                });
            }
            catch (SecurityException se) {
                throw Exceptions.self.workerThreadGetContextClassloaderFailed(se, this);
            }
            if (ThreadPoolImpl.this.workerThreadClassLoader != currentClassLoader) {
                Exceptions.self.workerThreadForgotClassloaderReset(this, currentClassLoader, ThreadPoolImpl.this.workerThreadClassLoader);
                try {
                    this.setClassLoader();
                }
                catch (SecurityException se) {
                    Exceptions.self.workerThreadResetContextClassloaderFailed(se, this);
                }
            }
        }

        private void performWork() {
            long start = System.currentTimeMillis();
            try {
                this.currentWork.doWork();
            }
            catch (Throwable t) {
                Exceptions.self.workerThreadDoWorkThrowable(t, this);
            }
            long elapsedTime = System.currentTimeMillis() - start;
            ThreadPoolImpl.this.totalTimeTaken.addAndGet(elapsedTime);
            ThreadPoolImpl.this.processedCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.setClassLoader();
                while (!this.closeCalled) {
                    block20: {
                        try {
                            this.currentWork = ((WorkQueueImpl)ThreadPoolImpl.this.workQueue).requestWork(ThreadPoolImpl.this.inactivityTimeout);
                            if (this.currentWork == null) {
                            }
                            break block20;
                        }
                        catch (WorkerThreadNotNeededException toe) {
                            Exceptions.self.workerThreadNotNeeded(this, ThreadPoolImpl.this.currentNumberOfThreads(), ThreadPoolImpl.this.minimumNumberOfThreads());
                            this.closeCalled = true;
                        }
                        catch (InterruptedException exc) {
                            Thread.interrupted();
                            Exceptions.self.workQueueThreadInterrupted(exc, super.getName(), this.closeCalled);
                        }
                        catch (Throwable t) {
                            Exceptions.self.workerThreadThrowableFromRequestWork(t, this, ThreadPoolImpl.this.workQueue.getName());
                        }
                        continue;
                    }
                    this.performWork();
                    this.currentWork = null;
                    this.resetClassLoader();
                }
            }
            catch (Throwable e) {
                Exceptions.self.workerThreadCaughtUnexpectedThrowable(e, this);
            }
            finally {
                Object t = ThreadPoolImpl.this.workersLock;
                synchronized (t) {
                    ThreadPoolImpl.this.workers.remove(this);
                }
            }
        }
    }
}

