/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.orbutil.logex;

import com.sun.corba.ee.spi.orbutil.logex.Chain;
import com.sun.corba.ee.spi.orbutil.logex.ExceptionWrapper;
import com.sun.corba.ee.spi.orbutil.logex.Log;
import com.sun.corba.ee.spi.orbutil.logex.Message;
import com.sun.corba.ee.spi.orbutil.misc.OperationTracer;
import com.sun.corba.ee.spi.orbutil.proxy.CompositeInvocationHandlerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class WrapperGenerator {
    private static final Extension stdExtension = new ExtensionBase(){};
    private static final ShortFormatter formatter = new ShortFormatter();

    private WrapperGenerator() {
    }

    private static int findAnnotatedParameter(Annotation[][] pannos, Class<? extends Annotation> cls) {
        for (int ctr1 = 0; ctr1 < pannos.length; ++ctr1) {
            Annotation[] annos = pannos[ctr1];
            for (int ctr2 = 0; ctr2 < annos.length; ++ctr2) {
                Annotation anno = annos[ctr2];
                if (!cls.isInstance(anno)) continue;
                return ctr1;
            }
        }
        return -1;
    }

    private static Object[] getWithSkip(Object[] args, int skip) {
        if (skip >= 0) {
            Object[] result = new Object[args.length - 1];
            int rindex = 0;
            for (int ctr = 0; ctr < args.length; ++ctr) {
                if (ctr == skip) continue;
                result[rindex++] = args[ctr];
            }
            return result;
        }
        return args;
    }

    public static String getStandardLogId(Method method) {
        Log log = method.getAnnotation(Log.class);
        if (log == null) {
            throw new RuntimeException("No Log annotation present for " + method);
        }
        return String.format("%05d", log.id());
    }

    private static Map<String, String> getMessageMap(Class<?> cls, Extension extension) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        ExceptionWrapper ew = cls.getAnnotation(ExceptionWrapper.class);
        String idPrefix = ew.idPrefix();
        for (Method method : cls.getDeclaredMethods()) {
            String msgId = extension.getLogId(method);
            String msg = WrapperGenerator.getMessage(method, idPrefix, msgId);
            result.put(idPrefix + msgId, msg);
        }
        return result;
    }

    private static String getMessage(Method method, String idPrefix, String logId) {
        Message message = method.getAnnotation(Message.class);
        StringBuilder sb = new StringBuilder();
        sb.append(idPrefix);
        sb.append(logId);
        sb.append(": ");
        if (message == null) {
            sb.append(method.getName());
            sb.append(' ');
            for (int ctr = 0; ctr < method.getParameterTypes().length; ++ctr) {
                if (ctr > 0) {
                    sb.append(", ");
                }
                sb.append("arg");
                sb.append(ctr);
                sb.append("={").append(ctr).append("}");
            }
        } else {
            sb.append(message.value());
        }
        return sb.toString();
    }

    private static void inferCaller(LogRecord lrec) {
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        StackTraceElement frame = null;
        String wcname = "$Proxy";
        String baseName = WrapperGenerator.class.getName();
        String nestedName = WrapperGenerator.class.getName() + "$1";
        for (ix = 0; ix < stack.length && ((cname = (frame = stack[ix]).getClassName()).contains(wcname) || cname.equals(baseName) || cname.equals(nestedName)); ++ix) {
        }
        if (ix < stack.length) {
            lrec.setSourceClassName(frame.getClassName());
            lrec.setSourceMethodName(frame.getMethodName());
        }
    }

    public static Throwable makeStandardException(String msg, Method method) {
        Throwable result;
        Class<?> rtype = method.getReturnType();
        try {
            Constructor<?> cons = rtype.getConstructor(String.class);
            result = (Throwable)cons.newInstance(msg);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public static String getStandardLoggerName(Class<?> cls) {
        ExceptionWrapper ew = cls.getAnnotation(ExceptionWrapper.class);
        String str = ew.loggerName();
        if (str.length() == 0) {
            str = cls.getPackage().getName();
        }
        return str;
    }

    private static String handleMessageOnly(Method method, Extension extension, Logger logger, Object[] messageParams) {
        String transMsg;
        String msg = method.getAnnotation(Message.class).value();
        ResourceBundle catalog = logger.getResourceBundle();
        if (catalog == null) {
            transMsg = msg;
        } else {
            String logId = extension.getLogId(method);
            transMsg = catalog.getString(logId);
        }
        String result = transMsg.indexOf("{0") >= 0 ? MessageFormat.format(transMsg, messageParams) : transMsg;
        return result;
    }

    private static ReturnType classifyReturnType(Method method) {
        Class<?> rtype = method.getReturnType();
        if (Throwable.class.isAssignableFrom(rtype)) {
            return ReturnType.EXCEPTION;
        }
        if (rtype.equals(String.class)) {
            return ReturnType.STRING;
        }
        if (rtype.equals(Void.TYPE)) {
            return ReturnType.NULL;
        }
        throw new RuntimeException("Method " + method + " has an illegal return type");
    }

    private static LogRecord makeLogRecord(Level level, String key, Object[] args, Logger logger) {
        LogRecord result = new LogRecord(level, key);
        if (args != null && args.length > 0) {
            result.setParameters(args);
        }
        result.setLoggerName(logger.getName());
        result.setResourceBundle(logger.getResourceBundle());
        if (level != Level.INFO) {
            WrapperGenerator.inferCaller(result);
        }
        return result;
    }

    private static Object handleFullLogging(Log log, Method method, Logger logger, String idPrefix, Object[] messageParams, Throwable cause, Extension extension) {
        Level level = log.level().getLevel();
        ReturnType rtype = WrapperGenerator.classifyReturnType(method);
        String msgString = WrapperGenerator.getMessage(method, idPrefix, extension.getLogId(method));
        LogRecord lrec = WrapperGenerator.makeLogRecord(level, msgString, messageParams, logger);
        String message = formatter.format(lrec);
        Throwable exc = null;
        if (rtype == ReturnType.EXCEPTION && (exc = extension.makeException(message, method)) != null) {
            if (cause != null) {
                exc.initCause(cause);
            }
            if (level != Level.INFO) {
                lrec.setThrown(exc);
            }
        }
        if (logger.isLoggable(level)) {
            String context = OperationTracer.getAsString();
            String newMsg = msgString;
            if (context.length() > 0) {
                newMsg = newMsg + "\nCONTEXT:" + context;
                lrec.setMessage(newMsg);
            }
            logger.log(lrec);
        }
        switch (rtype) {
            case EXCEPTION: {
                return exc;
            }
            case STRING: {
                return message;
            }
        }
        return null;
    }

    public static <T> T makeWrapper(Class<T> cls) {
        return WrapperGenerator.makeWrapper(cls, stdExtension);
    }

    public static <T> T makeWrapper(final Class<T> cls, final Extension extension) {
        try {
            if (!cls.isInterface()) {
                throw new IllegalArgumentException("Class " + cls + "is not an interface");
            }
            ExceptionWrapper ew = cls.getAnnotation(ExceptionWrapper.class);
            final String idPrefix = ew.idPrefix();
            String name = extension.getLoggerName(cls);
            Logger lg = null;
            try {
                lg = Logger.getLogger(name, name);
            }
            catch (MissingResourceException exc) {
                lg = Logger.getLogger(name);
            }
            final Logger logger = lg;
            InvocationHandler inh = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Annotation[][] pannos = method.getParameterAnnotations();
                    int chainIndex = WrapperGenerator.findAnnotatedParameter(pannos, Chain.class);
                    Throwable cause = null;
                    Object[] messageParams = WrapperGenerator.getWithSkip(args, chainIndex);
                    if (chainIndex >= 0) {
                        cause = (Throwable)args[chainIndex];
                    }
                    Class<?> rtype = method.getReturnType();
                    Log log = method.getAnnotation(Log.class);
                    if (log == null) {
                        if (!rtype.equals(String.class)) {
                            throw new IllegalArgumentException("No @Log annotation present on " + cls.getName() + "." + method.getName());
                        }
                        return WrapperGenerator.handleMessageOnly(method, extension, logger, messageParams);
                    }
                    return WrapperGenerator.handleFullLogging(log, method, logger, idPrefix, messageParams, cause, extension);
                }
            };
            InvocationHandler inhmi = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("getMessageInfo")) {
                        return WrapperGenerator.getMessageMap(cls, extension);
                    }
                    throw new RuntimeException("Unexpected method " + method);
                }
            };
            CompositeInvocationHandlerImpl cih = new CompositeInvocationHandlerImpl(){

                public String toString() {
                    return "ExceptionWrapper[" + cls.getName() + "]";
                }
            };
            cih.addInvocationHandler(cls, inh);
            cih.addInvocationHandler(MessageInfo.class, inhmi);
            ClassLoader loader = cls.getClassLoader();
            Class[] classes = new Class[]{cls, MessageInfo.class};
            return (T)Proxy.newProxyInstance(loader, classes, (InvocationHandler)cih);
        }
        catch (Throwable thr) {
            Logger.getLogger(WrapperGenerator.class.getName()).log(Level.SEVERE, "Error in makeWrapper for " + cls, thr);
            return null;
        }
    }

    static class ShortFormatter
    extends Formatter {
        ShortFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
            String message = this.formatMessage(record);
            sb.append(message);
            return sb.toString();
        }
    }

    private static enum ReturnType {
        EXCEPTION,
        STRING,
        NULL;

    }

    public static abstract class ExtensionBase
    implements Extension {
        @Override
        public String getLogId(Method method) {
            return WrapperGenerator.getStandardLogId(method);
        }

        @Override
        public Throwable makeException(String msg, Method method) {
            return WrapperGenerator.makeStandardException(msg, method);
        }

        @Override
        public String getLoggerName(Class<?> cls) {
            return WrapperGenerator.getStandardLoggerName(cls);
        }
    }

    public static interface Extension {
        public String getLogId(Method var1);

        public Throwable makeException(String var1, Method var2);

        public String getLoggerName(Class<?> var1);
    }

    public static interface MessageInfo {
        public Map<String, String> getMessageInfo();
    }
}

