/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.tools.Diagnostic;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.ElementVisitor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataMirrorFactory
extends MetadataFactory {
    private ElementVisitor<MetadataClass, MetadataClass> elementVisitor;
    private Map<String, PersistenceUnit> persistenceUnits;
    private Map<String, MetadataProject> metadataProjects;
    private Map<MetadataClass, Boolean> roundElements = new HashMap<MetadataClass, Boolean>();
    private Map<Element, MetadataClass> roundMetadataClasses;
    private ProcessingEnvironment processingEnv;
    private RoundEnvironment roundEnv;

    protected MetadataMirrorFactory(MetadataLogger logger, ClassLoader loader) {
        super(logger, loader);
        this.persistenceUnits = new HashMap<String, PersistenceUnit>();
        this.metadataProjects = new HashMap<String, MetadataProject>();
        this.roundMetadataClasses = new HashMap<Element, MetadataClass>();
    }

    public void addPersistenceUnit(SEPersistenceUnitInfo puInfo, PersistenceUnit persistenceUnit) {
        this.persistenceUnits.put(puInfo.getPersistenceUnitName(), persistenceUnit);
    }

    public MetadataClass getMetadataClass(Element element) {
        if (this.roundMetadataClasses.containsKey(element)) {
            return this.roundMetadataClasses.get(element);
        }
        MetadataClass metadataClass = this.getMetadataClass(((TypeElement)element).getQualifiedName().toString());
        if (this.isRoundElement(element) || metadataClass == null) {
            metadataClass = new MetadataClass((MetadataFactory)this, "");
            this.roundMetadataClasses.put(element, metadataClass);
            element.accept(this.elementVisitor, metadataClass);
            this.addMetadataClass(metadataClass);
        }
        return metadataClass;
    }

    public MetadataClass getMetadataClass(String className) {
        if (className == null) {
            return null;
        }
        if (!this.metadataClassExists(className)) {
            this.addMetadataClass(new MetadataClass((MetadataFactory)this, className));
        }
        return (MetadataClass)this.getMetadataClasses().get(className);
    }

    public MetadataClass getMetadataClass(TypeMirror typeMirror) {
        Element element = this.processingEnv.getTypeUtils().asElement(typeMirror);
        if (element == null) {
            return this.getMetadataClass(((Object)typeMirror).toString());
        }
        return this.getMetadataClass(element);
    }

    public MetadataProject getMetadataProject(SEPersistenceUnitInfo puInfo) {
        if (!this.metadataProjects.containsKey(puInfo.getPersistenceUnitName())) {
            MetadataProject project = new MetadataProject((PersistenceUnitInfo)puInfo, (AbstractSession)new ServerSession(new Project(new DatabaseLogin())), false, false);
            this.metadataProjects.put(puInfo.getPersistenceUnitName(), project);
            return project;
        }
        return this.metadataProjects.get(puInfo.getPersistenceUnitName());
    }

    public Collection<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnits.values();
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    public boolean isPreProcessedRoundElement(MetadataClass cls) {
        return this.isRoundElement(cls) && this.roundElements.get(cls) != false;
    }

    public boolean isRoundElement(Element element) {
        return this.roundEnv.getRootElements().contains(element);
    }

    public boolean isRoundElement(MetadataClass cls) {
        return this.roundElements.containsKey(cls);
    }

    public void resolveGenericTypes(MetadataClass child, List<String> genericTypes, MetadataClass parent, MetadataDescriptor descriptor) {
    }

    public void setEnvironments(ProcessingEnvironment processingEnvironment, RoundEnvironment roundEnvironment) {
        this.processingEnv = processingEnvironment;
        this.roundEnv = roundEnvironment;
        this.roundElements.clear();
        this.roundMetadataClasses.clear();
        if (this.elementVisitor == null) {
            this.elementVisitor = new ElementVisitor(this.processingEnv);
        }
        for (Element element : roundEnvironment.getRootElements()) {
            if (element.getAnnotation(Generated.class) != null) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Building metadata class for round element: " + element);
            this.roundElements.put(this.getMetadataClass(element), false);
        }
    }

    public void setIsPreProcessedRoundElement(MetadataClass cls) {
        if (this.isRoundElement(cls)) {
            this.roundElements.put(cls, true);
        }
    }
}

