/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.visitors;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractElementVisitor6;
import javax.tools.Diagnostic;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.AnnotationValueVisitor;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.TypeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementVisitor<R, P>
extends AbstractElementVisitor6<MetadataAnnotatedElement, MetadataClass> {
    private ProcessingEnvironment processingEnv;
    private TypeVisitor<MetadataAnnotatedElement, MetadataAnnotatedElement> typeVisitor;

    public ElementVisitor(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.typeVisitor = new TypeVisitor();
    }

    protected void buildMetadataAnnotations(MetadataAnnotatedElement annotatedElement, List<? extends AnnotationMirror> annotationMirrors) {
        AnnotationValueVisitor visitor = new AnnotationValueVisitor();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            annotatedElement.addAnnotation((MetadataAnnotation)visitor.visitAnnotation(annotationMirror, (Object)null));
        }
    }

    protected int getModifiers(Set<Modifier> modifiers) {
        int mods = 0;
        for (Modifier modifier : modifiers) {
            if (modifier.equals((Object)Modifier.ABSTRACT)) {
                mods += 1024;
            }
            if (modifier.equals((Object)Modifier.FINAL)) {
                mods += 16;
            }
            if (modifier.equals((Object)Modifier.NATIVE)) {
                mods += 256;
            }
            if (modifier.equals((Object)Modifier.PRIVATE)) {
                mods += 2;
            }
            if (modifier.equals((Object)Modifier.PROTECTED)) {
                mods += 4;
            }
            if (modifier.equals((Object)Modifier.PUBLIC)) {
                ++mods;
            }
            if (modifier.equals((Object)Modifier.STATIC)) {
                mods += 8;
            }
            if (modifier.equals((Object)Modifier.STRICTFP)) {
                mods += 2048;
            }
            if (modifier.equals((Object)Modifier.SYNCHRONIZED)) {
                mods += 32;
            }
            if (modifier.equals((Object)Modifier.TRANSIENT)) {
                mods += 128;
            }
            if (!modifier.equals((Object)Modifier.VOLATILE)) continue;
            mods += 64;
        }
        return mods;
    }

    @Override
    public MetadataMethod visitExecutable(ExecutableElement executableElement, MetadataClass metadataClass) {
        MetadataMethod method = new MetadataMethod(metadataClass.getMetadataFactory(), metadataClass);
        method.setName(executableElement.getSimpleName().toString());
        method.setAttributeName(Helper.getAttributeNameFromMethodName((String)method.getName()));
        method.setModifiers(this.getModifiers(executableElement.getModifiers()));
        executableElement.asType().accept(this.typeVisitor, method);
        this.buildMetadataAnnotations((MetadataAnnotatedElement)method, executableElement.getAnnotationMirrors());
        MetadataMethod existing = (MetadataMethod)metadataClass.getMethods().get(method.getName());
        if (existing == null) {
            metadataClass.addMethod(method);
        } else {
            while (existing.getNext() != null) {
                existing = existing.getNext();
            }
            existing.setNext(method);
        }
        return method;
    }

    @Override
    public MetadataClass visitPackage(PackageElement arg0, MetadataClass metadataClass) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "ElementVisitor Package NOT IMPLEMENTED : " + arg0);
        return null;
    }

    @Override
    public MetadataClass visitType(TypeElement typeElement, MetadataClass metadataClass) {
        MetadataMirrorFactory factory = (MetadataMirrorFactory)metadataClass.getMetadataFactory();
        metadataClass.setName(typeElement.getQualifiedName().toString());
        metadataClass.setType(metadataClass.getName());
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            metadataClass.addInterface(factory.getMetadataClass(typeMirror).getName());
        }
        TypeMirror superclass = typeElement.getSuperclass();
        if (superclass != null) {
            metadataClass.setSuperclassName(factory.getMetadataClass(superclass).getName());
        }
        if (!metadataClass.isJDK()) {
            metadataClass.setModifiers(this.getModifiers(typeElement.getModifiers()));
            typeElement.asType().accept(this.typeVisitor, metadataClass);
            for (Element element : typeElement.getEnclosedElements()) {
                if (element.getKind().isClass()) {
                    metadataClass.addEnclosedClass(factory.getMetadataClass(element));
                    continue;
                }
                element.accept(this, metadataClass);
            }
            this.buildMetadataAnnotations((MetadataAnnotatedElement)metadataClass, typeElement.getAnnotationMirrors());
        }
        return metadataClass;
    }

    @Override
    public MetadataClass visitTypeParameter(TypeParameterElement typeParameterElement, MetadataClass metadataClass) {
        metadataClass.setName(typeParameterElement.getSimpleName().toString());
        metadataClass.setType(TypeVisitor.GENERIC_TYPE);
        return metadataClass;
    }

    @Override
    public MetadataField visitVariable(VariableElement variableElement, MetadataClass metadataClass) {
        MetadataField field = new MetadataField(metadataClass);
        field.setName(variableElement.getSimpleName().toString());
        field.setAttributeName(field.getName());
        variableElement.asType().accept(this.typeVisitor, field);
        field.setModifiers(this.getModifiers(variableElement.getModifiers()));
        this.buildMetadataAnnotations((MetadataAnnotatedElement)field, variableElement.getAnnotationMirrors());
        metadataClass.addField(field);
        return field;
    }
}

