/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.CommandThreadPool;
import com.sun.enterprise.admin.util.InstanceStateFileProcessor;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.InstanceCommand;
import org.glassfish.api.admin.InstanceCommandResult;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class InstanceStateService
implements Startup,
PostConstruct {
    @Inject
    private Habitat habitat;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private Domain domain;
    @Inject
    private Logger logger;
    @Inject
    private CommandThreadPool cmdPool;
    private InstanceStateFileProcessor stateProcessor;
    private HashMap<String, InstanceState> instanceStates = new HashMap();
    private final int MAX_RECORDED_FAILED_COMMANDS = 10;

    public void postConstruct() {
        if (this.serverEnv.isInstance()) {
            return;
        }
        this.stateProcessor = new InstanceStateFileProcessor(this.habitat, this.instanceStates, this.domain, this.serverEnv.getConfigDirPath().getAbsolutePath() + File.separatorChar + ".instancestate");
        if (this.domain.getServers().getServer().size() == 1) {
            return;
        }
        try {
            this.stateProcessor.parse();
        }
        catch (Exception e) {
            this.logger.severe("Error while parsing instance state file : " + e.getLocalizedMessage());
        }
    }

    public synchronized void addServerToStateService(String instanceName) {
        if (this.instanceStates.get(instanceName) != null) {
            return;
        }
        try {
            this.instanceStates.put(instanceName, new InstanceState(InstanceState.StateType.NO_RESPONSE));
            this.stateProcessor.addNewServer(instanceName);
        }
        catch (Exception e) {
            this.logger.severe("Error while adding new server state to instance state : " + e.getLocalizedMessage());
        }
    }

    public synchronized void addFailedCommandToInstance(String instance, String cmdDetails) {
        try {
            InstanceState i = this.instanceStates.get(instance);
            if (i != null && i.getFailedCommands().size() < 10) {
                i.addFailedCommands(cmdDetails);
                this.stateProcessor.addFailedCommand(instance, cmdDetails);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error while adding new server state to instance state : " + e.getLocalizedMessage());
        }
    }

    public synchronized void removeFailedCommandsForInstance(String instance) {
        try {
            InstanceState i = this.instanceStates.get(instance);
            if (i != null) {
                i.removeFailedCommands();
                this.stateProcessor.removeFailedCommands(instance);
            }
        }
        catch (Exception e) {
            this.logger.severe("Error while failed commands from instance state : " + e.getLocalizedMessage());
        }
    }

    public InstanceState.StateType getState(String instanceName) {
        InstanceState s = this.instanceStates.get(instanceName);
        if (s == null) {
            return InstanceState.StateType.NO_RESPONSE;
        }
        return s.getState();
    }

    public List<String> getFailedCommands(String instanceName) {
        InstanceState s = this.instanceStates.get(instanceName);
        if (s == null) {
            return new ArrayList<String>();
        }
        return s.getFailedCommands();
    }

    public synchronized InstanceState.StateType setState(String name, InstanceState.StateType newState, boolean force) {
        boolean updateXML = false;
        InstanceState.StateType ret = newState;
        InstanceState.StateType currState = this.instanceStates.get(name).getState();
        if (currState == null) {
            this.instanceStates.put(name, new InstanceState(newState));
            updateXML = true;
            ret = newState;
        } else if (!force && currState.equals((Object)InstanceState.StateType.RESTART_REQUIRED)) {
            updateXML = false;
            ret = currState;
        } else if (!currState.equals((Object)newState)) {
            this.instanceStates.get(name).setState(newState);
            updateXML = true;
            ret = newState;
        }
        try {
            if (force || updateXML) {
                this.stateProcessor.updateState(name, newState.getDescription());
            }
        }
        catch (Exception e) {
            this.logger.severe("Error while setting instance state : " + e.getLocalizedMessage());
        }
        return ret;
    }

    public synchronized void removeInstanceFromStateService(String name) {
        this.instanceStates.remove(name);
        try {
            this.stateProcessor.removeInstanceNode(name);
        }
        catch (Exception e) {
            this.logger.severe("Error while removing instance node : " + e.getLocalizedMessage());
        }
    }

    public Future<InstanceCommandResult> submitJob(Server server, InstanceCommand ice, InstanceCommandResult r) {
        InstanceState s = this.instanceStates.get(server.getName());
        if (s == null) {
            return null;
        }
        return this.cmdPool.submitJob(ice, r);
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }
}

