/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Logger;

public class UpgradeFileFilter
implements FilenameFilter {
    private HashSet<String> excludeList = new HashSet();
    private final StringManager stringManager = StringManager.getManager(UpgradeFileFilter.class);
    private static final Logger logger = LogService.getLogger();

    public UpgradeFileFilter(String propFile) throws FileNotFoundException, IOException, NullPointerException {
        this.loadExcludeList(propFile);
    }

    private void loadExcludeList(String propFile) throws FileNotFoundException, IOException, NullPointerException {
        Properties p = new Properties();
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(propFile);
        p.load(is);
        is.close();
        Enumeration<?> eList = p.propertyNames();
        while (eList.hasMoreElements()) {
            String s = (String)eList.nextElement();
            this.excludeList.add(s);
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        boolean flag = false;
        if (!this.excludeList.contains(name)) {
            flag = true;
        }
        return flag;
    }
}

