/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.LogControlDescriptor;
import com.sun.jts.CosTransactions.LogException;
import com.sun.jts.CosTransactions.LogExtent;
import com.sun.jts.CosTransactions.LogFileHandle;
import com.sun.jts.CosTransactions.LogHandle;
import com.sun.jts.CosTransactions.LogLSN;
import com.sun.jts.CosTransactions.LogRecordEnding;
import com.sun.jts.CosTransactions.LogRecordHeader;
import com.sun.jts.CosTransactions.LogUpcallTarget;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;

public class LogControl {
    private static final String CUSHION_NAME = "cushion";
    private static final String EXTENT_NAME = "extent.";
    private static final String CONTROL_NAME = "control";
    public static final String RECOVERY_STRING_FILE_NAME = "recoveryfile";
    public static final String RECOVERY_LOCK_FILE_NAME = "recoverylockfile";
    private static final String LOG_EXTENSION = "";
    private static final char[] EXTENT_CHARS = new char[]{'e', 'x', 't', 'e', 'n', 't', '.', '0', '0', '0'};
    boolean logInitialised = false;
    boolean logReadOnly = false;
    Vector logHandles = null;
    String directoryPath = null;
    File controlFile = null;
    File cushionFile = null;

    synchronized void initLog(boolean coldStart, boolean readOnly, String logDirectory) {
        if (this.logInitialised) {
            return;
        }
        this.logReadOnly = readOnly;
        this.directoryPath = new String(logDirectory);
        if (coldStart && !readOnly) {
            LogControl.clearDirectory(logDirectory);
        }
        this.logHandles = new Vector();
        this.logInitialised = true;
    }

    synchronized LogHandle openFile(String logFileName, LogUpcallTarget upcallTarget, String baseNewName, boolean[] newlyCreated) throws LogException {
        LogFileHandle controlFH;
        if (!this.logInitialised) {
            throw new LogException(null, 1, 1);
        }
        String logName = null;
        logName = logFileName;
        File logDir = LogControl.directory(logName, this.directoryPath);
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        this.controlFile = LogControl.controlFile(logName, this.directoryPath);
        this.cushionFile = this.cushionFile(logName);
        int openOptions = 14;
        if (this.logReadOnly) {
            openOptions = 1;
        }
        try {
            controlFH = new LogFileHandle(this.controlFile, openOptions);
        }
        catch (LogException le) {
            throw new LogException(null, 2, 3);
        }
        LogHandle logHandle = null;
        try {
            logHandle = new LogHandle(this, logName, controlFH, upcallTarget);
        }
        catch (LogException le) {
            controlFH.finalize();
            throw new LogException(null, 12, 4);
        }
        try {
            logHandle.restoreCushion(false);
        }
        catch (LogException le) {
            controlFH.finalize();
            throw new LogException(null, 12, 9);
        }
        byte[] controlBytes = new byte[24];
        int bytesRead = 0;
        try {
            bytesRead = controlFH.fileRead(controlBytes);
        }
        catch (LogException le) {
            controlFH.finalize();
            throw new LogException(null, 3, 5);
        }
        if (bytesRead == 0) {
            logHandle.logControlDescriptor.headLSN.copy(LogLSN.NULL_LSN);
            logHandle.logControlDescriptor.tailLSN.copy(LogLSN.FIRST_LSN);
            logHandle.logControlDescriptor.nextLSN.copy(LogLSN.FIRST_LSN);
            logHandle.restartDataLength = 0;
            logHandle.recordsWritten = 100;
            newlyCreated[0] = true;
            if (!this.logReadOnly) {
                try {
                    controlFH.allocFileStorage(36864);
                }
                catch (LogException le) {
                    controlFH.finalize();
                    throw new LogException(null, 7, 6);
                }
                logHandle.logControlDescriptor.toBytes(controlBytes, 0);
                try {
                    int bytesWritten = controlFH.fileWrite(controlBytes);
                }
                catch (LogException le) {
                    controlFH.finalize();
                    throw new LogException(null, 7, 7);
                }
                LogExtent logEDP = null;
                try {
                    logEDP = logHandle.openExtent(logHandle.logControlDescriptor.nextLSN.extent);
                }
                catch (LogException le) {
                    controlFH.finalize();
                    throw new LogException(null, 11, 10);
                }
                try {
                    logEDP.fileHandle.allocFileStorage(65536);
                }
                catch (LogException le) {
                    controlFH.finalize();
                    throw new LogException(null, 11, 11);
                }
                logHandle.chunkRemaining = 65536;
            }
        } else {
            newlyCreated[0] = false;
            logHandle.logControlDescriptor = new LogControlDescriptor(controlBytes, 0);
            LogExtent logEDP = null;
            for (int currentExtent = logHandle.logControlDescriptor.tailLSN.extent; currentExtent <= logHandle.logControlDescriptor.headLSN.extent || currentExtent <= logHandle.logControlDescriptor.nextLSN.extent; ++currentExtent) {
                try {
                    logEDP = logHandle.openExtent(currentExtent);
                    continue;
                }
                catch (LogException le) {
                    controlFH.finalize();
                    throw new LogException(null, 26, 19);
                }
            }
            int[] restartValues1 = new int[2];
            int[] restartValues2 = new int[2];
            try {
                LogHandle.checkRestart(controlFH, 1, restartValues1);
            }
            catch (LogException le) {
                controlFH.finalize();
                throw new LogException(null, 3, 8);
            }
            try {
                LogHandle.checkRestart(controlFH, 2, restartValues2);
            }
            catch (LogException le) {
                controlFH.finalize();
                throw new LogException(null, 3, 9);
            }
            if (restartValues2[0] != 0 && restartValues2[1] > restartValues1[1]) {
                logHandle.activeRestartVersion = 2;
                logHandle.restartDataLength = restartValues2[0];
            } else {
                logHandle.activeRestartVersion = 1;
                logHandle.restartDataLength = restartValues1[0];
            }
            if (logHandle.logControlDescriptor.headLSN.isNULL()) {
                logHandle.recordsWritten = 100;
            }
        }
        this.logHandles.addElement(logHandle);
        if (!logHandle.logControlDescriptor.headLSN.isNULL()) {
            boolean lastValidRead = false;
            LogExtent logEDP = null;
            try {
                logEDP = logHandle.positionFilePointer(logHandle.logControlDescriptor.headLSN, 0, 1);
            }
            catch (LogException le) {
                controlFH.finalize();
                this.removeFile(logHandle);
                throw new LogException(null, 2, 10);
            }
            byte[] headerBytes = new byte[32];
            try {
                bytesRead = logEDP.fileHandle.fileRead(headerBytes);
            }
            catch (LogException le) {
                controlFH.finalize();
                this.removeFile(logHandle);
                throw new LogException(null, le.errorCode, 11);
            }
            LogRecordHeader extentRec = new LogRecordHeader(headerBytes, 0);
            if (!extentRec.currentLSN.equals(logHandle.logControlDescriptor.headLSN)) {
                controlFH.finalize();
                this.removeFile(logHandle);
                throw new LogException(null, 4, 12);
            }
            logEDP.cursorPosition += bytesRead;
            LogRecordHeader headRec = new LogRecordHeader();
            headRec.copy(extentRec);
            int offset = headRec.nextLSN.offset;
            try {
                logEDP = logHandle.positionFilePointer(extentRec.nextLSN, 0, 1);
            }
            catch (LogException le) {
                controlFH.finalize();
                this.removeFile(logHandle);
                throw new LogException(null, 2, 13);
            }
            LogRecordHeader linkRec = new LogRecordHeader();
            lastValidRead = false;
            do {
                offset = extentRec.nextLSN.offset;
                try {
                    bytesRead = logEDP.fileHandle.fileRead(headerBytes);
                }
                catch (LogException le) {
                    controlFH.finalize();
                    this.removeFile(logHandle);
                    throw new LogException(null, 3, 14);
                }
                if (bytesRead == -1) {
                    controlFH.finalize();
                    this.removeFile(logHandle);
                    throw new LogException(null, 3, 14);
                }
                extentRec = new LogRecordHeader(headerBytes, 0);
                logEDP.cursorPosition += bytesRead;
                if (extentRec.currentLSN.offset == offset) {
                    if (extentRec.recordType == 65536) {
                        linkRec.copy(extentRec);
                        try {
                            logEDP = logHandle.positionFilePointer(extentRec.nextLSN, 0, 1);
                        }
                        catch (LogException le) {
                            controlFH.finalize();
                            this.removeFile(logHandle);
                            throw new LogException(null, le.errorCode, 15);
                        }
                    }
                    if (!linkRec.currentLSN.isNULL() && !linkRec.nextLSN.equals(extentRec.currentLSN)) {
                        linkRec = new LogRecordHeader();
                    }
                    headRec.copy(extentRec);
                    try {
                        logEDP = logHandle.positionFilePointer(extentRec.nextLSN, 0, 1);
                    }
                    catch (Throwable e) {}
                } else {
                    lastValidRead = true;
                    try {
                        logEDP = logHandle.positionFilePointer(headRec.currentLSN, 32 + headRec.recordLength, 1);
                    }
                    catch (LogException le) {
                        controlFH.finalize();
                        this.removeFile(logHandle);
                        throw new LogException(null, le.errorCode, 16);
                    }
                    byte[] endingBytes = new byte[8];
                    try {
                        bytesRead = logEDP.fileHandle.fileRead(endingBytes);
                    }
                    catch (LogException le) {
                        controlFH.finalize();
                        this.removeFile(logHandle);
                        throw new LogException(null, le.errorCode, 17);
                    }
                    LogRecordEnding endRec = new LogRecordEnding(endingBytes, 0);
                    logEDP.cursorPosition += bytesRead;
                    if (endRec.currentLSN.equals(headRec.currentLSN)) {
                        logHandle.logControlDescriptor.headLSN.copy(headRec.currentLSN);
                        logHandle.logControlDescriptor.nextLSN.copy(headRec.nextLSN);
                    } else if (linkRec.currentLSN.isNULL()) {
                        logHandle.logControlDescriptor.headLSN.copy(headRec.previousLSN);
                        logHandle.logControlDescriptor.nextLSN.copy(headRec.currentLSN);
                    } else {
                        logHandle.logControlDescriptor.headLSN.copy(linkRec.previousLSN);
                        logHandle.logControlDescriptor.nextLSN.copy(linkRec.currentLSN);
                    }
                }
                ++logHandle.recordsWritten;
            } while (!lastValidRead);
        }
        logHandle.blockValid = logHandle;
        return logHandle;
    }

    synchronized void cleanUp(LogHandle logHandle) throws LogException {
        if (!this.logInitialised) {
            throw new LogException(null, 1, 1);
        }
        if (logHandle == null || logHandle.blockValid != logHandle) {
            throw new LogException(null, 5, 2);
        }
        logHandle.blockValid = null;
        logHandle.cleanUpExtents();
        this.removeFile(logHandle);
    }

    static boolean checkFileExists(String logId, String logDirectory) {
        if (logDirectory == null) {
            return false;
        }
        boolean exists = LogControl.controlFile(logId, logDirectory).exists();
        return exists;
    }

    synchronized void removeFile(LogHandle logHandle) {
        this.logHandles.removeElement(logHandle);
        logHandle.blockValid = null;
    }

    void dump() {
    }

    static void clearDirectory(String logDir) {
        File directory = new File(logDir);
        String[] allFiles = directory.list();
        for (int i = 0; i < allFiles.length; ++i) {
            File logFileDir;
            if (!allFiles[i].endsWith(LOG_EXTENSION) || !(logFileDir = new File(directory, allFiles[i])).isDirectory()) continue;
            final String[] logFiles = logFileDir.list();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (int j = 0; j < logFiles.length; ++j) {
                        new File(logFileDir, logFiles[j]).delete();
                    }
                    return null;
                }
            });
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    logFileDir.delete();
                    return null;
                }
            });
        }
    }

    File extentFile(String logId, int extent) {
        int extentHigh;
        char[] buff = (char[])EXTENT_CHARS.clone();
        int tmpExtent = extent / 36;
        int extentLow = extent % 36;
        int extentMid = tmpExtent % 36;
        buff[7] = (char)(extentHigh + ((extentHigh = tmpExtent / 36) > 9 ? 55 : 48));
        buff[8] = (char)(extentMid + (extentMid > 9 ? 55 : 48));
        buff[9] = (char)(extentLow + (extentLow > 9 ? 55 : 48));
        String fileName = new String(buff);
        File result = new File(LogControl.directory(logId, this.directoryPath), fileName);
        return result;
    }

    static final File controlFile(String logId, String logDir) {
        File result = new File(LogControl.directory(logId, logDir), CONTROL_NAME);
        return result;
    }

    final File cushionFile(String logId) {
        File result = new File(LogControl.directory(logId, this.directoryPath), CUSHION_NAME);
        return result;
    }

    static final File directory(String logId, String logDir) {
        if (logDir == null) {
            return new File("." + File.separator + logId + LOG_EXTENSION);
        }
        return new File(logDir);
    }

    static final File recoveryIdentifierFile(String logId, String logDir) {
        File result = new File(LogControl.directory(logId, logDir), RECOVERY_STRING_FILE_NAME);
        return result;
    }

    public static final File recoveryLockFile(String logId, String logDir) {
        File result = new File(LogControl.directory(logId, logDir), RECOVERY_LOCK_FILE_NAME);
        return result;
    }
}

