/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.util.InstanceRegisterInstanceCommandParameters;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="_register-instance-at-instance")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.INSTANCE})
public class InstanceRegisterInstanceCommand
extends InstanceRegisterInstanceCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InstanceRegisterInstanceCommand.class);
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject(name="default-instance-name")
    protected Server server;

    public void execute(AdminCommandContext ctxt) {
        ActionReport report = ctxt.getActionReport();
        Logger logger = ctxt.getLogger();
        try {
            Server s;
            Node n = this.domain.getNodes().getNode(this.node);
            if (n == null) {
                ConfigSupport.apply(new SingleConfigCode<Nodes>(){

                    @Override
                    public Object run(Nodes param) throws PropertyVetoException, TransactionFailure {
                        Node newNode = (Node)param.createChild(Node.class);
                        newNode.setName(InstanceRegisterInstanceCommand.this.node);
                        if (InstanceRegisterInstanceCommand.this.installdir != null && InstanceRegisterInstanceCommand.this.installdir != "") {
                            newNode.setInstallDir(InstanceRegisterInstanceCommand.this.installdir);
                        }
                        if (InstanceRegisterInstanceCommand.this.nodedir != null && InstanceRegisterInstanceCommand.this.nodedir != "") {
                            newNode.setNodeDir(InstanceRegisterInstanceCommand.this.nodedir);
                        }
                        if (InstanceRegisterInstanceCommand.this.nodehost != null && InstanceRegisterInstanceCommand.this.nodehost != "") {
                            newNode.setNodeHost(InstanceRegisterInstanceCommand.this.nodehost);
                        }
                        newNode.setType(InstanceRegisterInstanceCommand.this.type);
                        param.getNode().add(newNode);
                        return newNode;
                    }
                }, this.domain.getNodes());
            }
            if ((s = this.domain.getServers().getServer(this.instanceName)) == null) {
                ConfigSupport.apply(new SingleConfigCode<Servers>(){

                    @Override
                    public Object run(Servers param) throws PropertyVetoException, TransactionFailure {
                        Server newServer = (Server)param.createChild(Server.class);
                        newServer.setConfigRef(InstanceRegisterInstanceCommand.this.config);
                        newServer.setName(InstanceRegisterInstanceCommand.this.instanceName);
                        newServer.setNode(InstanceRegisterInstanceCommand.this.node);
                        if (InstanceRegisterInstanceCommand.this.systemProperties != null) {
                            for (Map.Entry<Object, Object> entry : InstanceRegisterInstanceCommand.this.systemProperties.entrySet()) {
                                String propName = (String)entry.getKey();
                                String propValue = (String)entry.getValue();
                                SystemProperty newSP = (SystemProperty)newServer.createChild(SystemProperty.class);
                                newSP.setName(propName);
                                newSP.setValue(propValue);
                                newServer.getSystemProperty().add(newSP);
                            }
                        }
                        param.getServer().add(newServer);
                        return newServer;
                    }
                }, this.domain.getServers());
                Cluster thisCluster = this.domain.getClusterNamed(this.clusterName);
                if (thisCluster != null) {
                    ConfigSupport.apply(new SingleConfigCode<Cluster>(){

                        @Override
                        public Object run(Cluster param) throws PropertyVetoException, TransactionFailure {
                            ServerRef newServerRef = (ServerRef)param.createChild(ServerRef.class);
                            newServerRef.setRef(InstanceRegisterInstanceCommand.this.instanceName);
                            newServerRef.setLbEnabled(InstanceRegisterInstanceCommand.this.lbEnabled);
                            param.getServerRef().add(newServerRef);
                            return param;
                        }
                    }, thisCluster);
                }
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("register.instance.failed", "Instance {0} registration failed on {1}", new Object[]{this.instanceName, this.server.getName()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
            return;
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("register.instance.failed", "Instance {0} registration failed on {1}", new Object[]{this.instanceName, this.server.getName()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
    }
}

