/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.Pattern;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.ha.store.spi.BackingStoreFactoryRegistry;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-persistence-types")
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.persistence.types.command")
@Scoped(value=PerLookup.class)
public class ListPersistenceTypesCommand
implements AdminCommand {
    @Param(name="type", optional=false, primary=false)
    @I18n(value="list.persistence.types.container")
    @Pattern(regexp="(ejb|web)")
    private String containerType;
    private ActionReport report;
    private Logger logger;
    private static final String EOL = "\n";
    private static final String SEPARATOR = "\n";

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        if (!this.checkEnvAndParams()) {
            return;
        }
        this.logger.log(Level.INFO, Strings.get("list.persistence.types.called", this.containerType));
        Set types = BackingStoreFactoryRegistry.getRegisteredTypes();
        types.remove("noop");
        StringBuilder sb = new StringBuilder("");
        boolean removeTrailingSeparator = false;
        for (String type : types) {
            sb.append(type).append("\n");
            removeTrailingSeparator = true;
        }
        String output = sb.toString();
        if (removeTrailingSeparator) {
            output = output.substring(0, output.length() - 1);
        }
        Properties extraProperties = new Properties();
        extraProperties.put("types", new ArrayList(types));
        this.report.setExtraProperties(extraProperties);
        this.report.setMessage(output);
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean checkEnvAndParams() {
        if (this.containerType == null) {
            return this.fail(Strings.get("list.persistence.types.null.parameter"));
        }
        if (!this.containerType.equals("ejb") && !this.containerType.equals("web")) {
            return this.fail(Strings.get("list.persistence.types.invalid.parameter", this.containerType));
        }
        return true;
    }

    private boolean fail(String s) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(s);
        return false;
    }
}

