/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.MonitoringReporter;
import com.sun.enterprise.v3.admin.V2DottedNameSupport;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.types.Property;

@Service(name="get")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
public class GetCommand
extends V2DottedNameSupport
implements AdminCommand {
    @Inject
    private MonitoringReporter mr;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment serverEnv;
    @Inject
    Target targetService;
    @Inject
    Habitat habitat;
    @Param(optional=true, defaultValue="false", shortName="m")
    Boolean monitor;
    @Param(primary=true)
    String pattern;
    @Inject(optional=true)
    private MonitoringRuntimeDataRegistry mrdr;
    private final String DOTTED_NAME = ".dotted-name";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GetCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PropsFileActionReporter reporter = (PropsFileActionReporter)report;
            reporter.useMainChildrenAttribute(true);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (this.monitor.booleanValue()) {
            this.getMonitorAttributes(report, context);
            String old = report.getMessage();
            String append = "\nXXXXXXXXX\n" + this.mr.toString();
            report.setMessage(old == null ? append : old + append);
            return;
        }
        if (this.pattern.contains(".log-service")) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("admin.get.invalid.logservice.command", "For getting log levels/attributes use list-log-levels/list-log-attributes command."));
            return;
        }
        if (!(this.pattern.equals("*") || this.pattern.lastIndexOf(".") != -1 && this.pattern.lastIndexOf(".") != this.pattern.length() - 1)) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("missing.dotted.name", "Missing expected dotted name part"));
            return;
        }
        V2DottedNameSupport.TreeNode[] parentNodes = this.getAliasedParent(this.domain, this.pattern);
        HashMap<Dom, String> dottedNames = new HashMap<Dom, String>();
        for (V2DottedNameSupport.TreeNode parentNode : parentNodes) {
            dottedNames.putAll(this.getAllDottedNodes(parentNode.node));
        }
        String prefix = "";
        if (!this.pattern.startsWith(parentNodes[0].relativeName)) {
            prefix = this.pattern.substring(0, this.pattern.indexOf(parentNodes[0].relativeName));
        }
        this.pattern = parentNodes[0].relativeName;
        Map<Dom, String> matchingNodes = this.getMatchingNodes(dottedNames, this.pattern);
        if (matchingNodes.isEmpty() && this.pattern.lastIndexOf(46) != -1) {
            matchingNodes = this.getMatchingNodes(dottedNames, this.pattern.substring(0, this.pattern.lastIndexOf(".")));
        }
        if (matchingNodes.isEmpty()) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("admin.get.path.notfound", "Dotted name path {0} not found.", new Object[]{prefix + this.pattern}));
            return;
        }
        List<Map.Entry> matchingNodesSorted = this.sortNodesByDottedName(matchingNodes);
        matchingNodesSorted = this.applyOverrideRules(matchingNodesSorted);
        boolean foundMatch = false;
        for (Map.Entry node : matchingNodesSorted) {
            if (Property.class.getName().equals(((Dom)node.getKey()).model.targetTypeName)) {
                if (!this.matches((String)node.getValue(), this.pattern)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(prefix + (String)node.getValue() + "=" + this.encode(((Dom)node.getKey()).attribute("value")));
                foundMatch = true;
                continue;
            }
            Map<String, String> attributes = this.getNodeAttributes((Dom)node.getKey(), this.pattern);
            TreeMap<String, String> attributesSorted = new TreeMap<String, String>(attributes);
            for (Map.Entry<String, String> name : attributesSorted.entrySet()) {
                String finalDottedName = (String)node.getValue() + "." + name.getKey();
                if (!this.matches(finalDottedName, this.pattern)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setChildrenType("DottedName");
                part.setMessage(prefix + (String)node.getValue() + "." + name.getKey() + "=" + name.getValue());
                foundMatch = true;
            }
        }
        if (!foundMatch) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(localStrings.getLocalString("admin.get.path.notfound", "Dotted name path {0} not found.", new Object[]{prefix + this.pattern}));
        }
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private void getMonitorAttributes(ActionReport report, AdminCommandContext ctxt) {
        this.mr.prepare(ctxt, this.pattern);
        this.mr.execute();
    }
}

