/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.base;

import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.impl.base.CustomTagNames;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.logging.NiceLogFormatter;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utility {
    private static Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    public static final long NO_SUCH_TIME = -1L;

    public static void setLogger(Logger theLogger) {
        logger = theLogger;
    }

    public static GMSMember getGMSMember(SystemAdvertisement systemAdvertisement) {
        String memberType = Utility.getCustomTagValue(systemAdvertisement, CustomTagNames.MEMBER_TYPE.toString());
        String groupName = Utility.getGroupName(systemAdvertisement);
        long startTime = Utility.getStartTime(systemAdvertisement);
        GMSMember member = new GMSMember(systemAdvertisement.getName(), memberType, groupName, Long.valueOf(startTime));
        return member;
    }

    private static String getCustomTagValue(SystemAdvertisement sa, String tagName) {
        String result = null;
        try {
            result = sa.getCustomTagValue(tagName);
        }
        catch (NoSuchFieldException e) {
            logger.log(Level.WARNING, "util.sysadv.missing.custom.tag", new Object[]{tagName, sa.getName()});
        }
        return result;
    }

    public static boolean isWatchDog(SystemAdvertisement sysAdv) {
        GMSMember member = Utility.getGMSMember(sysAdv);
        return GroupManagementService.MemberType.WATCHDOG.toString().equalsIgnoreCase(member.getMemberType());
    }

    public static String getStringProperty(String propertyName, String defaultValue, Map props) {
        try {
            Object obj;
            String value = null;
            if (props != null && (obj = props.get(propertyName)) instanceof String) {
                value = (String)obj;
            }
            if (value == null) {
                value = System.getProperty(propertyName);
            }
            if (value == null) {
                return defaultValue;
            }
            return value;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getIntProperty(String propertyName, int defaultValue, Map props) {
        try {
            String value = null;
            if (props != null) {
                Object obj = props.get(propertyName);
                if (obj instanceof String) {
                    value = (String)obj;
                } else if (obj instanceof Integer) {
                    return (Integer)obj;
                }
            }
            if (value == null) {
                value = System.getProperty(propertyName);
            }
            if (value == null) {
                return defaultValue;
            }
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLongProperty(String propertyName, long defaultValue, Map props) {
        try {
            String value = null;
            if (props != null) {
                Object obj = props.get(propertyName);
                if (obj instanceof String) {
                    value = (String)obj;
                } else {
                    if (obj instanceof Long) {
                        return (Long)obj;
                    }
                    if (obj instanceof Integer) {
                        return ((Integer)obj).longValue();
                    }
                }
            }
            if (value == null) {
                value = System.getProperty(propertyName);
            }
            if (value == null) {
                return defaultValue;
            }
            return Long.parseLong(value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static boolean getBooleanProperty(String propertyName, boolean defaultValue, Map props) {
        try {
            String value = null;
            if (props != null) {
                Object obj = props.get(propertyName);
                if (obj instanceof String) {
                    value = (String)obj;
                } else if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
            }
            if (value == null) {
                value = System.getProperty(propertyName);
            }
            if (value == null) {
                return defaultValue;
            }
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static void setupLogHandler() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        try {
            consoleHandler.setLevel(Level.ALL);
            consoleHandler.setFormatter(new NiceLogFormatter());
        }
        catch (SecurityException e) {
            new ErrorManager().error("Exception caught in setting up ConsoleHandler ", e, 0);
        }
        logger.addHandler(consoleHandler);
        logger.setUseParentHandlers(false);
        String level = System.getProperty("LOG_LEVEL", "INFO");
        logger.setLevel(Level.parse(level));
    }

    public static long getStartTime(SystemAdvertisement advert) {
        try {
            return Long.valueOf(advert.getCustomTagValue(CustomTagNames.START_TIME.toString()));
        }
        catch (NoSuchFieldException nsfe) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(String.format("NoSuchFieldException caught in Utility#getStartTime. Returning %s", -1L));
            }
            return -1L;
        }
    }

    public static String getGroupName(SystemAdvertisement advert) {
        try {
            return advert.getCustomTagValue(CustomTagNames.GROUP_NAME.toString());
        }
        catch (NoSuchFieldException nsfe) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("NoSuchFieldException caught in Utility#getGroupName. Returning null");
            }
            return null;
        }
    }
}

