/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GroupHandle;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.RejoinSubevent;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.common.AliveAndReadyViewImpl;
import com.sun.enterprise.ee.cms.impl.common.FailureNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.JoinedAndReadyNotificationSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.PlannedShutdownSignalImpl;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AliveAndReadyViewWindow {
    protected static final Logger LOG = Logger.getLogger("ShoalLogger.ready");
    static final long MIN_VIEW_DURATION = 1000L;
    private long MAX_CLUSTER_STARTTIME_DURATION_MS = 10000L;
    static final int MAX_ALIVE_AND_READY_VIEWS = 5;
    private final List<AliveAndReadyView> aliveAndReadyView = new LinkedList<AliveAndReadyView>();
    private long viewId = 0L;
    private JoinedAndReadyNotificationActionFactoryImpl joinedAndReadyActionFactory = null;
    private FailureNotificationActionFactoryImpl failureActionFactory = null;
    private PlannedShutdownActionFactoryImpl plannedShutdownFactory = null;
    private final JoinedAndReadyCallBack jrcallback;
    private final LeaveCallBack leaveCallback;
    private long simulatedStartClusterTime;
    private AtomicBoolean isSimulatedStartCluster = new AtomicBoolean(false);
    private final String currentInstanceName;
    private ConcurrentHashMap<String, SortedSet<String>> joinedAndReadySignalReadyList = new ConcurrentHashMap();
    private final GMSContext ctx;
    private static final Level TRACE_LEVEL = Level.FINE;

    public AliveAndReadyViewWindow(GMSContext ctx) {
        this.ctx = ctx;
        Router router = ctx.getRouter();
        this.currentInstanceName = ctx.getServerIdentityToken();
        this.jrcallback = new JoinedAndReadyCallBack(ctx.getGroupHandle(), this.aliveAndReadyView);
        this.joinedAndReadyActionFactory = new JoinedAndReadyNotificationActionFactoryImpl(this.jrcallback);
        this.leaveCallback = new LeaveCallBack(ctx.getGroupHandle(), this.aliveAndReadyView);
        this.failureActionFactory = new FailureNotificationActionFactoryImpl(this.leaveCallback);
        this.plannedShutdownFactory = new PlannedShutdownActionFactoryImpl(this.leaveCallback);
        this.aliveAndReadyView.add(new AliveAndReadyViewImpl(new TreeSet<String>(), this.viewId++));
        this.aliveAndReadyView.add(new AliveAndReadyViewImpl(new TreeSet<String>(), this.viewId++));
    }

    AliveAndReadyViewWindow() {
        this.ctx = null;
        this.jrcallback = new JoinedAndReadyCallBack(null, this.aliveAndReadyView);
        this.leaveCallback = new LeaveCallBack(null, this.aliveAndReadyView);
        this.currentInstanceName = null;
        this.aliveAndReadyView.add(new AliveAndReadyViewImpl(new TreeSet<String>(), this.viewId++));
        this.aliveAndReadyView.add(new AliveAndReadyViewImpl(new TreeSet<String>(), this.viewId++));
    }

    public void setStartClusterMaxDuration(long durationInMs) {
        this.MAX_CLUSTER_STARTTIME_DURATION_MS = durationInMs;
    }

    public void processNotification(Signal signal) {
        if (signal instanceof JoinedAndReadyNotificationSignal) {
            this.jrcallback.processNotification(signal);
        } else if (signal instanceof PlannedShutdownSignal || signal instanceof FailureNotificationSignal) {
            this.leaveCallback.processNotification(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AliveAndReadyView getPreviousView() {
        AliveAndReadyView result = null;
        List<AliveAndReadyView> list = this.aliveAndReadyView;
        synchronized (list) {
            int size = this.aliveAndReadyView.size();
            assert (size > 2);
            if (size >= 2) {
                result = this.aliveAndReadyView.get(size - 2);
            } else if (size == 1) {
                result = this.aliveAndReadyView.get(0);
                if (LOG.isLoggable(TRACE_LEVEL)) {
                    LOG.log(TRACE_LEVEL, "getPreviousAliveAndReadyView() called and only a current view", result);
                }
            }
        }
        if (LOG.isLoggable(TRACE_LEVEL)) {
            LOG.log(TRACE_LEVEL, "getPreviousAliveAndReadyView: returning " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AliveAndReadyView getCurrentView() {
        AliveAndReadyView result = null;
        List<AliveAndReadyView> list = this.aliveAndReadyView;
        synchronized (list) {
            int length = this.aliveAndReadyView.size();
            if (length > 0) {
                result = this.aliveAndReadyView.get(length - 1);
            }
        }
        if (LOG.isLoggable(TRACE_LEVEL)) {
            LOG.log(TRACE_LEVEL, "getCurrentAliveAndReadyView: returning " + result);
        }
        return result;
    }

    private boolean isMySignal(Signal sig) {
        return this.currentInstanceName != null && this.currentInstanceName.equals(sig.getMemberToken());
    }

    public void put(String joinedAndReadyMember, SortedSet<String> readyMembers) {
        if (LOG.isLoggable(TRACE_LEVEL)) {
            LOG.log(TRACE_LEVEL, "put joinedAndReadySignal member:" + joinedAndReadyMember + " ready members:" + readyMembers);
        }
        SortedSet<String> result = this.joinedAndReadySignalReadyList.put(joinedAndReadyMember, readyMembers);
    }

    private boolean isStartClusterComplete() {
        return this.ctx != null ? this.ctx.isGroupStartupComplete() : false;
    }

    private class JoinedAndReadyCallBack
    extends CommonCallBack {
        public JoinedAndReadyCallBack(GroupHandle gh, List<AliveAndReadyView> aliveAndReadyView) {
            super(gh, aliveAndReadyView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processNotification(Signal signal) {
            if (signal instanceof JoinedAndReadyNotificationSignal) {
                JoinedAndReadyNotificationSignal jrns = (JoinedAndReadyNotificationSignal)signal;
                RejoinSubevent rejoin = jrns.getRejoinSubevent();
                SortedSet dasReadyMembers = (SortedSet)AliveAndReadyViewWindow.this.joinedAndReadySignalReadyList.remove(jrns.getMemberToken());
                AliveAndReadyView current = null;
                List list = this.aliveAndReadyView;
                synchronized (list) {
                    AliveAndReadyView previous;
                    current = AliveAndReadyViewWindow.this.getCurrentView();
                    TreeSet<String> currentMembers = new TreeSet<String>(current.getMembers());
                    for (String member : jrns.getCurrentCoreMembers()) {
                        if (dasReadyMembers != null && dasReadyMembers.contains(member)) {
                            if (!currentMembers.add(member)) continue;
                            if (AliveAndReadyViewWindow.this.ctx != null) {
                                AliveAndReadyViewWindow.this.ctx.setGroupStartupState(member, MemberStates.ALIVEANDREADY);
                            }
                            if (!LOG.isLoggable(TRACE_LEVEL)) continue;
                            LOG.log(TRACE_LEVEL, "das ready member: " + member + " added");
                            continue;
                        }
                        if (!jrns.getMemberToken().equals(member)) continue;
                        currentMembers.add(member);
                        if (AliveAndReadyViewWindow.this.ctx == null) continue;
                        AliveAndReadyViewWindow.this.ctx.setGroupStartupState(member, MemberStates.ALIVEANDREADY);
                    }
                    this.add(signal, currentMembers);
                    if (jrns.getEventSubType() == GMSConstants.startupType.GROUP_STARTUP) {
                        if (AliveAndReadyViewWindow.this.ctx != null) {
                            AliveAndReadyViewWindow.this.ctx.setGroupStartupState(signal.getMemberToken(), MemberStates.ALIVEANDREADY);
                            if (AliveAndReadyViewWindow.this.isStartClusterComplete()) {
                                previous = AliveAndReadyViewWindow.this.getPreviousView();
                                ((AliveAndReadyViewImpl)previous).clearMembers();
                                if (LOG.isLoggable(TRACE_LEVEL)) {
                                    LOG.log(TRACE_LEVEL, "start cluster has completed, resetting previous view. previous=" + previous);
                                }
                            }
                        }
                    } else if (AliveAndReadyViewWindow.this.isMySignal(signal)) {
                        previous = AliveAndReadyViewWindow.this.getPreviousView();
                        TreeSet<String> previousMembers = new TreeSet<String>((SortedSet<String>)currentMembers);
                        if (rejoin == null) {
                            previousMembers.remove(AliveAndReadyViewWindow.this.currentInstanceName);
                        }
                        ((AliveAndReadyViewImpl)previous).setMembers(previousMembers);
                        if (LOG.isLoggable(TRACE_LEVEL)) {
                            LOG.log(TRACE_LEVEL, "JoinedAndReady INSTANCE_STARTUP current=" + AliveAndReadyViewWindow.this.getCurrentView() + " previous=" + AliveAndReadyViewWindow.this.getPreviousView());
                        }
                    }
                    if (jrns instanceof JoinedAndReadyNotificationSignalImpl) {
                        JoinedAndReadyNotificationSignalImpl jrnsimpl = (JoinedAndReadyNotificationSignalImpl)jrns;
                        jrnsimpl.setCurrentView(AliveAndReadyViewWindow.this.getCurrentView());
                        jrnsimpl.setPreviousView(AliveAndReadyViewWindow.this.getPreviousView());
                    }
                }
            }
        }
    }

    private class LeaveCallBack
    extends CommonCallBack {
        public LeaveCallBack(GroupHandle gh, List<AliveAndReadyView> aliveAndReadyView) {
            super(gh, aliveAndReadyView);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processNotification(Signal signal) {
            if (signal instanceof PlannedShutdownSignal || signal instanceof FailureNotificationSignal) {
                List list = this.aliveAndReadyView;
                synchronized (list) {
                    AliveAndReadyView current = AliveAndReadyViewWindow.this.getCurrentView();
                    if (current != null && current.getMembers().contains(signal.getMemberToken())) {
                        TreeSet<String> currentMembers = new TreeSet<String>(current.getMembers());
                        boolean result = currentMembers.remove(signal.getMemberToken());
                        assert (result);
                        this.add(signal, currentMembers);
                        if (signal instanceof PlannedShutdownSignalImpl) {
                            PlannedShutdownSignalImpl pssig = (PlannedShutdownSignalImpl)signal;
                            pssig.setCurrentView(AliveAndReadyViewWindow.this.getCurrentView());
                            pssig.setPreviousView(AliveAndReadyViewWindow.this.getPreviousView());
                        } else if (signal instanceof FailureNotificationSignalImpl) {
                            FailureNotificationSignalImpl fsig = (FailureNotificationSignalImpl)signal;
                            fsig.setCurrentView(AliveAndReadyViewWindow.this.getCurrentView());
                            fsig.setPreviousView(AliveAndReadyViewWindow.this.getPreviousView());
                        }
                    }
                }
            }
        }
    }

    private abstract class CommonCallBack
    implements CallBack {
        protected final List<AliveAndReadyView> aliveAndReadyView;
        protected final GroupHandle gh;

        public CommonCallBack(GroupHandle gh, List<AliveAndReadyView> aliveAndReadyViews) {
            this.aliveAndReadyView = aliveAndReadyViews;
            this.gh = gh;
        }

        public void add(Signal signal, SortedSet<String> members) {
            AliveAndReadyViewImpl current = (AliveAndReadyViewImpl)AliveAndReadyViewWindow.this.getCurrentView();
            if (current != null) {
                current.setSignal(signal);
            }
            AliveAndReadyViewImpl arview = new AliveAndReadyViewImpl(members, AliveAndReadyViewWindow.this.viewId++);
            this.aliveAndReadyView.add(arview);
            if (this.aliveAndReadyView.size() > 5) {
                this.aliveAndReadyView.remove(0);
            }
        }
    }
}

