/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GMSMonitor {
    private static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final Logger monitorLogger = GMSLogDomain.getMonitorLogger();
    public final boolean ENABLED;
    public static final long ENABLED_DEFAULT = -1L;
    private Timer timer = null;
    private long REPORT_DURATION = 5L;
    private long sendWriteTimeout = Long.MAX_VALUE;
    private final ConcurrentHashMap<String, MessageStats> gmsMsgStats = new ConcurrentHashMap();
    private AtomicLong maxIncomingMessageQueueSize = new AtomicLong(0L);

    public GMSMonitor(Properties props) {
        boolean enableMonitoring;
        this.REPORT_DURATION = Utility.getLongProperty(ServiceProviderConfigurationKeys.MONITORING.toString(), -1L, props);
        boolean bl = enableMonitoring = this.REPORT_DURATION > 0L;
        if (this.REPORT_DURATION != -1L && logger.isLoggable(Level.CONFIG)) {
            logger.config("GMSMonitor ENABLED: " + enableMonitoring);
        }
        this.ENABLED = enableMonitoring;
        if (this.ENABLED) {
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate((TimerTask)new Report(this), this.REPORT_DURATION * 1000L, this.REPORT_DURATION * 1000L);
        }
    }

    public void setSendWriteTimeout(long value) {
        this.sendWriteTimeout = value;
    }

    public long getSendWriteTimeout() {
        return this.sendWriteTimeout;
    }

    public void report() {
        if (this.ENABLED) {
            for (MessageStats stat : this.gmsMsgStats.values()) {
                logger.log(Level.INFO, "gmsMonitor: " + stat.toString());
            }
        }
    }

    public MessageStats getGMSMessageMonitorStats(String targetComponent) {
        MessageStats newEntry;
        MessageStats result = this.gmsMsgStats.get(targetComponent);
        if (result == null && (result = this.gmsMsgStats.putIfAbsent(targetComponent, newEntry = new MessageStats(targetComponent))) == null) {
            result = newEntry;
        }
        return result;
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public static class Report
    extends TimerTask {
        private final GMSMonitor monitor;

        public Report(GMSMonitor gmsMonitor) {
            this.monitor = gmsMonitor;
        }

        @Override
        public void run() {
            if (this.monitor.ENABLED) {
                this.monitor.report();
            }
        }
    }

    public static class MessageStats {
        private final String targetComponent;
        private AtomicLong numMsgsSent = new AtomicLong(0L);
        private AtomicLong bytesSent = new AtomicLong(0L);
        private AtomicLong sendTime = new AtomicLong(0L);
        private AtomicLong maxSendTime = new AtomicLong(0L);
        private AtomicLong failMsgSend = new AtomicLong(0L);
        private AtomicLong writeTimeoutMsgSend = new AtomicLong(0L);
        private AtomicLong numMsgsReceived = new AtomicLong(0L);
        private AtomicLong bytesReceived = new AtomicLong(0L);
        private AtomicLong numMsgsNoListener = new AtomicLong(0L);
        private AtomicLong receiveTime = new AtomicLong(0L);
        private AtomicLong maxReceiveTime = new AtomicLong(0L);

        public MessageStats(String component) {
            this.targetComponent = component;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("targetComponent:").append(this.targetComponent);
            sb.append(" Send:[numMsgs:").append(this.numMsgsSent.get());
            if (this.numMsgsSent.get() != 0L) {
                sb.append(" totalBytes:").append(this.bytesSent.get());
                sb.append(" avgMsgSize:").append(this.bytesSent.get() / this.numMsgsSent.get());
                sb.append(" totalTime:").append(this.sendTime.get());
                sb.append(" avg time:").append(this.sendTime.get() / this.numMsgsSent.get());
                sb.append(" max time:").append(this.maxSendTime.get());
            }
            if (this.writeTimeoutMsgSend.get() != 0L) {
                sb.append(" write timeout:").append(this.writeTimeoutMsgSend.get());
            }
            if (this.failMsgSend.get() != 0L) {
                sb.append(" write fail:").append(this.failMsgSend.get());
            }
            sb.append("]");
            sb.append(" Receive:[numMsgs:").append(this.numMsgsReceived);
            if (this.numMsgsReceived.get() != 0L) {
                sb.append(" totalBytes:").append(this.bytesReceived);
                sb.append(" avgMsgSize:").append(this.bytesReceived.get() / this.numMsgsReceived.get());
                sb.append(" totalTime:").append(this.receiveTime);
                sb.append(" avg time:").append(this.receiveTime.get() / this.numMsgsReceived.get());
                sb.append(" max time:").append(this.maxReceiveTime);
            }
            if (this.numMsgsNoListener.get() != 0L) {
                sb.append(" numMsgNoListener:").append(this.numMsgsNoListener);
            }
            sb.append("]");
            return sb.toString();
        }

        public long getNumFailMsgSend() {
            return this.failMsgSend.get();
        }

        public long incrementNumFailMsgSend() {
            long result = this.failMsgSend.incrementAndGet();
            if (result < 0L) {
                this.failMsgSend.set(1L);
                result = 1L;
            }
            return result;
        }

        public long getSendWriteTimeouts() {
            return this.writeTimeoutMsgSend.get();
        }

        public long incrementSendWriteTimeout() {
            long result = this.writeTimeoutMsgSend.incrementAndGet();
            if (result < 0L) {
                this.writeTimeoutMsgSend.set(1L);
                result = 1L;
            }
            return result;
        }

        public long getNumMsgsSent() {
            return this.numMsgsSent.get();
        }

        public long incrementNumMsgsSent() {
            long result = this.numMsgsSent.incrementAndGet();
            if (result < 0L) {
                this.numMsgsSent.set(1L);
                result = 1L;
            }
            return result;
        }

        public long getBytesSent() {
            return this.bytesSent.get();
        }

        public long addBytesSent(long bytesSent) {
            long result = this.bytesSent.addAndGet(bytesSent);
            if (result < 0L) {
                this.bytesSent.set(bytesSent);
                result = bytesSent;
            }
            return result;
        }

        public long getSendDuration() {
            return this.sendTime.get();
        }

        public long addSendDuration(long duration) {
            long result = this.sendTime.addAndGet(duration);
            if (result < 0L) {
                this.sendTime.set(duration);
                result = duration;
            }
            this.setMaxSendDuration(duration);
            return result;
        }

        public long getMaxSendDuration() {
            return this.maxSendTime.get();
        }

        public void setMaxSendDuration(long duration) {
            boolean result;
            long localMaxSendTime = this.maxSendTime.get();
            if (duration > localMaxSendTime && !(result = this.maxSendTime.compareAndSet(localMaxSendTime, duration))) {
                this.setMaxSendDuration(duration);
            }
        }

        public long getReceiveDuration() {
            return this.receiveTime.get();
        }

        public long addReceiveDuration(long duration) {
            long result = this.receiveTime.addAndGet(duration);
            if (result < 0L) {
                this.receiveTime.set(duration);
                result = duration;
            }
            this.setMaxReceiveDuration(duration);
            return result;
        }

        public long getMaxReeceiveDuration() {
            return this.maxSendTime.get();
        }

        public void setMaxReceiveDuration(long duration) {
            boolean result;
            long localMaxReceiveTime = this.maxReceiveTime.get();
            if (duration > localMaxReceiveTime && !(result = this.maxReceiveTime.compareAndSet(localMaxReceiveTime, duration))) {
                this.setMaxReceiveDuration(duration);
            }
        }

        public long getNumMsgsReceived() {
            return this.numMsgsReceived.get();
        }

        public long incrementNumMsgsReceived() {
            long result = this.numMsgsReceived.incrementAndGet();
            if (result < 0L) {
                this.numMsgsReceived.set(1L);
                result = 1L;
            }
            return result;
        }

        public long getBytesReceived() {
            return this.bytesReceived.get();
        }

        public long addBytesReceived(long bytesReceived) {
            long result = this.bytesReceived.addAndGet(bytesReceived);
            if (result < 0L) {
                this.bytesReceived.set(bytesReceived);
                result = bytesReceived;
            }
            return result;
        }

        public long getNumMsgsNoListener() {
            return this.numMsgsNoListener.get();
        }

        public long incrementNumMsgsNoHandler() {
            long result = this.numMsgsNoListener.incrementAndGet();
            if (result < 0L) {
                this.numMsgsNoListener.set(1L);
                result = 1L;
            }
            return result;
        }
    }
}

