/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-jacc-provider")
@Scoped(value=PerLookup.class)
@I18n(value="create.jacc.provider")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateJACCProvider
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateJACCProvider.class);
    @Param(name="policyconfigfactoryclass", alias="policyConfigurationFactoryProvider")
    private String polConfFactoryClass;
    @Param(name="policyproviderclass", alias="policyProvider")
    private String polProviderClass;
    @Param(name="jaccprovidername", primary=true)
    private String jaccProviderName;
    @Param(optional=true, name="property", separator=58)
    private Properties properties;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject(name="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Config tmp = null;
        try {
            tmp = this.configs.getConfigByName(this.target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            this.config = tmp;
        }
        if (tmp == null) {
            Cluster cluster;
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null) {
                this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
            }
            if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
                this.config = this.domain.getConfigNamed(cluster.getConfigRef());
            }
        }
        SecurityService securityService = this.config.getSecurityService();
        List jaccProviders = securityService.getJaccProvider();
        for (JaccProvider jaccProv : jaccProviders) {
            if (!jaccProv.getName().equals(this.jaccProviderName)) continue;
            report.setMessage(localStrings.getLocalString("create.jacc.provider.duplicatefound", "JaccProvider named {0} exists. Cannot add duplicate JaccProvider.", new Object[]{this.jaccProviderName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<SecurityService>(){

                @Override
                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    JaccProvider newJacc = (JaccProvider)param.createChild(JaccProvider.class);
                    newJacc.setName(CreateJACCProvider.this.jaccProviderName);
                    newJacc.setPolicyConfigurationFactoryProvider(CreateJACCProvider.this.polConfFactoryClass);
                    newJacc.setPolicyProvider(CreateJACCProvider.this.polProviderClass);
                    param.getJaccProvider().add(newJacc);
                    return newJacc;
                }
            }, securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.auth.realm.fail", "Creation of Authrealm {0} failed", new Object[]{this.jaccProviderName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

