/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijavaeebase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijavaeebase.OSGiApplicationInfo;
import org.glassfish.osgijavaeebase.OSGiDeployer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class OSGiContainer {
    private BundleContext context;
    protected Map<Bundle, OSGiApplicationInfo> applications = new HashMap<Bundle, OSGiApplicationInfo>();
    protected Map<OSGiApplicationInfo, ServiceRegistration> regs = new HashMap<OSGiApplicationInfo, ServiceRegistration>();
    private ServiceTracker deployerTracker;
    private List<ServiceReference> sortedDeployerRefs = new ArrayList<ServiceReference>();
    private boolean shutdown = false;
    private static final Logger logger = Logger.getLogger(OSGiContainer.class.getPackage().getName());

    protected OSGiContainer(BundleContext ctx) {
        this.context = ctx;
        this.deployerTracker = new OSGiDeployerTracker();
    }

    protected void init() {
        this.deployerTracker.open();
    }

    protected synchronized void shutdown() {
        this.undeployAll();
        assert (this.applications.isEmpty() && this.regs.isEmpty());
        this.applications.clear();
        this.regs.clear();
        this.sortedDeployerRefs.clear();
        this.shutdown = true;
        this.deployerTracker.close();
        this.deployerTracker = null;
        this.context = null;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    private synchronized void redeploy(Bundle b) throws Exception {
        if (this.isShutdown()) {
            return;
        }
        if (this.isDeployed(b)) {
            this.undeploy(b);
        }
        this.deploy(b);
    }

    public synchronized void deploy(Bundle b) {
        if (this.isShutdown()) {
            return;
        }
        OSGiApplicationInfo osgiAppInfo = this.applications.get(b);
        if (osgiAppInfo != null) {
            logger.logp(Level.WARNING, "OSGiContainer", "deploy", "Bundle {0} is already deployed at {1} ", new Object[]{b, osgiAppInfo.getAppInfo().getSource()});
            return;
        }
        ServiceReference osgiDeployerRef = this.selectDeployer(b);
        if (osgiDeployerRef == null) {
            return;
        }
        OSGiDeployer osgiDeployer = (OSGiDeployer)this.context.getService(osgiDeployerRef);
        if (osgiDeployer == null) {
            logger.logp(Level.WARNING, "OSGiContainer", "deploy", "Bundle {0} can't be deployed because corresponding deployer {1} has vanished!!!", new Object[]{b, osgiDeployer});
            return;
        }
        try {
            osgiAppInfo = osgiDeployer.deploy(b);
        }
        catch (Exception e) {
            logger.logp(Level.WARNING, "OSGiContainer", "deploy", "Failed to deploy bundle " + b, e);
            return;
        }
        osgiAppInfo.setDeployer(osgiDeployerRef);
        this.applications.put(b, osgiAppInfo);
        ServiceRegistration reg = this.context.registerService(OSGiApplicationInfo.class.getName(), (Object)osgiAppInfo, (Dictionary)new Properties());
        this.regs.put(osgiAppInfo, reg);
        logger.logp(Level.INFO, "OSGiContainer", "deploy", "deployed bundle {0} at {1}", new Object[]{osgiAppInfo.getBundle(), osgiAppInfo.getAppInfo().getSource().getURI()});
    }

    public synchronized void undeploy(Bundle b) {
        if (this.isShutdown()) {
            return;
        }
        OSGiApplicationInfo osgiAppInfo = this.applications.get(b);
        if (osgiAppInfo == null) {
            throw new RuntimeException("No applications for bundle " + b);
        }
        this.applications.remove(b);
        this.regs.remove(osgiAppInfo).unregister();
        ServiceReference osgiDeployerRef = osgiAppInfo.getDeployer();
        OSGiDeployer osgiDeployer = (OSGiDeployer)this.context.getService(osgiDeployerRef);
        if (osgiDeployer == null) {
            logger.logp(Level.WARNING, "OSGiContainer", "undeploy", "Failed to undeploy {0}, because corresponding deployer does not exist", new Object[]{b});
            return;
        }
        try {
            osgiDeployer.undeploy(osgiAppInfo);
            logger.logp(Level.INFO, "OSGiContainer", "undeploy", "Undeployed bundle {0}", new Object[]{b});
        }
        catch (Exception e) {
            logger.logp(Level.WARNING, "OSGiContainer", "undeploy", "Failed to undeploy bundle " + b, e);
            return;
        }
    }

    public synchronized void undeployAll() {
        for (Bundle b : new HashSet<Bundle>(this.applications.keySet())) {
            try {
                this.undeploy(b);
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, "OSGiContainer", "undeployAll", "Exception undeploying bundle " + b, e);
            }
        }
    }

    public synchronized boolean isDeployed(Bundle bundle) {
        return this.applications.containsKey(bundle);
    }

    boolean isReady(Bundle b) {
        int state = b.getState();
        boolean isActive = (state & 0x20) != 0;
        boolean isStarting = (state & 8) != 0;
        boolean isReady = isActive || OSGiContainer.isLazy(b) && isStarting;
        return isReady;
    }

    static boolean isLazy(Bundle bundle) {
        return "lazy".equals(bundle.getHeaders().get("Bundle-ActivationPolicy"));
    }

    private ServiceReference selectDeployer(Bundle b) {
        for (ServiceReference deployerRef : this.sortedDeployerRefs) {
            OSGiDeployer deployer = (OSGiDeployer)OSGiDeployer.class.cast(this.context.getService(deployerRef));
            if (deployer == null || !deployer.handles(b)) continue;
            return deployerRef;
        }
        return null;
    }

    public synchronized OSGiApplicationInfo[] getDeployedApps() {
        return this.applications.values().toArray(new OSGiApplicationInfo[0]);
    }

    private synchronized void deployerAdded(ServiceReference reference) {
        if (this.isShutdown()) {
            return;
        }
        this.sortedDeployerRefs.add(reference);
        Collections.sort(this.sortedDeployerRefs, Collections.reverseOrder());
        new DeployerAddedThread(reference).start();
    }

    private void deployerRemoved(ServiceReference reference) {
        if (this.isShutdown()) {
            return;
        }
        this.sortedDeployerRefs.remove(reference);
        new DeployerRemovedThread(reference).start();
    }

    private class DeployerRemovedThread
    extends Thread {
        ServiceReference oldDeployerRef;

        private DeployerRemovedThread(ServiceReference oldDeployerRef) {
            this.oldDeployerRef = oldDeployerRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            OSGiContainer oSGiContainer = OSGiContainer.this;
            synchronized (oSGiContainer) {
                for (OSGiApplicationInfo osgiApplicationInfo : OSGiContainer.this.getDeployedApps()) {
                    if (osgiApplicationInfo.getDeployer() != this.oldDeployerRef) continue;
                    try {
                        OSGiContainer.this.redeploy(osgiApplicationInfo.getBundle());
                    }
                    catch (Exception e) {
                        logger.logp(Level.WARNING, "DeployerRemovedThread", "run", "Exception redeploying bundle " + osgiApplicationInfo.getBundle(), e);
                    }
                }
            }
        }
    }

    private class DeployerAddedThread
    extends Thread {
        ServiceReference newDeployerRef;

        private DeployerAddedThread(ServiceReference newDeployerRef) {
            this.newDeployerRef = newDeployerRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            OSGiContainer oSGiContainer = OSGiContainer.this;
            synchronized (oSGiContainer) {
                OSGiDeployer newDeployer = (OSGiDeployer)OSGiContainer.this.context.getService(this.newDeployerRef);
                if (newDeployer == null) {
                    return;
                }
                for (Bundle b : OSGiContainer.this.context.getBundles()) {
                    if (!OSGiContainer.this.isReady(b) || !newDeployer.handles(b)) continue;
                    try {
                        OSGiContainer.this.redeploy(b);
                    }
                    catch (Exception e) {
                        logger.logp(Level.WARNING, "OSGiContainer", "addingService", "Exception redeploying bundle " + b, e);
                    }
                }
            }
        }
    }

    private class OSGiDeployerTracker
    extends ServiceTracker {
        public OSGiDeployerTracker() {
            super(OSGiContainer.this.context, OSGiDeployer.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            OSGiContainer.this.deployerAdded(reference);
            return super.addingService(reference);
        }

        public void removedService(ServiceReference reference, Object service) {
            OSGiContainer.this.deployerRemoved(reference);
            super.removedService(reference, service);
        }
    }
}

