/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.util.KeyTransformer;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.impl.command.Command;

public class ReplicationFramePayloadCommand<K, V>
extends Command {
    private static final transient Logger _logger = Logger.getLogger("org.shoal.ha.cache.command.frame");
    private String targetInstanceName;
    private List<Command<K, V>> commands = new ArrayList<Command<K, V>>();
    private Collection<K> removedKeys = new ArrayList<K>();
    private List<byte[]> rawRemovedKeys = new ArrayList<byte[]>();

    public ReplicationFramePayloadCommand() {
        super((byte)1);
        this.setKey("RepFP:" + System.identityHashCode(this));
    }

    public void addComamnd(Command<K, V> cmd) {
        this.commands.add(cmd);
    }

    public void setTargetInstance(String target) {
        this.targetInstanceName = target;
    }

    void setRemovedKeys(Collection<K> removedKeys) {
        this.removedKeys = removedKeys;
    }

    @Override
    protected boolean beforeTransmit() throws DataStoreException {
        this.setTargetName(this.targetInstanceName);
        return this.targetInstanceName != null;
    }

    private void writeObject(ObjectOutputStream ros) throws IOException {
        try {
            ros.writeObject(this.commands);
            ros.writeBoolean(this.dsc.getKeyTransformer() == null);
            if (this.dsc.getKeyTransformer() == null) {
                ros.writeObject(this.removedKeys);
            } else {
                KeyTransformer kt = this.dsc.getKeyTransformer();
                int sz = this.removedKeys.size();
                this.rawRemovedKeys = new ArrayList<byte[]>();
                for (K k : this.removedKeys) {
                    this.rawRemovedKeys.add(kt.keyToByteArray(k));
                }
                ros.writeObject(this.rawRemovedKeys);
            }
        }
        catch (IOException ioEx) {
            _logger.log(Level.INFO, "Error during ReplicationFramePayloadCommand.writeObject ", ioEx);
            throw ioEx;
        }
    }

    private void readObject(ObjectInputStream ris) throws IOException, ClassNotFoundException {
        try {
            this.commands = (List)ris.readObject();
            boolean ktAbsent = ris.readBoolean();
            if (ktAbsent) {
                this.removedKeys = (List)ris.readObject();
            } else {
                this.rawRemovedKeys = (List)ris.readObject();
            }
        }
        catch (IOException ioEx) {
            _logger.log(Level.INFO, "Error during ReplicationFramePayloadCommand.readObject ", ioEx);
            throw ioEx;
        }
    }

    @Override
    public void execute(String initiator) throws DataStoreException {
        if (this.rawRemovedKeys != null) {
            KeyTransformer kt = this.dsc.getKeyTransformer();
            this.removedKeys = new ArrayList<K>();
            for (byte[] bytes : this.rawRemovedKeys) {
                Object k = kt.byteArrayToKey(bytes, 0, bytes.length);
                this.removedKeys.add(k);
            }
        }
        for (Command<K, V> cmd : this.commands) {
            cmd.initialize(this.dsc);
            this.getCommandManager().executeCommand(cmd, false, initiator);
        }
        if (this.removedKeys != null) {
            for (Command<K, V> k : this.removedKeys) {
                this.dsc.getReplicaStore().remove(k);
            }
        }
    }

    @Override
    public void onSuccess() {
        int sz = this.commands.size();
        for (int i = 0; i < sz; ++i) {
            Command<K, V> cmd = this.commands.get(i);
            cmd.onSuccess();
        }
    }

    @Override
    public void onFailure() {
        int sz = this.commands.size();
        for (int i = 0; i < sz; ++i) {
            Command<K, V> cmd = this.commands.get(i);
            cmd.onFailure();
        }
    }

    @Override
    protected boolean isArtificialKey() {
        return true;
    }

    @Override
    public String toString() {
        return "ReplicationFramePayloadCommand: contains " + this.commands.size() + " commands";
    }
}

