/*
 * Decompiled with CFR 0.152.
 */
package org.shoal.ha.cache.impl.store;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.glassfish.ha.store.api.Storeable;
import org.glassfish.ha.store.util.SimpleMetadata;
import org.shoal.adapter.store.commands.LoadRequestCommand;
import org.shoal.adapter.store.commands.RemoveCommand;
import org.shoal.adapter.store.commands.RemoveExpiredCommand;
import org.shoal.adapter.store.commands.SaveCommand;
import org.shoal.adapter.store.commands.SizeRequestCommand;
import org.shoal.adapter.store.commands.StaleCopyRemoveCommand;
import org.shoal.adapter.store.commands.TouchCommand;
import org.shoal.ha.cache.api.DataStore;
import org.shoal.ha.cache.api.DataStoreContext;
import org.shoal.ha.cache.api.DataStoreException;
import org.shoal.ha.cache.api.DataStoreMBean;
import org.shoal.ha.cache.api.IdleEntryDetector;
import org.shoal.ha.cache.api.ReplicatedDataStoreStatsHolder;
import org.shoal.ha.cache.impl.command.Command;
import org.shoal.ha.cache.impl.command.CommandManager;
import org.shoal.ha.cache.impl.interceptor.ReplicationCommandTransmitterManager;
import org.shoal.ha.cache.impl.interceptor.ReplicationFramePayloadCommand;
import org.shoal.ha.cache.impl.store.DataStoreEntry;
import org.shoal.ha.cache.impl.store.DataStoreEntryUpdater;
import org.shoal.ha.cache.impl.store.ReplicaStore;
import org.shoal.ha.cache.impl.store.SimpleDataStoreEntryUpdater;
import org.shoal.ha.cache.impl.store.SimpleStoreableDataStoreEntryUpdater;
import org.shoal.ha.cache.impl.store.StoreableDataStoreEntryUpdater;
import org.shoal.ha.cache.impl.util.CommandResponse;
import org.shoal.ha.cache.impl.util.ResponseMediator;
import org.shoal.ha.cache.impl.util.StringKeyTransformer;
import org.shoal.ha.group.GroupMemberEventListener;
import org.shoal.ha.group.GroupService;
import org.shoal.ha.mapper.DefaultKeyMapper;
import org.shoal.ha.mapper.KeyMapper;

public class ReplicatedDataStore<K, V extends Serializable>
implements DataStore<K, V> {
    private static final int MAX_REPLICA_TRIES = 1;
    private static final Logger _logger = Logger.getLogger("org.shoal.ha.cache.store");
    private static final Logger _loadLogger = Logger.getLogger("org.shoal.ha.cache.command.load_request");
    private static final Logger _saveLogger = Logger.getLogger("org.shoal.ha.cache.command.save");
    private String storeName;
    private String instanceName;
    private String groupName;
    private GroupService gs;
    private CommandManager<K, V> cm;
    private DataStoreContext<K, V> dsc;
    private ReplicaStore<K, V> replicaStore;
    private long defaultIdleTimeoutInMillis;
    private ReplicatedDataStoreStatsHolder<K, V> dscMBean;
    private String debugName = "ReplicatedDataStore";
    private MBeanServer mbs;
    private ObjectName mbeanObjectName;

    public ReplicatedDataStore(DataStoreContext<K, V> conf, GroupService gs) {
        this.dsc = conf;
        this.storeName = conf.getStoreName();
        this.gs = gs;
        this.instanceName = gs.getMemberName();
        this.groupName = gs.getGroupName();
        this.initialize();
        this.postInitialization();
        this.debugName = conf.getStoreName() + ": ";
    }

    public DataStoreContext<K, V> getDataStoreContext() {
        return this.dsc;
    }

    private void initialize() {
        this.dsc.setGroupService(this.gs);
        if (this.dsc.getClassLoader() == null) {
            ClassLoader loader = this.dsc.getValueClazz().getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            this.dsc.setClassLoader(loader);
        }
        if (this.dsc.getKeyMapper() == null) {
            this.dsc.setKeyMapper(new DefaultKeyMapper(this.dsc.getInstanceName(), this.dsc.getGroupName()));
        }
        if (this.dsc.getKeyMapper() instanceof GroupMemberEventListener) {
            GroupMemberEventListener groupListener = (GroupMemberEventListener)((Object)this.dsc.getKeyMapper());
            this.gs.registerGroupMemberEventListener(groupListener);
        }
        if (this.dsc.getKeyTransformer() == null) {
            StringKeyTransformer kt = null;
            if (this.dsc.getKeyClazz() == String.class) {
                kt = new StringKeyTransformer();
            }
            this.dsc.setKeyTransformer(kt);
        }
    }

    private void postInitialization() {
        Class vClazz = this.dsc.getValueClazz();
        DataStoreEntryUpdater dseUpdater = null;
        if (this.dsc.isDoSynchronousReplication()) {
            dseUpdater = new SimpleDataStoreEntryUpdater<K, V>();
        } else if (SimpleMetadata.class.isAssignableFrom(vClazz)) {
            dseUpdater = new SimpleStoreableDataStoreEntryUpdater();
        } else if (Storeable.class.isAssignableFrom(vClazz)) {
            dseUpdater = new StoreableDataStoreEntryUpdater();
            this.dsc.setUseMapToCacheCommands(false);
        } else {
            dseUpdater = new SimpleDataStoreEntryUpdater();
        }
        dseUpdater.initialize(this.dsc);
        this.dsc.setDataStoreEntryUpdater(dseUpdater);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ReplicatedDataStore For {" + this.dsc.getStoreName() + "} using DataStoreEntryUpdater = " + this.dsc.getDataStoreEntryUpdater().getClass().getName());
        }
        this.cm = new CommandManager();
        this.dsc.setCommandManager(this.cm);
        this.cm.initialize(this.dsc);
        if (this.dsc.getCommands() != null) {
            for (Command cmd : this.dsc.getCommands()) {
                this.cm.registerCommand(cmd);
            }
        }
        this.cm.registerExecutionInterceptor(new ReplicationCommandTransmitterManager());
        this.cm.registerCommand(new ReplicationFramePayloadCommand());
        KeyMapper keyMapper = this.dsc.getKeyMapper();
        if (keyMapper != null && keyMapper instanceof DefaultKeyMapper) {
            this.gs.registerGroupMemberEventListener((DefaultKeyMapper)keyMapper);
        }
        this.dsc.setResponseMediator(new ResponseMediator());
        this.replicaStore = new ReplicaStore<K, V>(this.dsc);
        this.dsc.setReplicaStore(this.replicaStore);
        this.gs.registerGroupMessageReceiver(this.storeName, this.cm);
        this.initIdleEntryProcessor();
        this.replicaStore = this.dsc.getReplicaStore();
        this.replicaStore.setIdleEntryDetector(this.dsc.getIdleEntryDetector());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Created ReplicatedDataStore with configuration = " + this.dsc);
        }
        this.dscMBean = new ReplicatedDataStoreStatsHolder<K, V>(this.dsc);
        this.dsc.setDataStoreMBean(this.dscMBean);
        boolean registerInMBeanServer = Boolean.getBoolean("org.shoal.ha.cache.mbean.register");
        if (registerInMBeanServer) {
            try {
                this.mbeanObjectName = new ObjectName("org.shoal.ha.cache.jmx.ReplicatedDataStore:name=" + this.dsc.getStoreName() + "_" + this.dsc.getInstanceName());
                this.mbs = ManagementFactory.getPlatformMBeanServer();
                this.mbs.registerMBean(new StandardMBean(this.dscMBean, DataStoreMBean.class), this.mbeanObjectName);
            }
            catch (MalformedObjectNameException malEx) {
                _logger.log(Level.INFO, "Couldn't register MBean for " + this.dscMBean.getStoreName() + " : " + malEx);
            }
            catch (InstanceAlreadyExistsException malEx) {
                _logger.log(Level.INFO, "Couldn't register MBean for " + this.dscMBean.getStoreName() + " : " + malEx);
            }
            catch (MBeanRegistrationException malEx) {
                _logger.log(Level.INFO, "Couldn't register MBean for " + this.dscMBean.getStoreName() + " : " + malEx);
            }
            catch (NotCompliantMBeanException malEx) {
                _logger.log(Level.INFO, "Couldn't register MBean for " + this.dscMBean.getStoreName() + " : " + malEx);
            }
        }
    }

    private void initIdleEntryProcessor() {
        try {
            if (Storeable.class.isAssignableFrom(this.dsc.getValueClazz())) {
                this.dsc.setIdleEntryDetector(new IdleEntryDetector<K, V>(){

                    @Override
                    public boolean isIdle(DataStoreEntry<K, V> entry, long nowInMillis) {
                        _logger.log(Level.FINE, "AccessTimeInfo: getLastAccessedAt=" + entry.getLastAccessedAt() + "; maxIdleTimeInMillis=" + entry.getMaxIdleTime() + " < now=" + nowInMillis);
                        return entry.getMaxIdleTime() > 0L && entry.getLastAccessedAt() + entry.getMaxIdleTime() < nowInMillis;
                    }
                });
            } else if (this.dsc.getDefaultMaxIdleTimeInMillis() > 0L) {
                final long defaultMaxIdleTimeInMillis = this.dsc.getDefaultMaxIdleTimeInMillis();
                this.dsc.setIdleEntryDetector(new IdleEntryDetector<K, V>(){

                    @Override
                    public boolean isIdle(DataStoreEntry<K, V> entry, long nowInMillis) {
                        _logger.log(Level.FINE, "AccessTimeInfo: getLastAccessedAt=" + entry.getLastAccessedAt() + "; defaultMaxIdleTimeInMillis=" + defaultMaxIdleTimeInMillis + " < now=" + nowInMillis);
                        return defaultMaxIdleTimeInMillis > 0L && entry.getLastAccessedAt() + defaultMaxIdleTimeInMillis < nowInMillis;
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String put(K k, V v) throws DataStoreException {
        DataStoreEntry<K, V> entry;
        String result = null;
        DataStoreEntry<K, V> dataStoreEntry = entry = this.replicaStore.getOrCreateEntry(k);
        synchronized (dataStoreEntry) {
            if (!entry.isRemoved()) {
                SaveCommand cmd = this.dsc.getDataStoreEntryUpdater().createSaveCommand(entry, k, v);
                this.cm.execute(cmd);
                this.dscMBean.incrementSaveCount();
                if (this.dsc.isCacheLocally()) {
                    entry.setV(v);
                }
                String staleLocation = entry.setReplicaInstanceName(cmd.getTargetName());
                result = cmd.getKeyMappingInfo();
                if (staleLocation != null && !staleLocation.equals(cmd.getTargetName())) {
                    StaleCopyRemoveCommand staleCmd = new StaleCopyRemoveCommand(k);
                    staleCmd.setStaleTargetName(staleLocation);
                    this.cm.execute(staleCmd);
                }
            } else {
                _logger.log(Level.WARNING, "ReplicatedDataStore.put(" + k + ") AFTER remove?");
                return "";
            }
        }
        if (_saveLogger.isLoggable(Level.FINE)) {
            _saveLogger.log(Level.FINE, this.debugName + " done save(" + k + ") to " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) throws DataStoreException {
        this.dscMBean.incrementLoadCount();
        Serializable v = null;
        boolean foundLocally = false;
        DataStoreEntry<K, Serializable> entry = this.replicaStore.getEntry(key);
        if (entry != null) {
            if (!entry.isRemoved()) {
                v = (Serializable)this.dsc.getDataStoreEntryUpdater().getV(entry);
                if (v != null) {
                    foundLocally = true;
                    this.dscMBean.incrementLocalLoadSuccessCount();
                    if (_loadLogger.isLoggable(Level.FINE)) {
                        _loadLogger.log(Level.FINE, this.debugName + "load(" + key + "); FOUND IN LOCAL CACHE!!");
                    }
                }
            } else {
                return null;
            }
        }
        if (v == null) {
            KeyMapper keyMapper = this.dsc.getKeyMapper();
            String replicachoices = keyMapper.getReplicaChoices(this.dsc.getGroupName(), key);
            String[] replicaHint = replicachoices.split(":");
            if (_loadLogger.isLoggable(Level.FINE)) {
                _loadLogger.log(Level.FINE, this.debugName + "load(" + key + "); ReplicaChoices: " + replicachoices);
            }
            String respondingInstance = null;
            for (int replicaIndex = 0; replicaIndex < replicaHint.length && replicaIndex < 1; ++replicaIndex) {
                String target = replicaHint[replicaIndex];
                if (target == null || target.trim().length() == 0 || target.equals(this.dsc.getInstanceName())) continue;
                LoadRequestCommand command = new LoadRequestCommand(key, entry == null ? -8L : entry.getVersion(), target);
                if (_loadLogger.isLoggable(Level.FINE)) {
                    _loadLogger.log(Level.FINE, this.debugName + "load(" + key + ") Trying to load from Replica[" + replicaIndex + "]: " + replicaHint[replicaIndex]);
                }
                this.cm.execute(command);
                v = (Serializable)command.getResult(3L, TimeUnit.SECONDS);
                if (v == null) continue;
                respondingInstance = command.getRespondingInstanceName();
                this.dscMBean.incrementSimpleLoadSuccessCount();
                break;
            }
            if (v == null) {
                String[] targetInstances;
                if (_loadLogger.isLoggable(Level.FINE)) {
                    _loadLogger.log(Level.FINE, this.debugName + "*load(" + key + ") Performing broadcast load");
                }
                for (String targetInstance : targetInstances = this.dsc.getKeyMapper().getCurrentMembers()) {
                    if (targetInstance.equals(this.dsc.getInstanceName())) continue;
                    LoadRequestCommand lrCmd = new LoadRequestCommand(key, entry == null ? -8L : entry.getVersion(), targetInstance);
                    if (_loadLogger.isLoggable(Level.FINE)) {
                        _loadLogger.log(Level.FINE, this.debugName + "*load(" + key + ") Trying to load from " + targetInstance);
                    }
                    this.cm.execute(lrCmd);
                    v = (Serializable)lrCmd.getResult(3L, TimeUnit.SECONDS);
                    if (v == null) continue;
                    respondingInstance = targetInstance;
                    this.dscMBean.incrementBroadcastLoadSuccessCount();
                    break;
                }
            }
            if (v != null) {
                entry = this.replicaStore.getEntry(key);
                if (entry != null) {
                    DataStoreEntry<K, Serializable> dataStoreEntry = entry;
                    synchronized (dataStoreEntry) {
                        if (!entry.isRemoved()) {
                            if (this.dsc.isCacheLocally()) {
                                entry.setV(v);
                            }
                            entry.setLastAccessedAt(System.currentTimeMillis());
                            entry.setReplicaInstanceName(respondingInstance);
                            if (_loadLogger.isLoggable(Level.FINE)) {
                                _loadLogger.log(Level.FINE, this.debugName + "load(" + key + "; Successfully loaded data from " + respondingInstance);
                            }
                            this.dscMBean.incrementLoadSuccessCount();
                        } else {
                            if (_loadLogger.isLoggable(Level.FINE)) {
                                _loadLogger.log(Level.FINE, this.debugName + "load(" + key + "; Got data from " + respondingInstance + ", but another concurrent thread removed the entry");
                            }
                            this.dscMBean.incrementLoadFailureCount();
                        }
                    }
                }
            } else {
                this.dscMBean.incrementLoadFailureCount();
            }
        }
        if (_loadLogger.isLoggable(Level.FINE)) {
            _loadLogger.log(Level.FINE, this.debugName + "load(" + key + ") Final result: " + v);
        }
        if (v != null && foundLocally) {
            try {
                String secondaryReplica = this.put(key, (V)v);
                if (_logger.isLoggable(Level.FINE)) {
                    _saveLogger.log(Level.FINE, "(SaveOnLoad) Saved the data to replica: " + secondaryReplica);
                }
            }
            catch (DataStoreException dsEx) {
                _saveLogger.log(Level.WARNING, "(SaveOnLoad) Failed to save data after a load", dsEx);
            }
        }
        return (V)v;
    }

    @Override
    public void remove(K k) throws DataStoreException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "DataStore.remove(" + k + ") CALLED ****");
        }
        this.replicaStore.remove(k);
        this.dscMBean.incrementRemoveCount();
        String[] targets = this.dsc.getKeyMapper().getCurrentMembers();
        if (targets != null) {
            for (String target : targets) {
                RemoveCommand cmd = new RemoveCommand(k);
                cmd.setTarget(target);
                this.cm.execute(cmd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String touch(K k, long version, long ts, long ttl) throws DataStoreException {
        String location = "";
        DataStoreEntry<K, V> entry = this.replicaStore.getEntry(k);
        if (entry != null) {
            DataStoreEntry<K, V> dataStoreEntry = entry;
            synchronized (dataStoreEntry) {
                long now = System.currentTimeMillis();
                entry.setLastAccessedAt(now);
                String target = entry.getReplicaInstanceName();
                TouchCommand cmd = new TouchCommand(k, version, now, this.defaultIdleTimeoutInMillis);
                this.cm.execute(cmd);
                location = cmd.getKeyMappingInfo();
            }
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeIdleEntries(long idleFor) {
        String[] targets = this.dsc.getKeyMapper().getCurrentMembers();
        ResponseMediator respMed = this.dsc.getResponseMediator();
        CommandResponse resp = respMed.createCommandResponse();
        long tokenId = resp.getTokenId();
        FutureTask future = resp.getFuture();
        resp.setTransientResult(new Integer(0));
        int finalResult = 0;
        try {
            if (targets != null && this.dsc.isBroadcastRemovedExpired()) {
                resp.setExpectedUpdateCount(targets.length);
                for (String target : targets) {
                    RemoveExpiredCommand cmd = new RemoveExpiredCommand(idleFor, tokenId);
                    cmd.setTarget(target);
                    try {
                        this.cm.execute(cmd);
                    }
                    catch (DataStoreException dse) {
                        _logger.log(Level.INFO, "Exception during removeIdleEntries...", dse);
                    }
                }
            }
            int localResult = this.replicaStore.removeExpired();
            CommandResponse commandResponse = resp;
            synchronized (commandResponse) {
                Integer existingValue = (Integer)resp.getTransientResult();
                Integer newResult = new Integer(existingValue + localResult);
                resp.setTransientResult(newResult);
            }
            finalResult = (Integer)resp.getTransientResult();
            finalResult = (Integer)future.get(6L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
        }
        finally {
            respMed.removeCommandResponse(tokenId);
        }
        return finalResult;
    }

    @Override
    public void close() {
        try {
            if (this.mbs != null && this.mbeanObjectName != null) {
                this.mbs.unregisterMBean(this.mbeanObjectName);
            }
        }
        catch (InstanceNotFoundException inNoEx) {
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            // empty catch block
        }
    }

    @Override
    public int size() {
        int i;
        int result = 0;
        KeyMapper km = this.dsc.getKeyMapper();
        String[] targets = km.getCurrentMembers();
        int targetCount = targets.length;
        SizeRequestCommand[] commands = new SizeRequestCommand[targetCount];
        for (i = 0; i < targetCount; ++i) {
            commands[i] = new SizeRequestCommand(targets[i]);
            try {
                this.dsc.getCommandManager().execute(commands[i]);
                continue;
            }
            catch (DataStoreException dse) {
                // empty catch block
            }
        }
        for (i = 0; i < targetCount; ++i) {
            result += commands[i].getResult();
        }
        return result;
    }
}

