/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationPartitioningPolicy
extends PartitioningPolicy {
    protected List<String> connectionPools;

    public ReplicationPartitioningPolicy() {
        this.connectionPools = new ArrayList<String>();
    }

    public ReplicationPartitioningPolicy(String ... pools) {
        this();
        this.connectionPools.addAll(Arrays.asList(pools));
    }

    public ReplicationPartitioningPolicy(List<String> pools) {
        this.connectionPools = pools;
    }

    @Override
    public void initialize(AbstractSession session) {
        super.initialize(session);
        if (this.getConnectionPools().isEmpty() && session.isServerSession()) {
            this.getConnectionPools().addAll(((ServerSession)session).getConnectionPools().keySet());
        }
    }

    public List<String> getConnectionPools() {
        return this.connectionPools;
    }

    public void setConnectionPools(List<String> connectionPools) {
        this.connectionPools = connectionPools;
    }

    public void addConnectionPool(String connectionPool) {
        this.getConnectionPools().add(connectionPool);
    }

    @Override
    public List<Accessor> getConnectionsForQuery(AbstractSession session, DatabaseQuery query, AbstractRecord arguments) {
        if (!query.isModifyQuery()) {
            return null;
        }
        ArrayList<Accessor> accessors = new ArrayList<Accessor>(this.connectionPools.size());
        for (String poolName : this.connectionPools) {
            accessors.add(this.getAccessor(poolName, session, query));
        }
        return accessors;
    }
}

