/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.wls;

import java.lang.reflect.Method;
import java.security.AccessController;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.platform.server.JMXEnabledPlatform;
import org.eclipse.persistence.platform.server.wls.WebLogic_9_Platform;
import org.eclipse.persistence.services.weblogic.MBeanWebLogicRuntimeServices;
import org.eclipse.persistence.sessions.DatabaseSession;

public class WebLogic_10_Platform
extends WebLogic_9_Platform
implements JMXEnabledPlatform {
    private static final String JMX_JNDI_RUNTIME_REGISTER = "java:comp/env/jmx/runtime";
    private static final String JMX_JNDI_RUNTIME_UNREGISTER = "java:comp/jmx/runtime";
    protected static final String SERVER_SPECIFIC_MODULENAME_PROPERTY = "eclipselink.weblogic.moduleName";
    protected static final String SERVER_SPECIFIC_APPLICATIONNAME_PROPERTY = "eclipselink.weblogic.applicationName";
    private ObjectName wlsThreadPoolRuntime = null;
    private static final String WLS_SERVICE_KEY = "com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean";
    private static final String WLS_SERVER_RUNTIME = "ServerRuntime";
    private static final String WLS_THREADPOOL_RUNTIME = "ThreadPoolRuntime";
    private static final String WLS_EXECUTE_THREAD_GET_METHOD_NAME = "getExecuteThread";
    private static final String WLS_APPLICATION_NAME_GET_METHOD_NAME = "getApplicationName";
    private static final String WLS_MODULE_NAME_GET_METHOD_NAME = "getModuleName";
    private static final String WLS_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX = "annotation: ";

    public WebLogic_10_Platform(DatabaseSession newDatabaseSession) {
        super(newDatabaseSession);
        this.enableRuntimeServices();
        this.prepareServerSpecificServicesMBean();
    }

    public boolean isRuntimeServicesEnabledDefault() {
        return true;
    }

    public void prepareServerSpecificServicesMBean() {
        if (this.shouldRegisterRuntimeBean) {
            this.setRuntimeServicesMBean(new MBeanWebLogicRuntimeServices(this.getDatabaseSession()));
        }
    }

    public void serverSpecificRegisterMBean() {
        super.serverSpecificRegisterMBean();
        this.initializeApplicationNameAndModuleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public MBeanServer getMBeanServer() {
        block18: {
            if (null == this.mBeanServer) {
                InitialContext initialContext;
                block17: {
                    initialContext = null;
                    initialContext = new InitialContext();
                    this.mBeanServer = (MBeanServer)initialContext.lookup(JMX_JNDI_RUNTIME_REGISTER);
                    if (null == this.mBeanServer) {
                        this.getAbstractSession().log(6, "server", "failed_to_find_mbean_server", "null returned from JNDI lookup of java:comp/env/jmx/runtime");
                        break block17;
                    }
                    if (this.mBeanServer.toString().indexOf("WLSMBeanServer") < 0) {
                        this.getAbstractSession().log(1, "server", "sequencing_connected", null);
                    }
                    this.getAbstractSession().log(2, "server", "jmx_mbean_runtime_services_registration_mbeanserver_print", new Object[]{this.mBeanServer, this.mBeanServer.getMBeanCount(), this.mBeanServer.getDefaultDomain(), 0});
                }
                Object var4_2 = null;
                try {
                    if (null != initialContext) {
                        initialContext.close();
                    }
                    break block18;
                }
                catch (NamingException ne2) {}
                break block18;
                {
                    catch (NamingException ne) {
                        this.getAbstractSession().log(6, "server", "failed_to_find_mbean_server", ne);
                        Object var4_3 = null;
                        try {
                            if (null != initialContext) {
                                initialContext.close();
                            }
                            break block18;
                        }
                        catch (NamingException ne2) {}
                        break block18;
                    }
                    catch (Exception exception) {
                        this.getAbstractSession().log(6, "server", "problem_registering_mbean", exception);
                        Object var4_4 = null;
                        try {
                            if (null != initialContext) {
                                initialContext.close();
                            }
                            break block18;
                        }
                        catch (NamingException ne2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    try {
                        if (null != initialContext) {
                            initialContext.close();
                        }
                    }
                    catch (NamingException ne2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return this.mBeanServer;
    }

    protected void initializeApplicationNameAndModuleName() {
        String jpaModuleName = (String)this.getDatabaseSession().getProperty(SERVER_SPECIFIC_MODULENAME_PROPERTY);
        String jpaApplicationName = (String)this.getDatabaseSession().getProperty(SERVER_SPECIFIC_APPLICATIONNAME_PROPERTY);
        if (jpaModuleName != null) {
            this.setModuleName(jpaModuleName);
        } else {
            jpaModuleName = this.getModuleOrApplicationName(WLS_MODULE_NAME_GET_METHOD_NAME);
            if (null != jpaModuleName && jpaModuleName.indexOf("@") != -1) {
                this.setModuleName(jpaModuleName.substring(jpaModuleName.indexOf("@") + 1));
            } else {
                this.setModuleName(jpaModuleName);
            }
        }
        if (jpaApplicationName != null) {
            this.setApplicationName(jpaApplicationName);
        } else {
            jpaApplicationName = this.getModuleOrApplicationName(WLS_APPLICATION_NAME_GET_METHOD_NAME);
            if (null == jpaApplicationName) {
                jpaApplicationName = super.getApplicationName();
            }
            if (null != jpaApplicationName && jpaApplicationName.indexOf("@") > -1) {
                this.setApplicationName(jpaApplicationName.substring(jpaApplicationName.indexOf("@") + 1));
            } else {
                this.setApplicationName(jpaApplicationName);
            }
        }
        if (null == this.getApplicationName()) {
            this.setApplicationName(DEFAULT_SERVER_NAME_AND_VERSION);
        }
        if (null == this.getModuleName()) {
            this.setModuleName(DEFAULT_SERVER_NAME_AND_VERSION);
        }
        this.getAbstractSession().log(1, "server", "mbean_get_application_name", this.getDatabaseSession().getName(), this.getApplicationName());
        this.getAbstractSession().log(1, "server", "mbean_get_module_name", this.getDatabaseSession().getName(), this.getModuleName());
    }

    private String getModuleOrApplicationName(String getMethodName) {
        Object classLoaderOrString = null;
        Object executeThread = this.getExecuteThreadFromMBean();
        if (executeThread != null) {
            try {
                int startIndex;
                String jpaModuleNameRoot;
                Method getMethod = PrivilegedAccessHelper.getPublicMethod(executeThread.getClass(), getMethodName, new Class[0], false);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    AccessController.doPrivileged(new PrivilegedMethodInvoker(getMethod, executeThread, null));
                } else {
                    classLoaderOrString = PrivilegedAccessHelper.invokeMethod(getMethod, executeThread);
                }
                if (classLoaderOrString instanceof ClassLoader && null != (jpaModuleNameRoot = ((ClassLoader)classLoaderOrString).toString()) && (startIndex = jpaModuleNameRoot.indexOf(WLS_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX)) > -1) {
                    classLoaderOrString = jpaModuleNameRoot.substring(startIndex + WLS_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX.length());
                }
            }
            catch (Exception ex) {
                this.getAbstractSession().log(6, "server", "problem_with_reflective_weblogic_call_mbean", ex, getMethodName);
            }
        }
        return (String)classLoaderOrString;
    }

    private Object getExecuteThreadFromMBean() {
        if (this.getMBeanServer() != null) {
            if (this.wlsThreadPoolRuntime == null) {
                try {
                    ObjectName service = new ObjectName(WLS_SERVICE_KEY);
                    ObjectName serverRuntime = (ObjectName)this.getMBeanServer().getAttribute(service, WLS_SERVER_RUNTIME);
                    this.wlsThreadPoolRuntime = (ObjectName)this.getMBeanServer().getAttribute(serverRuntime, WLS_THREADPOOL_RUNTIME);
                }
                catch (Exception ex) {
                    this.getAbstractSession().log(6, "server", "jmx_mbean_runtime_services_threadpool_initialize_failed", ex);
                }
            }
            if (this.wlsThreadPoolRuntime != null) {
                try {
                    return this.getMBeanServer().invoke(this.wlsThreadPoolRuntime, WLS_EXECUTE_THREAD_GET_METHOD_NAME, new Object[]{Thread.currentThread().getName()}, new String[]{String.class.getName()});
                }
                catch (Exception ex) {
                    this.getAbstractSession().log(6, "server", "jmx_mbean_runtime_services_get_executethreadruntime_object_failed", ex);
                }
            }
        }
        return null;
    }

    protected Method getVendorConnectionMethod() {
        if (this.vendorConnectionMethod == null && !this.getWebLogicConnectionClass().equals(Void.TYPE)) {
            try {
                this.vendorConnectionMethod = PrivilegedAccessHelper.getDeclaredMethod(this.getWebLogicConnectionClass(), "getVendorConnectionSafe", new Class[0]);
            }
            catch (NoSuchMethodException not1034) {
                try {
                    this.vendorConnectionMethod = PrivilegedAccessHelper.getDeclaredMethod(this.getWebLogicConnectionClass(), "getVendorConnection", new Class[0]);
                }
                catch (NoSuchMethodException exception) {
                    this.getDatabaseSession().getSessionLog().logThrowable(6, exception);
                }
            }
        }
        return this.vendorConnectionMethod;
    }

    static {
        APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_PREFIX = "/deploy/";
        APP_SERVER_CLASSLOADER_MODULE_EJB_SEARCH_STRING_PREFIX = ".jar/";
        APP_SERVER_CLASSLOADER_MODULE_WAR_SEARCH_STRING_PREFIX = ".war/";
        APP_SERVER_CLASSLOADER_APPLICATION_PU_SEARCH_STRING_POSTFIX = "postfix,match~not;required^";
        APP_SERVER_CLASSLOADER_MODULE_EJB_WAR_SEARCH_STRING_POSTFIX = "postfix,match~not;required^";
    }
}

